/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export;

import com.nexacro.java.xapi.data.VariableList;
import java.util.HashMap;
import java.util.Map;

public class GridExportContext {
    private String appendUrl = null;
    private String sheetName = "Sheet";
    private String requestType = "PlatformSsv";
    private String responseType = "PlatformSsv";
    private String absolutePath = null;
    private String downloadUrl = null;
    private String password = null;
    private String itemName;
    private String instanceId = null;
    private String fileName;
    private int startColIndex = 0;
    private int startRowIndex = 0;
    private int limitRowCount = 0x100000;
    private int rowAccessSize = 100;
    private int exportType = 288;
    private int sequence = 0;
    private float commandVersion = 1.0f;
    private boolean isOoxml = true;
    private boolean isNoHead = false;
    private boolean isNoSummary = false;
    private boolean isTopSummary = false;
    private boolean isApplyWidth = true;
    private boolean isApplyHeight = false;
    private boolean isOutsidePath = false;
    private boolean isWrapText = true;
    private boolean isRtl = false;
    private boolean isCsvQuote = true;
    private boolean isCsvBom = true;
    private boolean isApi = false;
    private VariableList userVarList = null;
    Map<Integer, Integer> rowHeights = null;

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public String getAppendUrl() {
        return this.appendUrl;
    }

    public void setAppendUrl(String string) {
        if (string != null && string.length() > 0) {
            this.appendUrl = string;
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public int getStartColIndex() {
        return this.startColIndex;
    }

    public void setStartColIndex(int n) {
        this.startColIndex = n;
    }

    public int getStartRowIndex() {
        return this.startRowIndex;
    }

    public void setCommandVersion(float f) {
        this.commandVersion = f;
    }

    public float getCommandVersion() {
        return this.commandVersion;
    }

    public void setStartRowIndex(int n) {
        this.startRowIndex = n;
    }

    public boolean isOoxml() {
        return this.isOoxml;
    }

    public void setOoxml(boolean bl) {
        this.isOoxml = bl;
        if (!bl) {
            this.limitRowCount = 65536;
        }
    }

    public boolean isNoHead() {
        return this.isNoHead;
    }

    public void setNoHead(boolean bl) {
        this.isNoHead = bl;
    }

    public boolean isNoSummary() {
        return this.isNoSummary;
    }

    public void setNoSummary(boolean bl) {
        this.isNoSummary = bl;
    }

    public boolean isTopSummary() {
        return this.isTopSummary;
    }

    public void setTopSummary(boolean bl) {
        this.isTopSummary = bl;
    }

    public boolean isApplyWidth() {
        return this.isApplyWidth;
    }

    public void setApplyWidth(boolean bl) {
        this.isApplyWidth = bl;
    }

    public boolean isApplyHeight() {
        return this.isApplyHeight;
    }

    public void setApplyHeight(boolean bl) {
        this.isApplyHeight = bl;
    }

    public void setRequestPlatformType(String string) {
        this.requestType = string;
    }

    public String getRequestPlatformType() {
        return this.requestType;
    }

    public void setResponsePlatformType(String string) {
        if (string != null) {
            if ("xml".equalsIgnoreCase(string)) {
                this.responseType = "PlatformXml";
            } else if ("json".equalsIgnoreCase(string)) {
                this.responseType = "PlatformJson";
            } else if ("binary".equalsIgnoreCase(string)) {
                this.responseType = "PlatformBinary";
            }
        }
    }

    public String getResponsePlatformType() {
        return this.responseType;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String string) {
        this.absolutePath = string;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String string) {
        this.downloadUrl = string;
    }

    public boolean isOutsidePath() {
        return this.isOutsidePath;
    }

    public void setOutsidePath(boolean bl) {
        this.isOutsidePath = bl;
    }

    public VariableList getUserVariableList() {
        return this.userVarList;
    }

    public void setUserVariableList(VariableList variableList) {
        String string;
        this.userVarList = variableList;
        int n = this.userVarList.getInt("accesswindowsize");
        if (n > 0) {
            this.rowAccessSize = n;
        }
        if (this.userVarList.contains("csvbom")) {
            this.isCsvBom = this.userVarList.getBoolean("csvbom");
        }
        if (this.userVarList.contains("rowheight") && (string = this.userVarList.getString("rowheight")) != null && string.length() > 0) {
            String[] stringArray;
            this.rowHeights = new HashMap<Integer, Integer>();
            for (String string2 : stringArray = string.split("\\,")) {
                String[] stringArray2 = string2.split("\\:");
                if (stringArray2.length < 2) continue;
                this.rowHeights.put(Integer.parseInt(stringArray2[0].trim()), Integer.parseInt(stringArray2[1].trim()));
            }
        }
    }

    public Map<Integer, Integer> getRowHeights() {
        return this.rowHeights;
    }

    public int getRowAccessSize() {
        return this.rowAccessSize;
    }

    public boolean isWrapText() {
        return this.isWrapText;
    }

    public void setWrapText(boolean bl) {
        this.isWrapText = bl;
    }

    public boolean isRtl() {
        return this.isRtl;
    }

    public void setRtl(boolean bl) {
        this.isRtl = bl;
    }

    public boolean isCsvQuote() {
        return this.isCsvQuote;
    }

    public void setCsvQuote(boolean bl) {
        this.isCsvQuote = bl;
    }

    public boolean isCsvBom() {
        return this.isCsvBom;
    }

    public void setCsvBom(boolean bl) {
        this.isCsvBom = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isApi() {
        return this.isApi;
    }

    public void setApi(boolean bl) {
        this.isApi = bl;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public int getExportType() {
        return this.exportType;
    }

    public void setExportType(int n) {
        this.exportType = n;
        this.setOoxml(n == 288 || n == 1040);
    }
}

