/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.api;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.export.impl.GridPartExportExcel;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class GridExportExcel {
    private static final Log log = LogFactory.getLog(GridExportExcel.class);
    private String securityPattern;
    private String securityPattern2;
    GridPartExportExcel excelExportor = new GridPartExportExcel();
    GridExportContext exportContext = new GridExportContext();
    ServletProvider svltProvider;
    DataSet dsCommand;
    DataSet dsStyle;
    DataSet dsCell;
    int errorCode = 0;

    public GridExportExcel(ServletProvider servletProvider) {
        this.svltProvider = servletProvider;
        this.dsCommand = null;
        this.dsStyle = null;
        this.dsCell = null;
        this.securityPattern = XeniProperties.getStringProperty("xeni.security.pattern");
        if (this.securityPattern == null || this.securityPattern.length() <= 0) {
            this.securityPattern = "'|\"|:|;|\\(|\\)|<|>|\\[|\\]|\\{|\\}|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
            this.securityPattern2 = "'|\"|:|;|<|>|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
        } else {
            this.securityPattern2 = this.securityPattern;
        }
        String string = XeniProperties.getStringProperty("xeni.guard.maxentry.size", null);
        String string2 = XeniProperties.getStringProperty("xeni.guard.maxtext.size", null);
        String string3 = XeniProperties.getStringProperty("xeni.guard.mininflate.ratio", null);
        if (string != null) {
            ZipSecureFile.setMaxEntrySize((long)Long.parseLong(string));
        }
        if (string2 != null) {
            ZipSecureFile.setMaxTextSize((long)Long.parseLong(string2));
        }
        if (string3 != null) {
            ZipSecureFile.setMinInflateRatio((double)Double.parseDouble(string3));
        }
    }

    GridPartExportExcel getExcelExportor() {
        if (this.excelExportor == null) {
            this.excelExportor = new GridPartExportExcel();
        }
        return this.excelExportor;
    }

    public GridExportContext getExportContext() {
        if (this.exportContext == null) {
            this.exportContext = new GridExportContext();
        }
        return this.exportContext;
    }

    public GridExportContext receiveData() throws IOException, PlatformException {
        if (this.svltProvider == null || this.svltProvider.getHttpServletRequest() == null) {
            String string = "Http servlet request is null.";
            this.sendErrorMessage(-2006, string);
            throw new IOException(string);
        }
        PlatformRequest platformRequest = null;
        try {
            platformRequest = new PlatformRequest((InputStream)this.svltProvider.getHttpServletRequest().getInputStream());
            platformRequest.receiveData();
        }
        catch (PlatformException platformException) {
            this.sendErrorMessage(-3101, platformException.getMessage());
            throw platformException;
        }
        catch (IOException iOException) {
            this.sendErrorMessage(-3101, iOException.getMessage());
            throw iOException;
        }
        PlatformData platformData = platformRequest.getData();
        if (platformData == null) {
            String string = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            this.sendErrorMessage(-2006, string);
            throw new IOException(string);
        }
        DataSetList dataSetList = platformData.getDataSetList();
        VariableList variableList = platformData.getVariableList();
        this.dsCommand = dataSetList.get("COMMAND");
        if (this.dsCommand == null) {
            String string = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            this.sendErrorMessage(-2006, string);
            throw new IOException(string);
        }
        this.dsStyle = dataSetList.get("STYLE");
        String string = this.dsCommand.getString(0, "command");
        if (!string.equals("export")) {
            String string2 = XeniErrorProperties.getErrorProperty("err.agent.not.exporttype", string);
            this.sendErrorMessage(-2006, string2);
            throw new IOException(string2);
        }
        String string3 = this.dsCommand.getString(0, "instanceid");
        if (string3 == null || string3.equals("")) {
            string3 = UUID.randomUUID().toString();
        }
        if (log.isInfoEnabled()) {
            String string4 = this.dsCommand.getString(0, "item");
            String string5 = this.dsCommand.getString(0, "seq");
            String string6 = this.dsCommand.getString(0, "eof");
            String string7 = this.dsCommand.getString(0, "url");
            String string8 = this.dsCommand.getString(0, "instanceid");
            log.info((Object)StringUtils.normalizeSpace((String)("Input export data : [ Item = " + string4 + ", Seq. = " + string5 + ", EOF = " + string6 + ", Url = " + string7 + ", Inst.Id = " + string8 + " ]")));
        }
        this.dsCommand.set(0, "instanceid", string3);
        this.getExportContext(this.dsCommand, variableList, platformRequest.getContentType());
        return this.getExportContext();
    }

    private GridExportContext getExportContext(DataSet dataSet, VariableList variableList, String string) {
        GridExportContext gridExportContext = this.getExportContext();
        gridExportContext.setApi(true);
        gridExportContext.setRequestPlatformType(string);
        gridExportContext.setResponsePlatformType(XeniProperties.getStringProperty("xeni.export.commdataformat"));
        gridExportContext.setUserVariableList(variableList);
        gridExportContext.setAppendUrl(dataSet.getString(0, "url"));
        gridExportContext.setExportType(dataSet.getInt(0, "type"));
        gridExportContext.setItemName(dataSet.getString(0, "item"));
        gridExportContext.setFileName(dataSet.getString(0, "exportfilename"));
        gridExportContext.setInstanceId(dataSet.getString(0, "instanceid"));
        String string2 = dataSet.getString(0, "exporthead");
        if (string2 != null) {
            gridExportContext.setNoHead(string2.contains("nohead"));
            gridExportContext.setNoSummary(string2.contains("nosumm"));
        }
        gridExportContext.setTopSummary("top".equals(dataSet.getString(0, "summarytype")));
        if ("both".equals(dataSet.getString(0, "exportsize"))) {
            gridExportContext.setApplyHeight(true);
        } else if ("height".equals(dataSet.getString(0, "exportsize"))) {
            gridExportContext.setApplyWidth(false);
            gridExportContext.setApplyHeight(true);
        }
        gridExportContext.setWrapText(dataSet.getBoolean(0, "wraptext"));
        gridExportContext.setRtl(dataSet.getBoolean(0, "righttoleft"));
        gridExportContext.setPassword(dataSet.getString(0, "password"));
        gridExportContext.setCommandVersion(dataSet.getFloat(0, "commandversion"));
        return gridExportContext;
    }

    public void setExportPath(String string) throws Exception {
        this.setExportPath(string, null);
    }

    public void setExportPath(String string, String string2) throws Exception {
        GridExportContext gridExportContext = this.getExportContext();
        String string3 = "";
        if (string == null || string.isEmpty()) {
            string3 = "export/";
        } else {
            if (string.startsWith("file://")) {
                string3 = string.substring(7);
                gridExportContext.setOutsidePath(true);
            } else if (string.startsWith("/")) {
                string3 = string.substring(1);
            }
            if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
        }
        String string4 = null;
        if (this.svltProvider.getHttpServletRequest().getSession() == null) {
            log.info((Object)"Request session is null");
        } else if (this.svltProvider.getHttpServletRequest().getSession().getServletContext() == null) {
            log.info((Object)"Servlet context is null");
        } else {
            string4 = this.svltProvider.getHttpServletRequest().getSession().getServletContext().getRealPath("/");
        }
        if (string4 == null) {
            if (!gridExportContext.isOutsidePath()) {
                String string5 = "Unable to get real path of the context. Set absolute paths.";
                this.sendErrorMessage(-2001, string5);
                throw new Exception(string5);
            }
        } else if (!(string4 = string4.replaceAll("\\\\", "/")).endsWith("/")) {
            string4 = string4 + "/";
        }
        if (gridExportContext.isOutsidePath()) {
            gridExportContext.setAbsolutePath(string3);
        } else {
            gridExportContext.setAbsolutePath(string4 + string3);
        }
        String string6 = string2;
        if (string6 == null || string6.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            String string7 = this.svltProvider.getHttpServletRequest().getScheme();
            stringBuffer.append(string7).append("://");
            stringBuffer.append(this.svltProvider.getHttpServletRequest().getServerName());
            int n = this.svltProvider.getHttpServletRequest().getServerPort();
            if (n < 0) {
                n = 80;
            }
            if (string7.equals("http") && n != 80 || string7.equals("https") && n != 443) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
            if (gridExportContext.isOutsidePath()) {
                stringBuffer.append(this.svltProvider.getHttpServletRequest().getRequestURI());
            } else {
                stringBuffer.append(this.svltProvider.getHttpServletRequest().getContextPath()).append("/");
            }
            string6 = stringBuffer.toString();
        }
        if (gridExportContext.isOutsidePath()) {
            gridExportContext.setDownloadUrl(string6);
        } else {
            gridExportContext.setDownloadUrl(string6.substring(0, string6.lastIndexOf("/") + 1) + string3);
        }
    }

    public void exportData(DataSet dataSet) throws IOException, Exception {
        this.exportData(dataSet, true);
    }

    public void exportData(DataSet dataSet, boolean bl) throws IOException, Exception {
        if (dataSet == null) {
            return;
        }
        GridExportContext gridExportContext = this.getExportContext();
        if (gridExportContext.getAbsolutePath() == null || gridExportContext.getDownloadUrl() == null) {
            this.setExportPath(null, null);
        }
        if (this.dsCommand == null) {
            this.dsCommand = new DataSet("COMMAND");
        }
        if (this.dsStyle == null) {
            this.dsStyle = new DataSet("STYLE");
        }
        this.dsCommand.set(0, "seq", gridExportContext.getSequence() + 1);
        this.dsCommand.set(0, "eof", bl);
        int n = 0;
        GridPartExportExcel gridPartExportExcel = this.getExcelExportor();
        if (this.dsCommand.getInt(0, "seq") == 1) {
            n = gridPartExportExcel.initialize(gridExportContext, this.dsCommand);
        }
        if (n >= 0) {
            gridPartExportExcel.startExport(this.svltProvider, this.dsCommand, this.dsStyle, dataSet);
        }
        if (n != 0) {
            String string = gridPartExportExcel.getErrorMessage();
            this.sendErrorMessage(-2001, string);
            throw new Exception(string);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private void sendErrorMessage(int n, String string) {
        block3: {
            this.errorCode = n;
            PlatformData platformData = new PlatformData();
            VariableList variableList = platformData.getVariableList();
            variableList.add("ErrorCode", n);
            variableList.add("ErrorMsg", string);
            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(this.svltProvider.getHttpServletResponse(), "PlatformSsv", "UTF-8");
            httpPlatformResponse.setData(platformData);
            if (log.isErrorEnabled()) {
                log.error((Object)StringUtils.normalizeSpace((String)string));
            }
            try {
                httpPlatformResponse.sendData();
            }
            catch (PlatformException platformException) {
                if (!log.isInfoEnabled()) break block3;
                log.error((Object)StringUtils.normalizeSpace((String)platformException.getMessage()));
            }
        }
    }
}

