/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class XeniDateUtil {
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECONDS_PER_DAY = 86400;
    private static final int BAD_DATE = -1;
    public static final long DAY_MILLISECONDS = 86400000L;
    private static final Pattern TIME_SEPARATOR_PATTERN = Pattern.compile("S");
    private static final Pattern date_ptrn1 = Pattern.compile("^\\[\\$\\-.*?\\]");
    private static final Pattern date_ptrn2 = Pattern.compile("^\\[[a-zA-Z]+\\]");
    private static final Pattern date_ptrn3 = Pattern.compile("^[\\[\\]yYmMdDhHsS\\-/,. :\"\\\\]+0*[ampAMP/]*$");
    private static final Pattern date_ptrn4 = Pattern.compile("^\\[([hH]+|[mM]+|[sS]+)\\]");
    private static final Pattern date_ptrn5 = Pattern.compile("^\\[\\$\\-.*?\\]*$");
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    protected XeniDateUtil() {
    }

    public static double getExcelDate(Date date) {
        return XeniDateUtil.getExcelDate(date, false);
    }

    public static double getExcelDate(Date date, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return XeniDateUtil.internalGetExcelDate(gregorianCalendar, bl);
    }

    public static double getExcelDate(Calendar calendar, boolean bl) {
        return XeniDateUtil.internalGetExcelDate((Calendar)calendar.clone(), bl);
    }

    private static double internalGetExcelDate(Calendar calendar, boolean bl) {
        if (!bl && calendar.get(1) < 1900 || bl && calendar.get(1) < 1904) {
            return -1.0;
        }
        double d = (double)(((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14)) / 8.64E7;
        Calendar calendar2 = XeniDateUtil.dayStart(calendar);
        double d2 = d + (double)XeniDateUtil.absoluteDay(calendar2, bl);
        if (!bl && d2 >= 60.0) {
            d2 += 1.0;
        } else if (bl) {
            d2 -= 1.0;
        }
        return d2;
    }

    public static Date getJavaDate(double d, TimeZone timeZone) {
        return XeniDateUtil.getJavaDate(d, false, timeZone);
    }

    public static Date getJavaDate(double d) {
        return XeniDateUtil.getJavaDate(d, null);
    }

    public static Date getJavaDate(double d, boolean bl, TimeZone timeZone) {
        return XeniDateUtil.getJavaCalendar(d, bl, timeZone).getTime();
    }

    public static Date getJavaDate(double d, boolean bl) {
        return XeniDateUtil.getJavaCalendar(d, bl).getTime();
    }

    public static void setCalendar(Calendar calendar, int n, int n2, boolean bl) {
        int n3 = 1900;
        int n4 = -1;
        if (bl) {
            n3 = 1904;
            n4 = 1;
        } else if (n < 61) {
            n4 = 0;
        }
        calendar.set(n3, 0, n + n4, 0, 0, 0);
        calendar.set(14, n2);
    }

    public static Calendar getJavaCalendar(double d, boolean bl) {
        return XeniDateUtil.getJavaCalendar(d, bl, null);
    }

    public static Calendar getJavaCalendarUTC(double d, boolean bl) {
        return XeniDateUtil.getJavaCalendar(d, bl, TIMEZONE_UTC);
    }

    public static Calendar getJavaCalendar(double d, boolean bl, TimeZone timeZone) {
        if (!XeniDateUtil.isValidExcelDate(d)) {
            return null;
        }
        int n = (int)Math.floor(d);
        int n2 = (int)((d - (double)n) * 8.64E7 + 0.5);
        GregorianCalendar gregorianCalendar = timeZone != null ? new GregorianCalendar(timeZone) : new GregorianCalendar();
        XeniDateUtil.setCalendar(gregorianCalendar, n, n2, bl);
        return gregorianCalendar;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isADateFormat(int var0, String var1_1) {
        if (XeniDateUtil.isInternalDateFormat(var0)) {
            return true;
        }
        if (var1_1 == null || var1_1.length() == 0) {
            return false;
        }
        var2_2 = var1_1;
        var3_3 = new StringBuilder(var2_2.length());
        block3: for (var4_4 = 0; var4_4 < var2_2.length(); ++var4_4) {
            var5_6 = var2_2.charAt(var4_4);
            if (var4_4 >= var2_2.length() - 1) ** GOTO lbl-1000
            var6_7 = var2_2.charAt(var4_4 + 1);
            if (var5_6 != '\\') ** GOTO lbl-1000
            switch (var6_7) {
                case ' ': 
                case ',': 
                case '-': 
                case '.': 
                case '\\': {
                    continue block3;
                }
                default: lbl-1000:
                // 3 sources

                {
                    var3_3.append(var5_6);
                }
            }
        }
        var2_2 = var3_3.toString();
        if (XeniDateUtil.date_ptrn4.matcher(var2_2).matches()) {
            return true;
        }
        if (var2_2.length() > 1 && (var4_5 = var2_2.substring(var2_2.length() - 2)).equals(";@")) {
            return true;
        }
        if (XeniDateUtil.date_ptrn5.matcher(var2_2).matches()) {
            var2_2 = XeniDateUtil.date_ptrn1.matcher(var2_2).replaceAll("");
            var2_2 = XeniDateUtil.date_ptrn2.matcher(var2_2).replaceAll("");
            return true;
        }
        var2_2 = XeniDateUtil.date_ptrn1.matcher(var2_2).replaceAll("");
        if ((var2_2 = XeniDateUtil.date_ptrn2.matcher(var2_2).replaceAll("")).indexOf(59) > 0 && var2_2.indexOf(59) < var2_2.length() - 1) {
            var2_2 = var2_2.substring(0, var2_2.indexOf(59));
        }
        return XeniDateUtil.date_ptrn3.matcher(var2_2).matches();
    }

    public static boolean isInternalDateFormat(int n) {
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bl = false;
        double d = cell.getNumericCellValue();
        if (XeniDateUtil.isValidExcelDate(d)) {
            CellStyle cellStyle = cell.getCellStyle();
            if (cellStyle == null) {
                return false;
            }
            short s = cellStyle.getDataFormat();
            String string = cellStyle.getDataFormatString();
            bl = XeniDateUtil.isADateFormat(s, string);
        }
        return bl;
    }

    public static boolean isCellInternalDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bl = false;
        double d = cell.getNumericCellValue();
        if (XeniDateUtil.isValidExcelDate(d)) {
            CellStyle cellStyle = cell.getCellStyle();
            short s = cellStyle.getDataFormat();
            bl = XeniDateUtil.isInternalDateFormat(s);
        }
        return bl;
    }

    public static boolean isValidExcelDate(double d) {
        return d > -4.9E-324;
    }

    protected static int absoluteDay(Calendar calendar, boolean bl) {
        return calendar.get(6) + XeniDateUtil.daysInPriorYears(calendar.get(1), bl);
    }

    private static int daysInPriorYears(int n, boolean bl) {
        if (!bl && n < 1900 || bl && n < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int n2 = n - 1;
        int n3 = n2 / 4 - n2 / 100 + n2 / 400 - 460;
        return 365 * (n - (bl ? 1904 : 1900)) + n3;
    }

    private static Calendar dayStart(Calendar calendar) {
        calendar.get(11);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.get(11);
        return calendar;
    }

    public static double convertTime(String string) {
        try {
            return XeniDateUtil.convertTimeInternal(string);
        }
        catch (FormatException formatException) {
            String string2 = "Bad time format '" + string + "' expected 'HH:MM' or 'HH:MM:SS' - " + formatException.getMessage();
            throw new IllegalArgumentException(string2);
        }
    }

    private static double convertTimeInternal(String string) throws FormatException {
        String string2;
        int n = string.length();
        if (n < 4 || n > 8) {
            throw new FormatException("Bad length");
        }
        String[] stringArray = TIME_SEPARATOR_PATTERN.split(string);
        switch (stringArray.length) {
            case 2: {
                string2 = "00";
                break;
            }
            case 3: {
                string2 = stringArray[2];
                break;
            }
            default: {
                throw new FormatException("Expected 2 or 3 fields but got (" + stringArray.length + ")");
            }
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        int n2 = XeniDateUtil.parseInt(string3, "hour", 24);
        int n3 = XeniDateUtil.parseInt(string4, "minute", 60);
        int n4 = XeniDateUtil.parseInt(string2, "second", 60);
        double d = n4 + (n3 + n2 * 60) * 60;
        return d / 86400.0;
    }

    public static Date parseYYYYMMDDDate(String string) {
        try {
            return XeniDateUtil.parseYYYYMMDDDateInternal(string);
        }
        catch (FormatException formatException) {
            String string2 = "Bad time format " + string + " expected 'YYYY/MM/DD' - " + formatException.getMessage();
            throw new IllegalArgumentException(string2);
        }
    }

    private static Date parseYYYYMMDDDateInternal(String string) throws FormatException {
        if (string.length() != 10) {
            throw new FormatException("Bad length");
        }
        String string2 = string.substring(0, 4);
        String string3 = string.substring(5, 7);
        String string4 = string.substring(8, 10);
        int n = XeniDateUtil.parseInt(string2, "year", Short.MIN_VALUE, Short.MAX_VALUE);
        int n2 = XeniDateUtil.parseInt(string3, "month", 1, 12);
        int n3 = XeniDateUtil.parseInt(string4, "day", 1, 31);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    private static int parseInt(String string, String string2, int n) throws FormatException {
        return XeniDateUtil.parseInt(string, string2, 0, n - 1);
    }

    private static int parseInt(String string, String string2, int n, int n2) throws FormatException {
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException("Bad int format '" + string + "' for " + string2 + " field");
        }
        if (n3 < n || n3 > n2) {
            throw new FormatException(string2 + " value (" + n3 + ") is outside the allowable range(0.." + n2 + ")");
        }
        return n3;
    }

    private static final class FormatException
    extends Exception {
        public FormatException(String string) {
            super(string);
        }
    }
}

