/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartReqData;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniMultipartProcDef
implements XeniMultipartProcBase {
    private static final Log logger = LogFactory.getLog(XeniMultipartProcDef.class);

    @Override
    public XeniMultipartReqData getImportData(HttpServletRequest httpServletRequest) throws Exception {
        JakartaServletFileUpload jakartaServletFileUpload = new JakartaServletFileUpload();
        XeniMultipartReqData xeniMultipartReqData = new XeniMultipartReqData();
        jakartaServletFileUpload.setHeaderCharset(StandardCharsets.UTF_8);
        FileItemInputIterator fileItemInputIterator = jakartaServletFileUpload.getItemIterator(httpServletRequest);
        String string = null;
        while (fileItemInputIterator.hasNext()) {
            FileItemInput fileItemInput = fileItemInputIterator.next();
            if (fileItemInput.isFormField()) {
                xeniMultipartReqData.setPlatformData(this.getPlatformData(fileItemInput.getInputStream()));
            } else {
                string = fileItemInput.getName();
                int n = (string = string.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (n >= 0) {
                    string = string.substring(n + 1);
                }
                xeniMultipartReqData.setFileName(string);
                InputStream inputStream = fileItemInput.getInputStream();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream));
                xeniMultipartReqData.setFileStream(byteArrayInputStream);
                inputStream.close();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("File field " + fileItemInput.getFieldName() + " with file name " + string + " detected."));
        }
        return xeniMultipartReqData;
    }

    private boolean IsValidName(String string) {
        boolean bl = false;
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        if (string2.length() > 0 && ("xls".equalsIgnoreCase(string2) || "xlsx".equalsIgnoreCase(string2) || "cell".equalsIgnoreCase(string2) || "csv".equalsIgnoreCase(string2) || "xlsm".equalsIgnoreCase(string2) || "pia".equalsIgnoreCase(string2))) {
            bl = true;
        }
        return bl;
    }

    private PlatformData getPlatformData(InputStream inputStream) throws PlatformException {
        PlatformRequest platformRequest = new PlatformRequest(inputStream);
        platformRequest.receiveData();
        return platformRequest.getData();
    }
}

