/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.java.xeni.extend.XeniStylesTable;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFEventModelHandlerBody
extends DefaultHandler {
    private static final Log logger = LogFactory.getLog(XSSFEventModelHandlerBody.class);
    private StylesTable stylesTable;
    private XeniStylesTable xeniStylesTable;
    private XeniReadOnlySharedStringsTable sharedStringsTable;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final XeniDataFormatter formatter;
    private boolean formulasNotResults;
    private int nCurrExlRow = -1;
    private int nCurrDsRow = -1;
    private int[] currCellRef = new int[]{-1, -1};
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private DataSet dsResult = null;
    private DataSet dsInfo = null;
    private boolean isHancell = false;
    private GridImportContext importContext;
    private ExcelDimensionInfo dimInfo;

    public XSSFEventModelHandlerBody(DataSet dataSet, ExcelDimensionInfo excelDimensionInfo, StylesTable stylesTable, XeniStylesTable xeniStylesTable, XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable, boolean bl, boolean bl2, GridImportContext gridImportContext, DataSet dataSet2) {
        this.dsResult = dataSet;
        this.dimInfo = excelDimensionInfo;
        this.stylesTable = stylesTable;
        this.xeniStylesTable = xeniStylesTable;
        this.sharedStringsTable = xeniReadOnlySharedStringsTable;
        this.formulasNotResults = bl;
        this.formatter = new XeniDataFormatter();
        this.nextDataType = xssfDataType.NUMBER;
        this.isHancell = bl2;
        this.importContext = gridImportContext;
        if (this.dimInfo.getUserStartColumn() >= 0) {
            this.dimInfo.setStartColumn(this.dimInfo.getUserStartColumn());
        }
        if (this.dimInfo.getUserEndColumn() >= 0) {
            this.dimInfo.setEndColumn(this.dimInfo.getUserEndColumn());
        }
        if (this.dimInfo.getUserStartRow() >= 0) {
            this.dimInfo.setStartRow(this.dimInfo.getUserStartRow());
        }
        if (this.dimInfo.getUserEndRow() >= 0) {
            this.dimInfo.setEndRow(this.dimInfo.getUserEndRow());
        }
        this.dsInfo = dataSet2;
    }

    private boolean isTextTag(String string) {
        if ("v".equals(string)) {
            return true;
        }
        if ("inlineStr".equals(string)) {
            return true;
        }
        return "t".equals(string) && this.isIsOpen;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("dimension".equals(string2)) {
            String string4 = attributes.getValue("ref");
            this.setDimension(string4);
        } else if (this.isTextTag(string2)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("is".equals(string2)) {
            this.isIsOpen = true;
        } else if ("f".equals(string2)) {
            this.setStartFormula(attributes);
        } else if ("oddHeader".equals(string2) || "evenHeader".equals(string2) || "firstHeader".equals(string2) || "firstFooter".equals(string2) || "oddFooter".equals(string2) || "evenFooter".equals(string2)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if ("row".equals(string2)) {
            int n = Integer.parseInt(attributes.getValue("r")) - 1;
            if (n > this.dimInfo.getEndRow()) {
                if (this.importContext.isPartData()) {
                    this.writePartDataset(this.dsResult);
                }
                throw new SAXException(new POIEventModelException("Stop parsing the document."));
            }
            this.setStartRowIndex(n);
        } else if ("c".equals(string2)) {
            this.setStartCellValue(attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object var4_4 = null;
        if (this.isTextTag(string2)) {
            this.vIsOpen = false;
            if (this.isValidDimension()) {
                this.setCellValue(this.getCellValue());
            }
        } else if ("f".equals(string2)) {
            this.fIsOpen = false;
        } else if ("is".equals(string2)) {
            this.isIsOpen = false;
        } else if ("row".equals(string2)) {
            this.setEndRow();
        } else if ("oddHeader".equals(string2) || "evenHeader".equals(string2) || "firstHeader".equals(string2)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), true, string2);
        } else if ("oddFooter".equals(string2) || "evenFooter".equals(string2) || "firstFooter".equals(string2)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), false, string2);
        } else if ("c".equals(string2)) {
            this.value.setLength(0);
        } else if ("sheetData".equals(string2)) {
            if (this.importContext.isPartData()) {
                this.writePartDataset(this.dsResult);
            }
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(cArray, n, n2);
        }
        if (this.fIsOpen) {
            this.formula.append(cArray, n, n2);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(cArray, n, n2);
        }
    }

    private void setDimension(String string) throws SAXException {
        long l;
        long l2 = Long.parseLong(XeniProperties.getStringProperty("xeni.import.cell.max", "-1"));
        if (l2 > 0L && (l = (long)(this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn() + 1) * (long)(this.dimInfo.getEndRow() - this.dimInfo.getStartRow() + 1)) > l2) {
            throw new SAXException("Maximum number of cells exceeded. (" + l + ":" + l2 + ")");
        }
    }

    private void setStartRowIndex(int n) {
        this.sendPartDataset();
        if (this.nCurrExlRow >= 0 && n - this.nCurrExlRow > 1) {
            for (int i = this.nCurrExlRow + 1; i < n; ++i) {
                if (this.dimInfo.getStartRow() > i) continue;
                this.dsResult.newRow();
            }
        }
        if (this.dimInfo.getStartRow() <= n) {
            this.nCurrDsRow = this.dsResult.newRow();
        }
        this.nCurrExlRow = n;
    }

    private void setEndRow() {
        this.nCurrDsRow = -1;
    }

    private void setCellValue(String string) throws SAXException {
        if (string != null) {
            if (this.importContext.getCorsResponseType() == 1) {
                string = string.replaceAll("\n", "\\\\n");
                string = string.replaceAll("\"", "\\\\\"");
                string = string.replaceAll("\\\\", "\\\\\\\\");
            }
            this.dsResult.set(this.nCurrDsRow, this.currCellRef[0] - this.dimInfo.getStartColumn(), string);
        }
    }

    private void setHeaderFooter(String string, boolean bl, String string2) {
    }

    private void setStartCellValue(Attributes attributes) {
        CommUtil.getRangeIndex(attributes.getValue("r"), this.currCellRef);
        this.nextDataType = xssfDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String string = attributes.getValue("t");
        String string2 = attributes.getValue("s");
        if ("b".equals(string)) {
            this.nextDataType = xssfDataType.BOOLEAN;
        } else if ("e".equals(string)) {
            this.nextDataType = xssfDataType.ERROR;
        } else if ("inlineStr".equals(string)) {
            this.nextDataType = xssfDataType.INLINE_STRING;
        } else if ("s".equals(string)) {
            this.nextDataType = xssfDataType.SST_STRING;
        } else if ("str".equals(string)) {
            this.nextDataType = xssfDataType.FORMULA;
        } else if (string2 != null) {
            int n = Integer.parseInt(string2);
            if (!this.isHancell) {
                XSSFCellStyle xSSFCellStyle = this.stylesTable.getStyleAt(n);
                if (xSSFCellStyle != null) {
                    this.formatIndex = xSSFCellStyle.getDataFormat();
                    this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : xSSFCellStyle.getDataFormatString();
                }
            } else {
                this.formatIndex = this.xeniStylesTable.getDataFormat(n);
                this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : this.xeniStylesTable.getDataFormatString(this.formatIndex);
            }
            if (this.formatString == null) {
                this.formatString = XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null);
            }
        }
    }

    private String getCellValue() {
        String string = null;
        switch (this.nextDataType) {
            case BOOLEAN: {
                char c = this.value.charAt(0);
                string = c == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                string = "ERROR:" + this.value.toString();
            }
            case FORMULA: {
                if (this.formulasNotResults) {
                    string = this.formula.toString();
                    break;
                }
                string = this.value.toString();
                if (this.importContext.isRawNumberValue() && this.importContext.getCompatibleMode() <= 0) break;
                try {
                    double d = Double.parseDouble(string);
                    string = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                    string = string.replaceAll("[\"*? ]", "");
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(numberFormatException.getMessage());
                }
                break;
            }
            case INLINE_STRING: {
                if (!this.isHancell) {
                    XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.value.toString());
                    string = xSSFRichTextString.toString();
                    break;
                }
                string = this.value.toString();
                break;
            }
            case SST_STRING: {
                String string2 = this.value.toString();
                try {
                    int n = Integer.parseInt(string2);
                    if (!this.isHancell) {
                        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(n));
                        string = xSSFRichTextString.toString();
                        break;
                    }
                    string = this.sharedStringsTable.getEntryAt(n);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isErrorEnabled()) break;
                    logger.error((Object)("Failed to parse SST index '" + StringUtils.normalizeSpace((String)string2) + "': " + StringUtils.normalizeSpace((String)numberFormatException.toString())));
                }
                break;
            }
            case NUMBER: {
                double d = Double.parseDouble(this.value.toString());
                string = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                string = string.replaceAll("[\"*? ]", "");
                break;
            }
            default: {
                string = "(Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
            }
        }
        return string;
    }

    private void setStartFormula(Attributes attributes) {
        String string;
        this.formula.setLength(0);
        if (this.nextDataType == xssfDataType.NUMBER) {
            this.nextDataType = xssfDataType.FORMULA;
        }
        if ((string = attributes.getValue("t")) != null && "shared".equals(string)) {
            String string2 = attributes.getValue("ref");
            String string3 = attributes.getValue("si");
            if (string2 != null) {
                this.fIsOpen = true;
            } else if (this.formulasNotResults && logger.isErrorEnabled()) {
                logger.error((Object)"Warning - shared formulas not yet supported!");
            }
        } else {
            this.fIsOpen = true;
        }
    }

    private boolean isValidDimension() {
        if (this.nCurrExlRow < this.dimInfo.getStartRow()) {
            return false;
        }
        return this.currCellRef[0] >= this.dimInfo.getStartColumn() && this.currCellRef[0] <= this.dimInfo.getEndColumn();
    }

    private void writePartDataset(DataSet dataSet) {
        try {
            Object object;
            XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("");
            if (this.importContext.getPartIndex() <= 2) {
                object = new VariableList();
                object.add("ErrorCode", 0);
                object.add("ErrorMsg", "SUCCESS");
                StringWriter stringWriter = new StringWriter();
                CommUtil.writePartDataVariableList(stringWriter, this.importContext, (VariableList)object);
                xeniEncoder.encodeTo(this.importContext.getResponseWriter(), stringWriter.toString());
                stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
                this.importContext.setPartIndex(3);
                if (this.dsInfo != null) {
                    this.dsInfo.set(0, "importid", this.importContext.getImportId());
                    this.writePartDataset(this.dsInfo);
                    this.importContext.setPartIndex(4);
                }
            }
            object = new StringWriter();
            CommUtil.writePartDataDataset((StringWriter)object, this.importContext, dataSet);
            xeniEncoder.encodeTo(this.importContext.getResponseWriter(), ((StringWriter)object).toString());
            this.importContext.getResponseWriter().flush();
            this.importContext.setPartIndex(4);
            ((StringWriter)object).getBuffer().delete(0, ((StringWriter)object).getBuffer().length());
        }
        catch (PlatformException | IOException throwable) {
            logger.error((Object)StringUtils.normalizeSpace((String)throwable.getMessage()));
        }
    }

    private void sendPartDataset() {
        if (this.importContext.isPartData() && this.dsResult.getRowCount() >= this.importContext.getPartSize()) {
            this.writePartDataset(this.dsResult);
        }
    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

