/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.export.impl.GridCellStyleInfoExt;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;

public class GridCellStyleInfo {
    private String sErrMessage = "";
    private static final Log oLogger = LogFactory.getLog(GridCellStyleInfo.class);
    private List<GridCellStyleInfoExt> listStyle;
    private HashMap<String, Integer> oColors;
    private DataSet dsStyle;
    private short nOffset = (short)8;
    private boolean bAppended = false;

    public GridCellStyleInfo() {
        this.listStyle = new ArrayList<GridCellStyleInfoExt>();
        this.oColors = new HashMap();
        this.dsStyle = new DataSet();
    }

    public int getStyleInfo(Workbook workbook, DataSet dataSet, boolean bl, boolean bl2, boolean bl3) {
        this.bAppended = bl3;
        int n = this.dsStyle.getRowCount();
        if (this.dsStyle.getColumnCount() <= 0) {
            this.dsStyle.copyFrom(dataSet, true);
        } else {
            this.dsStyle.copyDataFrom(dataSet, true);
        }
        while (n < this.dsStyle.getRowCount()) {
            String string = this.dsStyle.getString(n, "type");
            if (string.equals("style") && this.createCellStyle(workbook, this.dsStyle, bl, bl2, n) < 0) {
                return -2009;
            }
            ++n;
        }
        return 0;
    }

    private void setErrorMessage(String string) {
        this.sErrMessage = string;
        if (oLogger.isInfoEnabled()) {
            oLogger.info((Object)StringUtils.normalizeSpace((String)string));
        }
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    private int createCellStyle(Workbook workbook, DataSet dataSet, boolean bl, boolean bl2, int n) {
        GridCellStyleInfoExt gridCellStyleInfoExt = new GridCellStyleInfoExt();
        CellStyle cellStyle = workbook.createCellStyle();
        this.setDefaultStyle(cellStyle, bl2);
        Font font = null;
        String string = dataSet.getString(n, "name");
        String string2 = dataSet.getString(n, "value");
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Create style[ " + StringUtils.normalizeSpace((String)string) + " - " + StringUtils.normalizeSpace((String)string2) + " ]"));
        }
        String[] stringArray = string2.split("\\,");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            String[] stringArray2 = stringArray[i].split("\\:");
            if (stringArray2.length < 2) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.notfound.type", string, stringArray[i]));
                continue;
            }
            String string3 = stringArray2[0].trim();
            String[] stringArray3 = this.getStyleValue(dataSet, string3, stringArray2[1].trim());
            String string4 = stringArray3[1];
            String string5 = stringArray3[0];
            if (string5 == null || string5.length() < 1) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.notfound.type", string, stringArray[i]));
                continue;
            }
            if (string3.equals("align")) {
                this.setStyleAlign(cellStyle, string5);
                continue;
            }
            if (string3.equals("font")) {
                if (font == null) {
                    font = workbook.createFont();
                }
                this.setStyleFont(string5, font);
                continue;
            }
            if (string3.equals("background")) {
                this.setStyleBackground(workbook, cellStyle, string5, bl);
                continue;
            }
            if (string3.equals("color")) {
                if (font == null) {
                    font = workbook.createFont();
                }
                this.setStyleForeground(workbook, string5, bl, font);
                continue;
            }
            if (string3.equals("line")) {
                this.setStyleBorder(workbook, cellStyle, string5, bl);
                continue;
            }
            if (string3.equals("type")) {
                this.setStyleDataType(workbook, cellStyle, string5, gridCellStyleInfoExt, string4);
                continue;
            }
            if (string3.equals("rowsuppress") || string3.equals("merge")) {
                this.setStyleSuppress(workbook, cellStyle, string5, gridCellStyleInfoExt, true);
                continue;
            }
            if (string3.equals("colsuppress")) {
                this.setStyleSuppress(workbook, cellStyle, string5, gridCellStyleInfoExt, false);
                continue;
            }
            if (string3.equals("overlaytext")) {
                this.setStyleOverayText(workbook, cellStyle, string5, gridCellStyleInfoExt);
                continue;
            }
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.notfound.type", string, stringArray[i]));
            return -1;
        }
        if (font != null) {
            cellStyle.setFont(font);
        }
        gridCellStyleInfoExt.addStyle(string, cellStyle.getIndex());
        this.listStyle.add(gridCellStyleInfoExt);
        return 0;
    }

    private void setDefaultStyle(CellStyle cellStyle, boolean bl) {
        if (bl) {
            cellStyle.setWrapText(true);
        }
    }

    private String[] getStyleValue(DataSet dataSet, String string, String string2) {
        String[] stringArray = new String[2];
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            String string3 = dataSet.getString(i, "type");
            String string4 = dataSet.getString(i, "name");
            if (!string.equals(string3.trim()) || !string2.equals(string4.trim())) continue;
            if ("type".equals(string)) {
                stringArray[1] = dataSet.getString(i, "locale");
            }
            stringArray[0] = dataSet.getString(i, "value");
            return stringArray;
        }
        return null;
    }

    private void setStyleAlign(CellStyle cellStyle, String string) {
        String[] stringArray;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style align [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        if ((stringArray = string.split("\\,")).length < 1) {
            return;
        }
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        if (stringArray[0].equals("left")) {
            horizontalAlignment = HorizontalAlignment.LEFT;
        } else if (stringArray[0].equals("center")) {
            horizontalAlignment = HorizontalAlignment.CENTER;
        } else if (stringArray[0].equals("right")) {
            horizontalAlignment = HorizontalAlignment.RIGHT;
        }
        cellStyle.setAlignment(horizontalAlignment);
        if (stringArray.length > 1) {
            if (stringArray[1].equals("top")) {
                verticalAlignment = VerticalAlignment.TOP;
            } else if (stringArray[1].equals("middle")) {
                verticalAlignment = VerticalAlignment.CENTER;
            } else if (stringArray[1].equals("bottom")) {
                verticalAlignment = VerticalAlignment.BOTTOM;
            }
        }
        cellStyle.setVerticalAlignment(verticalAlignment);
    }

    private void setStyleFont(String string, Font font) {
        String[] stringArray;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style font [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        if ((stringArray = string.split("\\,")).length < 1) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        byte by = 0;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if ("".equals(string2 = string2.replaceAll("\"", ""))) continue;
            if (string2.equals("bold")) {
                bl = true;
                continue;
            }
            if (string2.equals("italic")) {
                bl2 = true;
                continue;
            }
            if (string2.equals("underline")) {
                by = 1;
                continue;
            }
            if (string2.equals("strikeout")) {
                bl3 = true;
                continue;
            }
            if (string2.equals("antialias")) continue;
            if (CommUtil.isNumber(string2)) {
                font.setFontHeight((short)(Integer.parseInt(string2) * 20));
                continue;
            }
            font.setFontName(string2);
        }
        font.setBold(bl);
        font.setItalic(bl2);
        font.setUnderline(by);
        font.setStrikeout(bl3);
    }

    private void setStyleBackground(Workbook workbook, CellStyle cellStyle, String string, boolean bl) {
        String[] stringArray;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style background [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        if ((stringArray = string.split("\\,")).length < 3) {
            return;
        }
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (bl) {
            XSSFColor xSSFColor = this.getXSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], false);
            if (xSSFColor != null) {
                ((XSSFCellStyle)cellStyle).setFillForegroundColor(xSSFColor);
            }
        } else {
            short s = this.getHSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], workbook);
            cellStyle.setFillForegroundColor(s);
        }
    }

    private void setStyleForeground(Workbook workbook, String string, boolean bl, Font font) {
        String[] stringArray;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style foreground [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        if ((stringArray = string.split("\\,")).length < 3) {
            return;
        }
        font.setColor((short)Short.MAX_VALUE);
        if (bl) {
            XSSFColor xSSFColor = this.getXSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], true);
            if (xSSFColor != null) {
                CTFont cTFont = ((XSSFFont)font).getCTFont();
                cTFont.setColorArray(0, xSSFColor.getCTColor());
            }
        } else {
            short s = this.getHSSFRGBColor(stringArray[0], stringArray[1], stringArray[2], workbook);
            font.setColor(s);
        }
    }

    private void setStyleBorder(Workbook workbook, CellStyle cellStyle, String string, boolean bl) {
        String[] stringArray;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style border [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        if ((stringArray = string.split("\\:")).length < 4) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("") || stringArray[i].equals("empty")) continue;
            String[] stringArray2 = stringArray[i].split("\\,");
            BorderStyle borderStyle = BorderStyle.THIN;
            if (stringArray2.length > 3) {
                borderStyle = BorderStyle.MEDIUM;
                if (stringArray2[3].equals("double")) {
                    borderStyle = BorderStyle.DOUBLE;
                } else if (stringArray2[3].equals("dotted")) {
                    borderStyle = BorderStyle.DOTTED;
                } else if (stringArray2[3].equals("dashed")) {
                    borderStyle = BorderStyle.DASHED;
                }
            }
            if (bl) {
                XSSFColor xSSFColor = this.getXSSFRGBColor(stringArray2[0], stringArray2[1], stringArray2[2], false);
                if (xSSFColor == null) continue;
                if (i == 0) {
                    cellStyle.setBorderLeft(borderStyle);
                    ((XSSFCellStyle)cellStyle).setLeftBorderColor(xSSFColor);
                    continue;
                }
                if (i == 1) {
                    cellStyle.setBorderTop(borderStyle);
                    ((XSSFCellStyle)cellStyle).setTopBorderColor(xSSFColor);
                    continue;
                }
                if (i == 2) {
                    cellStyle.setBorderRight(borderStyle);
                    ((XSSFCellStyle)cellStyle).setRightBorderColor(xSSFColor);
                    continue;
                }
                if (i != 3) continue;
                cellStyle.setBorderBottom(borderStyle);
                ((XSSFCellStyle)cellStyle).setBottomBorderColor(xSSFColor);
                continue;
            }
            short s = this.getHSSFRGBColor(stringArray2[0], stringArray2[1], stringArray2[2], workbook);
            if (i == 0) {
                cellStyle.setBorderLeft(borderStyle);
                cellStyle.setLeftBorderColor(s);
                continue;
            }
            if (i == 1) {
                cellStyle.setBorderTop(borderStyle);
                cellStyle.setTopBorderColor(s);
                continue;
            }
            if (i == 2) {
                cellStyle.setBorderRight(borderStyle);
                cellStyle.setRightBorderColor(s);
                continue;
            }
            if (i != 3) continue;
            cellStyle.setBorderBottom(borderStyle);
            cellStyle.setBottomBorderColor(s);
        }
    }

    private void setStyleDataType(Workbook workbook, CellStyle cellStyle, String string, GridCellStyleInfoExt gridCellStyleInfoExt, String string2) {
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style data type [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(58);
        if (n <= 0) {
            string3 = string;
        } else {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        int n2 = this.getDataTypeNumber(string3);
        gridCellStyleInfoExt.setDataType(n2);
        if (n2 == 1) {
            if (string4 != null) {
                int n3;
                if (string4.startsWith("!") || string4.startsWith("+") || string4.startsWith("-")) {
                    string4 = string4.substring(1);
                }
                if (string4.contains("9")) {
                    string4 = string4.replace('9', '#');
                }
                if ((n3 = string4.indexOf(46)) > 0) {
                    char[] cArray = string4.toCharArray();
                    boolean bl = false;
                    int n4 = cArray.length - 1;
                    while (bl ? n4 > n3 : n4 > n3 + 1) {
                        if (bl) {
                            cArray[n4] = 48;
                        } else if (cArray[n4] == '0') {
                            bl = true;
                        }
                        --n4;
                    }
                    if (bl) {
                        string4 = String.valueOf(cArray);
                    }
                }
                string4 = string4.replace("#.", "0.");
                if ((string4 = string4.replace(".#", ".0")).contains("%")) {
                    gridCellStyleInfoExt.setbPercentage(true);
                } else {
                    string4 = string4 + "_ ";
                }
                cellStyle.setDataFormat(workbook.createDataFormat().getFormat(string4));
                gridCellStyleInfoExt.setDataFormat(string4);
            } else {
                cellStyle.setDataFormat(workbook.createDataFormat().getFormat("#,##0_ "));
            }
        } else if (n2 == 2) {
            if (string4 != null) {
                String string5 = string4;
                if (string5.contains("sss")) {
                    string5 = string5.replace("sss", ".000");
                }
                if (string5.contains("/")) {
                    string5 = string5.replaceAll("\\/", "\\\\/");
                }
                string5 = this.getFormatForLanguage(string5, string2);
                cellStyle.setDataFormat(workbook.createDataFormat().getFormat(string5));
                string5 = string4;
                if (string5.contains("dddd")) {
                    string5 = string5.replace("dddd", "E");
                } else if (string5.contains("ddd")) {
                    string5 = string5.replace("ddd", "E");
                }
                if (string5.contains("hh")) {
                    string5 = string5.replace("hh", "HH");
                } else if (string5.contains("h")) {
                    string5 = string5.replace("h", "H");
                }
                if (string5.contains("sss")) {
                    string5 = string5.replace("sss", "SSS");
                }
                gridCellStyleInfoExt.setDataFormat(string5);
            }
        } else if (n2 == 3) {
            if (string4 != null && string4.startsWith("image")) {
                gridCellStyleInfoExt.setImageData(true);
                String[] stringArray = string4.split("\\,");
                if (stringArray.length > 1) {
                    gridCellStyleInfoExt.setImageStretch(stringArray[1]);
                }
            } else {
                cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"TEXT"));
            }
        }
    }

    private void setStyleSuppress(Workbook workbook, CellStyle cellStyle, String string, GridCellStyleInfoExt gridCellStyleInfoExt, boolean bl) {
        int n;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style suppress [ " + StringUtils.normalizeSpace((String)string) + " ]"));
        }
        if ((n = Integer.parseInt(string)) > 1) {
            if (bl) {
                gridCellStyleInfoExt.setiRowSuppressCount(n);
            } else {
                gridCellStyleInfoExt.setiColSuppressCount(n);
            }
        }
    }

    private void setStyleOverayText(Workbook workbook, CellStyle cellStyle, String string, GridCellStyleInfoExt gridCellStyleInfoExt) {
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Set style : Overlay Text");
        }
        if ("true".equals(string)) {
            cellStyle.setWrapText(false);
        }
    }

    private XSSFColor getXSSFRGBColor(String string, String string2, String string3, boolean bl) {
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        int n3 = Integer.parseInt(string3);
        byte[] byArray = new byte[]{0, (byte)n, (byte)n2, (byte)n3};
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setRGB(byArray);
        return xSSFColor;
    }

    private short getHSSFRGBColor(String string, String string2, String string3, Workbook workbook) {
        if (!this.bAppended) {
            String string4 = string + string2 + string3;
            if (this.oColors.containsKey(string4)) {
                return (short)this.oColors.get(string4).intValue();
            }
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string3);
            short s = this.nOffset;
            HSSFPalette hSSFPalette = ((HSSFWorkbook)workbook).getCustomPalette();
            if (this.nOffset > 64) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.limit.usercolor"));
                HSSFColor hSSFColor = hSSFPalette.findSimilarColor(n, n2, n3);
                return hSSFColor != null ? (short)hSSFColor.getIndex() : (short)64;
            }
            hSSFPalette.setColorAtIndex(s, (byte)n, (byte)n2, (byte)n3);
            this.nOffset = (short)(this.nOffset + 1);
            this.oColors.put(string4, Integer.valueOf(s));
            return s;
        }
        HSSFColor hSSFColor = null;
        HSSFPalette hSSFPalette = ((HSSFWorkbook)workbook).getCustomPalette();
        byte by = (byte)Integer.parseInt(string);
        byte by2 = (byte)Integer.parseInt(string2);
        byte by3 = (byte)Integer.parseInt(string3);
        try {
            hSSFColor = hSSFPalette.findColor(by, by2, by3);
            if (hSSFColor == null) {
                hSSFColor = hSSFPalette.addColor(by, by2, by3);
            }
        }
        catch (RuntimeException runtimeException) {
            hSSFColor = hSSFPalette.findSimilarColor(by, by2, by3);
        }
        return hSSFColor.getIndex();
    }

    public GridCellStyleInfoExt getCellStyle(String string) {
        GridCellStyleInfoExt gridCellStyleInfoExt = null;
        for (int i = 0; i < this.listStyle.size(); ++i) {
            gridCellStyleInfoExt = this.listStyle.get(i);
            if (!string.equals(gridCellStyleInfoExt.getStyleName())) continue;
            return gridCellStyleInfoExt;
        }
        return null;
    }

    public CellStyle getCellStyle(Workbook workbook, String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        CellStyle cellStyle = null;
        GridCellStyleInfoExt gridCellStyleInfoExt = this.getCellStyle(string);
        if (gridCellStyleInfoExt != null) {
            cellStyle = workbook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex());
        }
        return cellStyle;
    }

    public void clear() {
        this.listStyle.clear();
        this.oColors.clear();
    }

    public short getPaletteOffset() {
        return this.nOffset;
    }

    public void setPaletteOffset(short s) {
        this.nOffset = s;
    }

    public void appendStyle(String string, short s, int n, String string2, boolean bl) {
        GridCellStyleInfoExt gridCellStyleInfoExt = new GridCellStyleInfoExt();
        gridCellStyleInfoExt.addStyle(string, s);
        gridCellStyleInfoExt.setDataType(n);
        gridCellStyleInfoExt.setDataFormat(string2);
        gridCellStyleInfoExt.setImageData(bl);
        this.listStyle.add(gridCellStyleInfoExt);
    }

    private int getDataTypeNumber(String string) {
        int n = 3;
        if ("normal".equals(string)) {
            n = 0;
        } else if ("number".equals(string)) {
            n = 1;
        } else if ("date".equals(string)) {
            n = 2;
        }
        return n;
    }

    private String getFormatForLanguage(String string, String string2) {
        Object object;
        if (string2 == null || "".equals(string2)) {
            object = Locale.getDefault();
            string2 = ((Locale)object).getLanguage() + "_" + ((Locale)object).getCountry();
        }
        object = "";
        if ("ko_KR".equals(string2)) {
            object = "[$-412]";
        } else if ("ja_JP".equals(string2)) {
            object = "[$-411]";
        } else if ("zh_CN".equals(string2)) {
            object = "[$-804]";
        } else if ("zh_HK".equals(string2)) {
            object = "[$-C04]";
        } else if ("zh_SG".equals(string2)) {
            object = "[$-1004]";
        } else if ("zh_TW".equals(string2)) {
            object = "[$-404]";
        } else if ("aa_DJ".equals(string2)) {
            object = "[$-1000]";
        } else if ("aa_ER".equals(string2)) {
            object = "[$-1000]";
        } else if ("aa_ET".equals(string2)) {
            object = "[$-1000]";
        } else if ("af_ZA".equals(string2)) {
            object = "[$-436]";
        } else if ("ar_AE".equals(string2)) {
            object = "[$-3801]";
        } else if ("ar_BH".equals(string2)) {
            object = "[$-3C01]";
        } else if ("ar_DZ".equals(string2)) {
            object = "[$-1401]";
        } else if ("ar_EG".equals(string2)) {
            object = "[$-c01]";
        } else if ("ar_IN".equals(string2)) {
            object = "[$-1]";
        } else if ("ar_IQ".equals(string2)) {
            object = "[$-801]";
        } else if ("ar_JO".equals(string2)) {
            object = "[$-2C01]";
        } else if ("ar_KW".equals(string2)) {
            object = "[$-3401]";
        } else if ("ar_LB".equals(string2)) {
            object = "[$-3001]";
        } else if ("ar_LY".equals(string2)) {
            object = "[$-1001]";
        } else if ("ar_MA".equals(string2)) {
            object = "[$-1801]";
        } else if ("ar_OM".equals(string2)) {
            object = "[$-2001]";
        } else if ("ar_QA".equals(string2)) {
            object = "[$-4001]";
        } else if ("ar_SA".equals(string2)) {
            object = "[$-401]";
        } else if ("ar_SD".equals(string2)) {
            object = "[$-1000]";
        } else if ("ar_SY".equals(string2)) {
            object = "[$-2801]";
        } else if ("ar_TN".equals(string2)) {
            object = "[$-1C01]";
        } else if ("ar_YE".equals(string2)) {
            object = "[$-2401]";
        } else if ("as_IN".equals(string2)) {
            object = "[$-44D]";
        } else if ("az_AZ".equals(string2)) {
            object = "[$-2C]";
        } else if ("be_BY".equals(string2)) {
            object = "[$-423]";
        } else if ("bg_BG".equals(string2)) {
            object = "[$-402]";
        } else if ("bn_BD".equals(string2)) {
            object = "[$-845]";
        } else if ("bn_IN".equals(string2)) {
            object = "[$-445]";
        } else if ("br_FR".equals(string2)) {
            object = "[$-47E]";
        } else if ("bs_BA".equals(string2)) {
            object = "[$-781A]";
        } else if ("ca_AD".equals(string2)) {
            object = "[$-1000]";
        } else if ("ca_ES".equals(string2)) {
            object = "[$-403]";
        } else if ("ca_FR".equals(string2)) {
            object = "[$-1000]";
        } else if ("ca_IT".equals(string2)) {
            object = "[$-1000]";
        } else if ("cs_CZ".equals(string2)) {
            object = "[$-405]";
        } else if ("cy_GB".equals(string2)) {
            object = "[$-452]";
        } else if ("da_DK".equals(string2)) {
            object = "[$-406]";
        } else if ("de_AT".equals(string2)) {
            object = "[$-C07]";
        } else if ("de_BE".equals(string2)) {
            object = "[$-1000]";
        } else if ("de_CH".equals(string2)) {
            object = "[$-807]";
        } else if ("de_DE".equals(string2)) {
            object = "[$-407]";
        } else if ("de_LU".equals(string2)) {
            object = "[$-1007]";
        } else if ("dz_BT".equals(string2)) {
            object = "[$-C51]";
        } else if ("el_CY".equals(string2)) {
            object = "[$-1000]";
        } else if ("el_GR".equals(string2)) {
            object = "[$-408]";
        } else if ("en_AU".equals(string2)) {
            object = "[$-C09]";
        } else if ("en_BW".equals(string2)) {
            object = "[$-1000]";
        } else if ("en_CA".equals(string2)) {
            object = "[$-1009]";
        } else if ("en_DK".equals(string2)) {
            object = "[$-1000]";
        } else if ("en_GB".equals(string2)) {
            object = "[$-809]";
        } else if ("en_HK".equals(string2)) {
            object = "[$-3C09]";
        } else if ("en_IE".equals(string2)) {
            object = "[$-1809]";
        } else if ("en_IN".equals(string2)) {
            object = "[$-4009]";
        } else if ("en_NZ".equals(string2)) {
            object = "[$-1409]";
        } else if ("en_PH".equals(string2)) {
            object = "[$-3409]";
        } else if ("en_SG".equals(string2)) {
            object = "[$-4809]";
        } else if ("en_US".equals(string2)) {
            object = "[$-409]";
        } else if ("en_ZA".equals(string2)) {
            object = "[$-1C09]";
        } else if ("en_ZW".equals(string2)) {
            object = "[$-3009]";
        } else if ("es_AR".equals(string2)) {
            object = "[$-2C0A]";
        } else if ("es_BO".equals(string2)) {
            object = "[$-400A]";
        } else if ("es_CL".equals(string2)) {
            object = "[$-340A]";
        } else if ("es_CO".equals(string2)) {
            object = "[$-240A]";
        } else if ("es_CR".equals(string2)) {
            object = "[$-140A]";
        } else if ("es_DO".equals(string2)) {
            object = "[$-1c0A]";
        } else if ("es_EC".equals(string2)) {
            object = "[$-300A]";
        } else if ("es_ES".equals(string2)) {
            object = "[$-0c0A]";
        } else if ("es_GT".equals(string2)) {
            object = "[$-100A]";
        } else if ("es_HN".equals(string2)) {
            object = "[$-480A]";
        } else if ("es_MX".equals(string2)) {
            object = "[$-80A]";
        } else if ("es_NI".equals(string2)) {
            object = "[$-4C0A]";
        } else if ("es_PA".equals(string2)) {
            object = "[$-180A]";
        } else if ("es_PE".equals(string2)) {
            object = "[$-280A]";
        } else if ("es_PR".equals(string2)) {
            object = "[$-500A]";
        } else if ("es_PY".equals(string2)) {
            object = "[$-3C0A]";
        } else if ("es_SV".equals(string2)) {
            object = "[$-440A]";
        } else if ("es_US".equals(string2)) {
            object = "[$-540A]";
        } else if ("es_UY".equals(string2)) {
            object = "[$-380A]";
        } else if ("es_VE".equals(string2)) {
            object = "[$-200A]";
        } else if ("et_EE".equals(string2)) {
            object = "[$-425]";
        } else if ("eu_ES".equals(string2)) {
            object = "[$-42D]";
        } else if ("fa_IR".equals(string2)) {
            object = "[$-429]";
        } else if ("fi_FI".equals(string2)) {
            object = "[$-40B]";
        } else if ("fo_FO".equals(string2)) {
            object = "[$-438]";
        } else if ("fr_BE".equals(string2)) {
            object = "[$-80C]";
        } else if ("fr_CA".equals(string2)) {
            object = "[$-c0C]";
        } else if ("fr_CH".equals(string2)) {
            object = "[$-100C]";
        } else if ("fr_FR".equals(string2)) {
            object = "[$-40C]";
        } else if ("fr_LU".equals(string2)) {
            object = "[$-140C]";
        } else if ("fy_NL".equals(string2)) {
            object = "[$-462]";
        } else if ("ga_IE".equals(string2)) {
            object = "[$-83C]";
        } else if ("gd_GB".equals(string2)) {
            object = "[$-491]";
        } else if ("gl_ES".equals(string2)) {
            object = "[$-456]";
        } else if ("gu_IN".equals(string2)) {
            object = "[$-447]";
        } else if ("gv_GB".equals(string2)) {
            object = "[$-1000]";
        } else if ("he_IL".equals(string2)) {
            object = "[$-40D]";
        } else if ("hi_IN".equals(string2)) {
            object = "[$-439]";
        } else if ("hr_HR".equals(string2)) {
            object = "[$-41A]";
        } else if ("hu_HU".equals(string2)) {
            object = "[$-40E]";
        } else if ("hy_AM".equals(string2)) {
            object = "[$-42B]";
        } else if ("id_ID".equals(string2)) {
            object = "[$-421]";
        } else if ("is_IS".equals(string2)) {
            object = "[$-40F]";
        } else if ("it_CH".equals(string2)) {
            object = "[$-810]";
        } else if ("it_IT".equals(string2)) {
            object = "[$-410]";
        } else if ("iw_IL".equals(string2)) {
            object = "[$-40D]";
        } else if ("ka_GE".equals(string2)) {
            object = "[$-437]";
        } else if ("kk_KZ".equals(string2)) {
            object = "[$-43F]";
        } else if ("kl_GL".equals(string2)) {
            object = "[$-46F]";
        } else if ("km_KH".equals(string2)) {
            object = "[$-453]";
        } else if ("kn_IN".equals(string2)) {
            object = "[$-44B]";
        } else if ("ku_TR".equals(string2)) {
            object = "[$-92]";
        } else if ("kw_GB".equals(string2)) {
            object = "[$-1000]";
        } else if ("ky_KG".equals(string2)) {
            object = "[$-440]";
        } else if ("lg_UG".equals(string2)) {
            object = "[$-1000]";
        } else if ("lo_LA".equals(string2)) {
            object = "[$-454]";
        } else if ("lt_LT".equals(string2)) {
            object = "[$-427]";
        } else if ("lv_LV".equals(string2)) {
            object = "[$-426]";
        } else if ("mg_MG".equals(string2)) {
            object = "[$-1000]";
        } else if ("mi_NZ".equals(string2)) {
            object = "[$-481]";
        } else if ("mk_MK".equals(string2)) {
            object = "[$-42F]";
        } else if ("ml_IN".equals(string2)) {
            object = "[$-44C]";
        } else if ("mn_MN".equals(string2)) {
            object = "[$-450]";
        } else if ("mr_IN".equals(string2)) {
            object = "[$-44E]";
        } else if ("ms_MY".equals(string2)) {
            object = "[$-43E]";
        } else if ("mt_MT".equals(string2)) {
            object = "[$-43A]";
        } else if ("nb_NO".equals(string2)) {
            object = "[$-414]";
        } else if ("ne_NP".equals(string2)) {
            object = "[$-461]";
        } else if ("nl_BE".equals(string2)) {
            object = "[$-813]";
        } else if ("nl_NL".equals(string2)) {
            object = "[$-413]";
        } else if ("nn_NO".equals(string2)) {
            object = "[$-814]";
        } else if ("no_NO".equals(string2)) {
            object = "[$-414]";
        } else if ("nr_ZA".equals(string2)) {
            object = "[$-1000]";
        } else if ("oc_FR".equals(string2)) {
            object = "[$-482]";
        } else if ("om_ET".equals(string2)) {
            object = "[$-472]";
        } else if ("om_KE".equals(string2)) {
            object = "[$-1000]";
        } else if ("or_IN".equals(string2)) {
            object = "[$-448]";
        } else if ("pa_IN".equals(string2)) {
            object = "[$-446]";
        } else if ("pa_PK".equals(string2)) {
            object = "[$-46]";
        } else if ("pl_PL".equals(string2)) {
            object = "[$-415]";
        } else if ("pt_BR".equals(string2)) {
            object = "[$-416]";
        } else if ("pt_PT".equals(string2)) {
            object = "[$-816]";
        } else if ("ro_RO".equals(string2)) {
            object = "[$-418]";
        } else if ("ru_RU".equals(string2)) {
            object = "[$-419]";
        } else if ("ru_UA".equals(string2)) {
            object = "[$-1000]";
        } else if ("rw_RW".equals(string2)) {
            object = "[$-487]";
        } else if ("se_NO".equals(string2)) {
            object = "[$-43B]";
        } else if ("si_LK".equals(string2)) {
            object = "[$-45B]";
        } else if ("sk_SK".equals(string2)) {
            object = "[$-41B]";
        } else if ("sl_SI".equals(string2)) {
            object = "[$-424]";
        } else if ("so_DJ".equals(string2)) {
            object = "[$-1000]";
        } else if ("so_ET".equals(string2)) {
            object = "[$-1000]";
        } else if ("so_KE".equals(string2)) {
            object = "[$-1000]";
        } else if ("so_SO".equals(string2)) {
            object = "[$-477]";
        } else if ("sq_AL".equals(string2)) {
            object = "[$-41C]";
        } else if ("sr_CS".equals(string2)) {
            object = "[$-C1A]";
        } else if ("sr_ME".equals(string2)) {
            object = "[$-301A]";
        } else if ("sr_RS".equals(string2)) {
            object = "[$-281A]";
        } else if ("ss_ZA".equals(string2)) {
            object = "[$-1000]";
        } else if ("st_ZA".equals(string2)) {
            object = "[$-430]";
        } else if ("sv_FI".equals(string2)) {
            object = "[$-81D]";
        } else if ("sv_SE".equals(string2)) {
            object = "[$-41D]";
        } else if ("ta_IN".equals(string2)) {
            object = "[$-449]";
        } else if ("te_IN".equals(string2)) {
            object = "[$-44A]";
        } else if ("tg_TJ".equals(string2)) {
            object = "[$-428]";
        } else if ("th_TH".equals(string2)) {
            object = "[$-41E]";
        } else if ("ti_ER".equals(string2)) {
            object = "[$-873]";
        } else if ("ti_ET".equals(string2)) {
            object = "[$-473]";
        } else if ("tl_PH".equals(string2)) {
            object = "[$-464]";
        } else if ("tn_ZA".equals(string2)) {
            object = "[$-432]";
        } else if ("tr_CY".equals(string2)) {
            object = "[$-1000]";
        } else if ("tr_TR".equals(string2)) {
            object = "[$-41F]";
        } else if ("ts_ZA".equals(string2)) {
            object = "[$-431]";
        } else if ("tt_RU".equals(string2)) {
            object = "[$-444]";
        } else if ("uk_UA".equals(string2)) {
            object = "[$-422]";
        } else if ("ur_PK".equals(string2)) {
            object = "[$-420]";
        } else if ("uz_UZ".equals(string2)) {
            object = "[$-843]";
        } else if ("ve_ZA".equals(string2)) {
            object = "[$-433]";
        } else if ("vi_VN".equals(string2)) {
            object = "[$-42A]";
        } else if ("wa_BE".equals(string2)) {
            object = "[$-C]";
        } else if ("xh_ZA".equals(string2)) {
            object = "[$-434]";
        } else if ("yi_US".equals(string2)) {
            object = "[$-409]";
        } else if ("zu_ZA".equals(string2)) {
            object = "[$-435]";
        }
        object = (String)object + string;
        return object;
    }
}

