/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.GridExportFormatFactory;
import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import com.nexacro.java.xeni.data.exportformats.FormatCell;
import com.nexacro.java.xeni.data.exportformats.FormatColumn;
import com.nexacro.java.xeni.data.exportformats.FormatRow;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.export.impl.GridCellStyleInfo;
import com.nexacro.java.xeni.export.impl.GridCellStyleInfoExt;
import com.nexacro.java.xeni.extend.XeniDataValidationBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.ImageUtils;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GridPartExportExcel
implements GridExportBase {
    private static final Log logger = LogFactory.getLog(GridPartExportExcel.class);
    private final float PX_MODIFIED = 36.56f;
    private final float PX_DEFAULT = 32.0f;
    private final int PX_POW = 15;
    private final int PX_PADDING = 2;
    private final int PIXEL_DPI = 96;
    private final int POINT_DPI = 72;
    private int nextExcelRow = 0;
    private long accessTime = 0L;
    private boolean isEof = false;
    private boolean isOdd = false;
    private String errorMessage = "";
    private String groupSeparator = String.valueOf('\u001d');
    private String absolutePath;
    private String downloadUrl;
    private Sheet sheet = null;
    private Workbook workBook = null;
    private ExportFormat gridFormat = null;
    private GridCellStyleInfo styleInfo = new GridCellStyleInfo();
    private GridExportContext context = null;
    private Drawing drawing = null;
    private HashMap<String, Integer> pictures = new HashMap();
    private XeniDataValidationBase validator;

    @Override
    public long getAccessTime() {
        return this.accessTime;
    }

    @Override
    public void setAccessTime(long l) {
        this.accessTime = l;
    }

    @Override
    public boolean isEof() {
        return this.isEof;
    }

    @Override
    public void setEof(boolean bl) {
        this.isEof = bl;
    }

    @Override
    public GridExportContext getExportContext() {
        return this.context;
    }

    @Override
    public int initialize(GridExportContext gridExportContext, DataSet dataSet) {
        this.validator = XeniExtendLoader.getDataValidationFactory().getDataValidator();
        this.context = gridExportContext;
        this.setRangeInfo(dataSet.getString(0, "range"));
        int n = this.getExportFilePath();
        if (n < 0) {
            return n;
        }
        if ("PlatformXml".equals(this.context.getRequestPlatformType()) || this.context.getCommandVersion() >= 2.0f && "PlatformJson".equals(this.context.getRequestPlatformType())) {
            this.groupSeparator = "_x001D_";
        }
        String string = dataSet.getString(0, "format");
        if (this.context.getCommandVersion() == 2.0f) {
            string = new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
        } else if (this.context.getCommandVersion() == 3.0f) {
            string = new String(new Base32().decode(string), StandardCharsets.UTF_8);
        }
        this.gridFormat = new GridExportFormatFactory().readFormatString(string);
        if (this.gridFormat == null) {
            this.setErrorMessage("Fail to create grid format.");
            return -2012;
        }
        this.nextExcelRow = this.context.getStartRowIndex();
        this.workBook = this.createWorkBook();
        if (this.workBook == null) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fail.create.workbook"));
            return -2012;
        }
        if (this.context.getAppendUrl() != null) {
            this.sheet = this.workBook.getSheet(this.context.getSheetName());
        }
        if (this.sheet == null) {
            this.sheet = this.workBook.createSheet(this.context.getSheetName());
        }
        if (this.sheet == null) {
            this.setErrorMessage("Fail to create sheet.");
            return -2012;
        }
        this.drawing = this.sheet.createDrawingPatriarch();
        if (this.context.isApplyWidth()) {
            this.setColumnLayout(this.context.getStartColIndex(), this.context.isOoxml());
        }
        return 0;
    }

    @Override
    public int startExport(ServletProvider servletProvider, DataSet dataSet, DataSet dataSet2, DataSet dataSet3) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringUtils.normalizeSpace((String)("Start export : " + this.context.getFileName())));
        }
        int n = 0;
        this.context.setSequence(dataSet.getInt(0, "seq"));
        this.setEof(dataSet.getBoolean(0, "eof"));
        if (dataSet2.getRowCount() > 0 && (n = this.styleInfo.getStyleInfo(this.workBook, dataSet2, this.context.isOoxml(), this.context.isWrapText(), this.context.getAppendUrl() != null)) < 0) {
            this.setErrorMessage(this.styleInfo.getErrorMessage());
            return n;
        }
        if (this.context.getSequence() == 1) {
            if (!this.context.isNoHead() && (n = this.setHead()) < 0) {
                return n;
            }
            if (!this.context.isNoSummary() && this.context.isTopSummary() && (n = this.setSummary()) < 0) {
                return n;
            }
        }
        if ((n = this.setBody(dataSet3)) < 0) {
            return n;
        }
        if (this.isEof()) {
            if (!this.context.isNoSummary() && !this.context.isTopSummary() && (n = this.setSummary()) < 0) {
                return n;
            }
            if (this.context.isRtl()) {
                this.sheet.setRightToLeft(true);
            }
            if (this.context.getRowHeights() != null) {
                this.setRowHeights(this.sheet, this.context.getRowHeights());
            }
            n = this.saveExportFile(servletProvider, dataSet);
        } else if (!this.context.isApi()) {
            n = this.sendExportPartResponse(servletProvider, dataSet);
        }
        return n;
    }

    private void setRangeInfo(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        String[] stringArray = string.split("\\!");
        if (stringArray.length == 1) {
            this.context.setSheetName(string);
        } else {
            int[] nArray = new int[]{0, 0};
            CommUtil.getRangeIndex(stringArray[1], nArray);
            this.context.setStartColIndex(nArray[0]);
            this.context.setStartRowIndex(nArray[1]);
            if (stringArray[0].length() > 0) {
                this.context.setSheetName(stringArray[0]);
            }
        }
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMessage = string;
        if (logger.isErrorEnabled()) {
            logger.error((Object)StringUtils.normalizeSpace((String)string));
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private int getExportFilePath() {
        if (this.context.getAppendUrl() == null) {
            String string = this.context.getFileName();
            String string2 = this.context.getInstanceId();
            if (!(string != null && string.length() > 0 || (string = this.context.getItemName()) != null && string.length() > 0)) {
                string = "TEMP";
            }
            if (string.contains(".") || string.contains("/") || string2.contains(".") || string2.contains("/")) {
                this.setErrorMessage("Invalid file or path name.");
                return -3201;
            }
            String string3 = string;
            int n = this.context.getExportType();
            int n2 = 0;
            if (n == 1024) {
                string3 = string3 + ".cell";
                n2 = 2;
            } else if (n == 1040) {
                string3 = string3 + ".cell";
                n2 = 3;
            } else {
                string3 = string3 + ".xls";
                if (this.context.isOoxml()) {
                    string3 = string3 + "x";
                    n2 = 1;
                }
            }
            this.absolutePath = this.context.getAbsolutePath() + string2 + "/" + string3;
            if (this.context.isOutsidePath()) {
                try {
                    this.downloadUrl = this.context.getDownloadUrl() + "?command=export&key=" + string2 + "&name=" + URLEncoder.encode(string, "UTF-8") + "&type=" + n2;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
            } else {
                this.downloadUrl = this.context.getDownloadUrl() + string2 + "/" + string3;
            }
        } else {
            String string = this.context.getAppendUrl();
            this.downloadUrl = string.replaceAll("&amp;", "&");
            if (this.context.isOutsidePath()) {
                int n = string.indexOf("key=");
                String string4 = string.substring(n + 4, string.indexOf(38, n));
                if (string4 == null || string4.contains(".") || string4.contains("/")) {
                    this.setErrorMessage("Invalid key name.");
                    return -3201;
                }
                n = string.indexOf("name=", n);
                String string5 = string.substring(n + 5, string.indexOf(38, n));
                try {
                    string5 = URLDecoder.decode(string5, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
                n = string.indexOf("type=", n);
                int n3 = Integer.parseInt(string.substring(n + 5));
                String string6 = ".xls";
                if (n3 == 1) {
                    string6 = string6 + "x";
                } else if (n3 == 2 || n3 == 3) {
                    string6 = ".cell";
                }
                this.absolutePath = this.context.getAbsolutePath() + string4 + "/" + string5 + string6;
            } else {
                int n = string.lastIndexOf("/");
                String string7 = string.substring(0, n);
                String string8 = string.substring(n);
                String string9 = string8.substring(1, string8.lastIndexOf(46));
                if (string9 == null || string9.contains(".") || string9.contains("/")) {
                    this.setErrorMessage("Invalid file name.");
                    return -3201;
                }
                this.absolutePath = this.context.getAbsolutePath() + string7.substring(string7.lastIndexOf("/") + 1) + string8;
            }
        }
        return 0;
    }

    private void saveExportStream(InputStream inputStream, String string) throws IOException {
        int n;
        if (inputStream == null) {
            return;
        }
        int n2 = string.lastIndexOf("/");
        File file = XeniUtils.getXeniFileHandler(string.substring(0, n2)).toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        file = XeniUtils.getXeniFileHandler(string).toFile();
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook createWorkBook() {
        Object object = null;
        if (this.context.getAppendUrl() == null) {
            object = this.context.isOoxml() ? new SXSSFWorkbook(this.context.getRowAccessSize()) : new HSSFWorkbook();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Read file(workbook) : " + StringUtils.normalizeSpace((String)this.absolutePath)));
            }
            InputStream inputStream = null;
            try {
                File file;
                File file2;
                String string = this.absolutePath;
                XeniExcelDataStorageBase xeniExcelDataStorageBase = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
                if (!(xeniExcelDataStorageBase instanceof XeniExcelDataStorageDef)) {
                    inputStream = xeniExcelDataStorageBase.loadTargetStream(string);
                    if (inputStream != null) {
                        string = string + ".xeni";
                        this.saveExportStream(inputStream, string);
                    }
                } else {
                    file2 = XeniUtils.getXeniFileHandler(string).toFile();
                    string = string + ".xeni";
                    file = XeniUtils.getXeniFileHandler(string).toFile();
                    Files.move(Paths.get(file2.toURI()), Paths.get(file.toURI()), StandardCopyOption.REPLACE_EXISTING);
                }
                file2 = XeniUtils.getXeniFileHandler(string).toFile();
                if (this.context.isOoxml()) {
                    file = WorkbookFactory.create((File)file2, (String)this.context.getPassword());
                    object = new SXSSFWorkbook((XSSFWorkbook)file, this.context.getRowAccessSize());
                } else {
                    object = WorkbookFactory.create((File)file2, (String)this.context.getPassword());
                }
            }
            catch (Exception exception) {
                this.setErrorMessage(exception.getMessage());
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.setErrorMessage(iOException.getMessage());
                }
            }
        }
        return object;
    }

    private void setColumnLayout(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.gridFormat.getColumnCount(); ++i) {
            FormatColumn formatColumn = this.gridFormat.getColumn(i);
            if (formatColumn == null) continue;
            n2 = Integer.parseInt(formatColumn.getSize());
            if (n2 > 1500) {
                n2 = 1500;
            }
            n3 = bl ? n2 * 32 : n2 * 36;
            this.sheet.setColumnWidth(n + i, n3);
        }
    }

    private int createGridFormatBand(String string) {
        int n = this.gridFormat.getColumnCount();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.gridFormat.getRowCount(); ++i) {
            FormatRow formatRow = this.gridFormat.getRow(i);
            if (!formatRow.getBand().equals(string)) continue;
            Row row = this.sheet.createRow(this.nextExcelRow + n2);
            if (this.context.isApplyHeight()) {
                n3 = Integer.parseInt(formatRow.getSize());
                row.setHeight((short)(n3 * 15));
            }
            for (int j = 0; j < n; ++j) {
                row.createCell(j + this.context.getStartColIndex());
            }
            ++n2;
        }
        return n2;
    }

    private Cell getExcelCell(FormatCell formatCell) {
        int n = Integer.parseInt(formatCell.getRow());
        int n2 = Integer.parseInt(formatCell.getCol());
        int n3 = n + this.nextExcelRow;
        int n4 = n2 + this.context.getStartColIndex();
        Row row = this.sheet.getRow(n3);
        Cell cell = row.getCell(n4);
        if (cell == null) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.cell.null", Integer.toString(n3), Integer.toString(n4)));
            return null;
        }
        return cell;
    }

    private int setCellValue(Cell cell, String string, GridCellStyleInfoExt gridCellStyleInfoExt, FormatCell formatCell, boolean bl) {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        if (this.validator != null) {
            string = this.validator.checkData(string);
        }
        if (gridCellStyleInfoExt.isImageData()) {
            this.setCellImage(cell, string, bl, formatCell, gridCellStyleInfoExt.getImageStretch());
        } else {
            int n = gridCellStyleInfoExt.getDataType();
            if (n == 1) {
                string = string.replaceAll("\\,|\\%", "");
                try {
                    if (!"".equals(string)) {
                        double d = Double.parseDouble(string);
                        if (string.matches("^[-+]?\\d+\\.\\d+") && gridCellStyleInfoExt.getDataFormat() == null) {
                            this.setStyleDoubleFormat(string, cell, gridCellStyleInfoExt);
                        }
                        if (gridCellStyleInfoExt.isbPercentage()) {
                            d /= 100.0;
                        }
                        cell.setCellValue(d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setStyleNumberTextFormat(cell, gridCellStyleInfoExt);
                    cell.setCellValue(string);
                }
            } else if (n == 2) {
                try {
                    DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(gridCellStyleInfoExt.getDataFormat()).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
                    LocalDateTime localDateTime = LocalDateTime.parse(string, dateTimeFormatter);
                    cell.setCellValue(localDateTime);
                }
                catch (Exception exception) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)exception.getMessage());
                    }
                    cell.setCellValue(string);
                }
            } else if (n == 0) {
                if (string.charAt(0) == '=') {
                    cell.setCellFormula(string.substring(1));
                } else {
                    cell.setCellValue(string);
                }
            } else {
                cell.setCellValue(string);
            }
        }
        return 0;
    }

    private void setMergeCell(FormatCell formatCell, Cell cell, CellStyle cellStyle) {
        int n = Integer.parseInt(formatCell.getRowspan());
        int n2 = Integer.parseInt(formatCell.getColspan());
        if (n > 1 || n2 > 1) {
            int n3 = cell.getRowIndex();
            int n4 = cell.getColumnIndex();
            this.sheet.addMergedRegionUnsafe(new CellRangeAddress(n3, n3 + n - 1, n4, n4 + n2 - 1));
            if (cellStyle == null) {
                return;
            }
            Row row = null;
            Cell cell2 = null;
            for (int i = n3; i < n3 + n; ++i) {
                row = this.sheet.getRow(i);
                if (row == null) continue;
                for (int j = n4; j < n4 + n2; ++j) {
                    if (i == n3 && j == n4 || (cell2 = row.getCell(j)) == null) continue;
                    cell2.setCellStyle(cellStyle);
                }
            }
        }
    }

    private void setSuppressCell(FormatCell formatCell, Cell cell, GridCellStyleInfoExt gridCellStyleInfoExt) {
        int n = gridCellStyleInfoExt.getiRowSuppressCount();
        int n2 = gridCellStyleInfoExt.getiColSuppressCount();
        if (n > 1 || n2 > 1) {
            int n3 = cell.getRowIndex();
            int n4 = cell.getColumnIndex();
            int n5 = Integer.parseInt(formatCell.getRowspan()) - 1;
            int n6 = Integer.parseInt(formatCell.getColspan()) - 1;
            int n7 = n3;
            int n8 = n4;
            if (n > 1) {
                n7 = n3 - (n - n5 - 1);
            }
            if (n2 > 1) {
                n8 = n4 - (n2 - n6 - 1);
            }
            CellRangeAddress cellRangeAddress = new CellRangeAddress(n7, n3 + n5, n8, n4 + n6);
            this.removeMergedRegion(cellRangeAddress);
            this.setMergedCellStyle(cell.getCellStyle(), cellRangeAddress);
            this.sheet.addMergedRegion(cellRangeAddress);
        }
    }

    private void removeMergedRegion(CellRangeAddress cellRangeAddress) {
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getLastRow();
        int n3 = cellRangeAddress.getFirstColumn();
        int n4 = cellRangeAddress.getLastColumn();
        for (int i = this.sheet.getNumMergedRegions() - 1; i >= 0; --i) {
            CellRangeAddress cellRangeAddress2 = this.sheet.getMergedRegion(i);
            int n5 = cellRangeAddress2.getFirstRow();
            int n6 = cellRangeAddress2.getLastRow();
            int n7 = cellRangeAddress2.getFirstColumn();
            int n8 = cellRangeAddress2.getLastColumn();
            if ((n > n5 || n5 > n2) && (n > n6 || n6 > n2) || (n3 > n7 || n7 > n4) && (n3 > n8 || n8 > n4)) continue;
            this.sheet.removeMergedRegion(i);
        }
    }

    private void setMergedCellStyle(CellStyle cellStyle, CellRangeAddress cellRangeAddress) {
        if (cellStyle == null) {
            return;
        }
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getLastRow();
        int n3 = cellRangeAddress.getFirstColumn();
        int n4 = cellRangeAddress.getLastColumn();
        Row row = null;
        Cell cell = null;
        for (int i = n; i <= n2; ++i) {
            row = this.sheet.getRow(i);
            if (row == null) continue;
            for (int j = n3; j <= n4; ++j) {
                cell = row.getCell(j);
                if (cell == null) continue;
                cell.setCellStyle(cellStyle);
            }
        }
    }

    private void setStyleDoubleFormat(String string, Cell cell, GridCellStyleInfoExt gridCellStyleInfoExt) {
        short s;
        String string2 = "#,##0";
        String string3 = string.substring(string.indexOf(46) + 1);
        for (s = 0; s < string3.length(); ++s) {
            if (s == 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + "0";
        }
        string2 = string2 + "_ ";
        s = this.workBook.createDataFormat().getFormat(string2);
        String string4 = gridCellStyleInfoExt.getStyleName() + "_dbl" + s;
        GridCellStyleInfoExt gridCellStyleInfoExt2 = this.styleInfo.getCellStyle(string4);
        CellStyle cellStyle = null;
        if (gridCellStyleInfoExt2 == null) {
            cellStyle = this.workBook.createCellStyle();
            CellStyle cellStyle2 = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex());
            cellStyle.cloneStyleFrom(cellStyle2);
            cellStyle.setDataFormat(s);
            this.styleInfo.appendStyle(string4, cellStyle.getIndex(), gridCellStyleInfoExt.getDataType(), gridCellStyleInfoExt.getDataFormat(), gridCellStyleInfoExt.isImageData());
        } else {
            cellStyle = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt2.getStyleIndex());
        }
        cell.setCellStyle(cellStyle);
    }

    private void setStyleNumberTextFormat(Cell cell, GridCellStyleInfoExt gridCellStyleInfoExt) {
        CellStyle cellStyle = null;
        String string = gridCellStyleInfoExt.getStyleName();
        GridCellStyleInfoExt gridCellStyleInfoExt2 = this.styleInfo.getCellStyle(string + "text");
        if (gridCellStyleInfoExt2 == null) {
            cellStyle = this.workBook.createCellStyle();
            CellStyle cellStyle2 = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex());
            cellStyle.cloneStyleFrom(cellStyle2);
            cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"TEXT"));
            this.styleInfo.appendStyle(string + "text", cellStyle.getIndex(), gridCellStyleInfoExt.getDataType(), gridCellStyleInfoExt.getDataFormat(), gridCellStyleInfoExt.isImageData());
        } else {
            cellStyle = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt2.getStyleIndex());
        }
        cell.setCellStyle(cellStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellImage(Cell cell, String string, boolean bl, FormatCell formatCell, int n) {
        FilterInputStream filterInputStream = null;
        try {
            int n2 = -1;
            String string2 = "";
            byte[] byArray = null;
            if (string.trim().startsWith("http")) {
                if (this.pictures.containsKey(string)) {
                    n2 = this.pictures.get(string);
                } else {
                    URL uRL = new URL(this.getEncodedUrl(string));
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(5000);
                    uRLConnection.connect();
                    filterInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
                    byArray = IOUtils.toByteArray((InputStream)filterInputStream);
                    String string3 = string.substring(string.lastIndexOf(".") + 1);
                    n2 = this.workBook.addPicture(byArray, this.getPictureType(string3));
                    this.pictures.put(string, n2);
                    string2 = string;
                }
            } else if (string.trim().startsWith("data:")) {
                String string4;
                String[] stringArray;
                String[] stringArray2;
                int n3 = string.indexOf(44);
                if (n3 < 0) {
                    boolean bl2 = false;
                    return bl2;
                }
                String string5 = "png";
                if (n3 > 5 && (stringArray2 = (stringArray = (string4 = string.substring(5, n3)).split(";"))[0].split("/")).length > 1) {
                    string5 = stringArray2[1];
                }
                if ((byArray = Base64.getDecoder().decode(string.substring(n3 + 1))) == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                n2 = this.workBook.addPicture(byArray, this.getPictureType(string5));
                string2 = string5;
            } else {
                boolean bl4 = false;
                return bl4;
            }
            if (n2 >= 0) {
                this.setPicture(this.workBook.getCreationHelper(), cell, n2, string2, bl, formatCell, n);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            boolean bl5 = false;
            return bl5;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException.getMessage());
                }
            }
        }
        return true;
    }

    String getEncodedUrl(String string) throws MalformedURLException, UnsupportedEncodingException {
        URL uRL = new URL(string);
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        StringBuilder stringBuilder = new StringBuilder(string2 + "://");
        stringBuilder.append(string3);
        if (n != -1 && (string2.equals("http") && n != 80 || string2.equals("https") && n != 443)) {
            stringBuilder.append(":").append(n);
        }
        String string4 = uRL.getPath();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        if (!string4.isEmpty()) {
            if (string4.equals(URLDecoder.decode(string4, "UTF-8"))) {
                String[] stringArray = string4.split("/");
                string4 = "";
                for (String string7 : stringArray) {
                    if (string7 == null || string7.isEmpty()) continue;
                    string4 = string4 + "/";
                    string4 = string4 + URLEncoder.encode(string7, "UTF-8").replaceAll("\\+", "%20");
                }
            }
            stringBuilder.append(string4);
        }
        if (string5 != null) {
            if (string5.equals(URLDecoder.decode(string5, "UTF-8"))) {
                string5 = URLEncoder.encode(string5, "UTF-8");
            }
            stringBuilder.append("?").append(string5);
        }
        if (string6 != null) {
            if (string6.equals(URLDecoder.decode(string6, "UTF-8"))) {
                string6 = URLEncoder.encode(string6, "UTF-8");
            }
            stringBuilder.append("#").append(string6);
        }
        return stringBuilder.toString();
    }

    private int getPictureType(String string) {
        if ((string = string.toUpperCase()).equals("JPEG") || string.equals("JPG")) {
            return 5;
        }
        if (string.equals("DIB")) {
            return 7;
        }
        if (string.equals("EMF")) {
            return 2;
        }
        if (string.equals("PICT")) {
            return 4;
        }
        if (string.equals("PNG")) {
            return 6;
        }
        if (string.equals("WMF")) {
            return 3;
        }
        return 6;
    }

    private void setPicture(CreationHelper creationHelper, Cell cell, int n, String string, boolean bl, FormatCell formatCell, int n2) {
        block11: {
            try {
                ClientAnchor clientAnchor = creationHelper.createClientAnchor();
                clientAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                clientAnchor.setCol1(cell.getColumnIndex());
                clientAnchor.setRow1(cell.getRowIndex());
                int n3 = 1;
                int n4 = 1;
                if (bl) {
                    n3 = Integer.parseInt(formatCell.getRowspan());
                    n4 = Integer.parseInt(formatCell.getColspan());
                }
                if (n2 == 2) {
                    clientAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                    Picture picture = this.drawing.createPicture(clientAnchor, n);
                    picture.resize();
                    return;
                }
                clientAnchor.setCol2(cell.getColumnIndex() + n4);
                clientAnchor.setRow2(cell.getRowIndex() + n3);
                if (n2 == 0) {
                    this.drawing.createPicture(clientAnchor, n);
                    return;
                }
                Picture picture = this.drawing.createPicture(clientAnchor, n);
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int n5 = this.sheet.getDefaultColumnWidth() * 256;
                if (this.context.isOoxml()) {
                    int n6;
                    for (n6 = cell.getRowIndex(); n6 < cell.getRowIndex() + n3; ++n6) {
                        f2 += this.sheet.getRow(n6).getHeightInPoints() * 96.0f / 72.0f;
                    }
                    for (n6 = cell.getColumnIndex(); n6 < cell.getColumnIndex() + n4; ++n6) {
                        f3 += (float)this.sheet.getColumnWidth(n6) / 32.0f;
                    }
                } else {
                    int n7;
                    for (n7 = cell.getRowIndex(); n7 < cell.getRowIndex() + n3; ++n7) {
                        f2 += (float)(this.sheet.getRow(n7).getHeight() / 15);
                    }
                    for (n7 = cell.getColumnIndex(); n7 < cell.getColumnIndex() + n4; ++n7) {
                        f3 += (float)this.sheet.getColumnWidth(n7);
                    }
                    f = f3 == (float)n5 ? 32.0f : 36.56f;
                    f3 /= f;
                }
                this.resizePicture(picture, clientAnchor, f3, f2, n2, cell.getCellStyle());
            }
            catch (Exception exception) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn((Object)("Fail to draw image : " + StringUtils.normalizeSpace((String)string)));
            }
        }
    }

    private void resizePicture(Picture picture, ClientAnchor clientAnchor, float f, float f2, int n, CellStyle cellStyle) throws IOException {
        if (!this.context.isOoxml()) {
            clientAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
        }
        Dimension dimension = this.getImageDimension(picture.getPictureData());
        BigDecimal bigDecimal = BigDecimal.valueOf(dimension.getHeight());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(f2 - 2.0f);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(dimension.getWidth());
        BigDecimal bigDecimal4 = BigDecimal.valueOf(f - 2.0f);
        BigDecimal bigDecimal5 = BigDecimal.ONE;
        BigDecimal bigDecimal6 = BigDecimal.ONE;
        BigDecimal bigDecimal7 = BigDecimal.ONE;
        if (bigDecimal.compareTo(bigDecimal2) != 0) {
            bigDecimal6 = bigDecimal2.divide(bigDecimal, 5, 1);
        }
        if (bigDecimal3.compareTo(bigDecimal4) != 0) {
            bigDecimal7 = bigDecimal4.divide(bigDecimal3, 5, 1);
        }
        if (bigDecimal6.compareTo(BigDecimal.ONE) != 0 && bigDecimal7.compareTo(BigDecimal.ONE) != 0) {
            if (bigDecimal6.compareTo(BigDecimal.ONE) == 1 && bigDecimal7.compareTo(BigDecimal.ONE) == 1) {
                bigDecimal5 = bigDecimal6.compareTo(bigDecimal7) == 1 ? bigDecimal7 : bigDecimal6;
            } else if (bigDecimal6.compareTo(BigDecimal.ONE) == -1 && bigDecimal7.compareTo(BigDecimal.ONE) == -1) {
                bigDecimal5 = bigDecimal6.compareTo(bigDecimal7) == 1 ? bigDecimal7 : bigDecimal6;
            } else if (bigDecimal7.compareTo(BigDecimal.ONE) == -1) {
                bigDecimal5 = bigDecimal7;
            } else if (bigDecimal6.compareTo(BigDecimal.ONE) == -1) {
                bigDecimal5 = bigDecimal6;
            }
        } else if (bigDecimal6.compareTo(BigDecimal.ONE) == -1) {
            bigDecimal5 = bigDecimal6;
        } else if (bigDecimal7.compareTo(BigDecimal.ONE) == -1) {
            bigDecimal5 = bigDecimal7;
        }
        this.getPreferredSize(picture, clientAnchor, bigDecimal3.multiply(bigDecimal5).doubleValue(), bigDecimal.multiply(bigDecimal5).doubleValue(), f, f2, cellStyle);
    }

    private Dimension getImageDimension(PictureData pictureData) throws IOException {
        if (!this.context.isOoxml()) {
            HSSFPictureData hSSFPictureData = (HSSFPictureData)pictureData;
            return ImageUtils.getImageDimension((InputStream)new ByteArrayInputStream(hSSFPictureData.getData()), (int)hSSFPictureData.getFormat());
        }
        XSSFPictureData xSSFPictureData = (XSSFPictureData)pictureData;
        return ImageUtils.getImageDimension((InputStream)xSSFPictureData.getPackagePart().getInputStream(), (int)xSSFPictureData.getPictureType());
    }

    private void getPreferredSize(Picture picture, ClientAnchor clientAnchor, double d, double d2, float f, float f2, CellStyle cellStyle) throws IOException {
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        if (cellStyle != null) {
            horizontalAlignment = cellStyle.getAlignment();
            verticalAlignment = cellStyle.getVerticalAlignment();
        }
        this.setColumnAnchor(clientAnchor, d, f, horizontalAlignment);
        this.setRowAnchor(clientAnchor, d2, f2, verticalAlignment);
    }

    private void setColumnAnchor(ClientAnchor clientAnchor, double d, float f, HorizontalAlignment horizontalAlignment) {
        int n;
        double d2 = 0.0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.sheet.getDefaultColumnWidth() * 256;
        int n3 = clientAnchor.getCol2();
        int n4 = clientAnchor.getDx1();
        int n5 = clientAnchor.getDx2();
        int n6 = 0;
        int n7 = n3;
        double d3 = (double)f - d;
        double d4 = d3 / 2.0;
        block0: for (n = clientAnchor.getCol1(); n <= n7; ++n) {
            if (!this.context.isOoxml()) {
                n6 = this.sheet.getColumnWidth(n);
                f3 = n6 == n2 ? 32.0f : 36.56f;
                f2 = (float)n6 / f3;
            } else {
                f2 = (float)this.sheet.getColumnWidth(n) / 32.0f;
            }
            d2 += (double)f2;
            if (d2 < d4) {
                continue;
            }
            n4 = !this.context.isOoxml() ? (int)Math.round((d4 - (d2 - (double)f2)) / (double)f2 * 1024.0) : (int)Math.round(9525.0 * (d4 - (d2 - (double)f2)));
            n3 = n;
            d4 += d;
            while (n3 <= n7) {
                if (d2 >= d4) {
                    if (!this.context.isOoxml()) {
                        n5 = (int)Math.round(((double)f2 - (d2 - d4)) / (double)f2 * 1024.0);
                        break block0;
                    }
                    n5 = (int)Math.round(9525.0 * ((double)f2 - (d2 - d4)));
                    break block0;
                }
                ++n3;
                if (!this.context.isOoxml()) {
                    n6 = this.sheet.getColumnWidth(n3);
                    f3 = n6 == n2 ? 32.0f : 36.56f;
                    f2 = (float)n6 / f3;
                } else {
                    f2 = (float)this.sheet.getColumnWidth(n3) / 32.0f;
                }
                d2 += (double)f2;
            }
            break block0;
        }
        clientAnchor.setCol1(n);
        clientAnchor.setCol2(n3);
        clientAnchor.setDx1(n4);
        clientAnchor.setDx2(n5);
    }

    private void setRowAnchor(ClientAnchor clientAnchor, double d, float f, VerticalAlignment verticalAlignment) {
        int n;
        Row row = null;
        double d2 = 0.0;
        int n2 = clientAnchor.getRow2();
        int n3 = clientAnchor.getDy1();
        int n4 = clientAnchor.getDy2();
        int n5 = n2;
        double d3 = (double)f - d;
        double d4 = d3 / 2.0;
        block0: for (n = clientAnchor.getRow1(); n <= n5; ++n) {
            float f2 = 0.0f;
            row = this.sheet.getRow(n);
            f2 = !this.context.isOoxml() ? (row != null ? (float)(row.getHeight() / 15) : (float)(this.sheet.getDefaultRowHeight() / 15)) : (row != null ? row.getHeightInPoints() * 96.0f / 72.0f : this.sheet.getDefaultRowHeightInPoints() * 96.0f / 72.0f);
            d2 += (double)f2;
            if (d2 < d4) {
                continue;
            }
            n3 = !this.context.isOoxml() ? (int)Math.round((d4 - (d2 - (double)f2)) / (double)f2 * 256.0) : (int)Math.round(9525.0 * (d4 - (d2 - (double)f2)));
            n2 = n;
            d4 += d;
            while (n2 <= n5) {
                if (d2 >= d4) {
                    if (!this.context.isOoxml()) {
                        n4 = (int)Math.round(((double)f2 - (d2 - d4)) / (double)f2 * 256.0);
                        break block0;
                    }
                    n4 = (int)Math.round(9525.0 * ((double)f2 - (d2 - d4)));
                    break block0;
                }
                row = this.sheet.getRow(++n2);
                f2 = !this.context.isOoxml() ? (row != null ? (float)(row.getHeight() / 15) : (float)(this.sheet.getDefaultRowHeight() / 15)) : (row != null ? row.getHeightInPoints() * 96.0f / 72.0f : this.sheet.getDefaultRowHeightInPoints() * 96.0f / 72.0f);
                d2 += (double)f2;
            }
            break block0;
        }
        clientAnchor.setRow1(n);
        clientAnchor.setRow2(n2);
        clientAnchor.setDy1(n3);
        clientAnchor.setDy2(n4);
    }

    private GridCellStyleInfoExt getBodyCellStyle(Cell cell, FormatCell formatCell, String string) {
        GridCellStyleInfoExt gridCellStyleInfoExt = this.styleInfo.getCellStyle(string);
        if (gridCellStyleInfoExt == null) {
            String string2;
            String string3 = this.isOdd ? ((string2 = formatCell.getStyle2()) != null && string2.length() > 0 ? string2 : formatCell.getStyle1()) : formatCell.getStyle1();
            gridCellStyleInfoExt = this.styleInfo.getCellStyle(string3);
        }
        return gridCellStyleInfoExt;
    }

    private int setHead() {
        int n = 0;
        int n2 = this.createGridFormatBand("head");
        if (n2 > 0) {
            n = this.setHeadData();
            this.nextExcelRow += n2;
        }
        return n;
    }

    private int setHeadData() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringUtils.normalizeSpace((String)("Export head( format count : " + this.gridFormat.getHeadCellCount() + " )")));
        }
        CellStyle cellStyle = null;
        FormatCell formatCell = null;
        for (int i = 0; i < this.gridFormat.getHeadCellCount(); ++i) {
            formatCell = this.gridFormat.getHeadCell(i);
            Cell cell = this.getExcelCell(formatCell);
            if (cell == null) {
                this.setErrorMessage("Fail to get excel cell(set head).");
                return -2015;
            }
            GridCellStyleInfoExt gridCellStyleInfoExt = this.styleInfo.getCellStyle(formatCell.getStyle1());
            if (gridCellStyleInfoExt != null && (cellStyle = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex())) != null) {
                cell.setCellStyle(cellStyle);
            }
            this.setCellValue(cell, formatCell.getText(), gridCellStyleInfoExt, formatCell, true);
            this.setMergeCell(formatCell, cell, cellStyle);
        }
        return 0;
    }

    private int setSummary() {
        int n = 0;
        int n2 = this.createGridFormatBand("summ");
        if (n2 > 0) {
            n = this.setSummaryData();
            this.nextExcelRow += n2;
        }
        return n;
    }

    private int setSummaryData() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringUtils.normalizeSpace((String)("Export summary( format count : " + this.gridFormat.getSummaryCellCount() + " )")));
        }
        CellStyle cellStyle = null;
        FormatCell formatCell = null;
        for (int i = 0; i < this.gridFormat.getSummaryCellCount(); ++i) {
            formatCell = this.gridFormat.getSummary(i);
            Cell cell = this.getExcelCell(formatCell);
            if (cell == null) {
                this.setErrorMessage("Fail to get excel cell(set summary).");
                return -2015;
            }
            GridCellStyleInfoExt gridCellStyleInfoExt = this.styleInfo.getCellStyle(formatCell.getStyle1());
            if (gridCellStyleInfoExt != null && (cellStyle = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex())) != null) {
                cell.setCellStyle(cellStyle);
            }
            this.setCellValue(cell, formatCell.getText(), gridCellStyleInfoExt, formatCell, true);
            this.setMergeCell(formatCell, cell, cellStyle);
        }
        return 0;
    }

    private int setBody(DataSet dataSet) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        dataSet.stopStoreDataChanges();
        while (dataSet.getRowCount() > 0) {
            n2 = this.createGridFormatBand("body");
            if (n2 > 0) {
                n = this.setBodyData(dataSet, n3);
                if (n < 0) {
                    return n;
                }
                this.nextExcelRow += n2;
            }
            this.isOdd = !this.isOdd;
            dataSet.removeRow(n3);
        }
        return n;
    }

    private int setBodyData(DataSet dataSet, int n) {
        int n2;
        int n3 = 0;
        int n4 = dataSet.getColumnCount();
        if (n4 != (n2 = this.gridFormat.getBodyCellCount())) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fault.bodyformat", Integer.toString(n4), Integer.toString(n2)));
            return -2014;
        }
        CellStyle cellStyle = null;
        FormatCell formatCell = null;
        GridCellStyleInfoExt gridCellStyleInfoExt = null;
        for (int i = 0; i < n2; ++i) {
            formatCell = this.gridFormat.getBodyCell(i);
            Cell cell = this.getExcelCell(formatCell);
            if (cell == null) {
                this.setErrorMessage("Fail to get excel cell(set body).");
                return -2015;
            }
            String string = "";
            String string2 = "";
            boolean bl = true;
            String string3 = dataSet.getString(n, i);
            if (string3 != null && string3.length() > 0) {
                String[] stringArray = string3.split(this.groupSeparator);
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
                if (stringArray.length > 1) {
                    string2 = stringArray[1];
                }
                if (stringArray.length > 2 && "true".equals(stringArray[2])) {
                    bl = false;
                }
            }
            if ((gridCellStyleInfoExt = this.getBodyCellStyle(cell, formatCell, string2)) != null && (cellStyle = this.workBook.getCellStyleAt((int)gridCellStyleInfoExt.getStyleIndex())) != null) {
                cell.setCellStyle(cellStyle);
            }
            if (this.context.getCommandVersion() == 2.0f) {
                string = new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
            } else if (this.context.getCommandVersion() == 3.0f) {
                string = new String(new Base32().decode(string), StandardCharsets.UTF_8);
            }
            n3 = this.setCellValue(cell, string, gridCellStyleInfoExt, formatCell, bl);
            if (bl) {
                this.setMergeCell(formatCell, cell, cellStyle);
            }
            this.setSuppressCell(formatCell, cell, gridCellStyleInfoExt);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveExportFile(ServletProvider servletProvider, DataSet dataSet) {
        int n = 0;
        try {
            XeniExcelDataStorageBase xeniExcelDataStorageBase = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
            if (xeniExcelDataStorageBase == null) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fail.create.extendclass", "xeni.exportimport.storage"));
                int n2 = -2004;
                return n2;
            }
            if (xeniExcelDataStorageBase instanceof XeniExcelDataStorageDef) {
                n = this.saveExportStreamDefault(servletProvider, dataSet);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.workBook.write((OutputStream)byteArrayOutputStream);
                n = xeniExcelDataStorageBase.saveExportStream(this.context.getUserVariableList(), dataSet, byteArrayOutputStream, this.absolutePath, this.downloadUrl, servletProvider.getHttpServletResponse());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.no.such.file"));
            n = -2020;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
            n = -2001;
        }
        finally {
            try {
                this.workBook.close();
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage());
            }
            if (this.context.isOoxml()) {
                ((SXSSFWorkbook)this.workBook).dispose();
            }
            this.pictures.clear();
            this.styleInfo.clear();
        }
        return n;
    }

    private int sendExportPartResponse(ServletProvider servletProvider, DataSet dataSet) {
        PlatformData platformData = new PlatformData();
        VariableList variableList = platformData.getVariableList();
        variableList.add("ErrorCode", 0);
        variableList.add("ErrorMsg", "SUCCESS");
        DataSet dataSet2 = CommUtil.getDatasetExportResponse(dataSet);
        if (this.isEof()) {
            dataSet2.set(0, "url", this.downloadUrl);
        }
        platformData.addDataSet(dataSet2);
        try {
            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(servletProvider.getHttpServletResponse(), this.context.getResponsePlatformType(), "UTF-8");
            httpPlatformResponse.setData(platformData);
            httpPlatformResponse.sendData();
        }
        catch (PlatformException platformException) {
            this.setErrorMessage(platformException.getMessage());
            return -2001;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveExportStreamDefault(ServletProvider servletProvider, DataSet dataSet) {
        String string = this.absolutePath;
        File file = null;
        try {
            file = XeniUtils.getXeniFileHandler(string.substring(0, string.lastIndexOf("/"))).toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(XeniUtils.getXeniFileHandler(string).toFile());
            String string2 = this.context.getPassword();
            if (string2 != null && string2.length() > 0) {
                if (this.context.isOoxml()) {
                    this.workBook.write((OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem();
                    EncryptionInfo encryptionInfo = new EncryptionInfo(EncryptionMode.agile);
                    Encryptor encryptor = encryptionInfo.getEncryptor();
                    encryptor.confirmPassword(string2);
                    OutputStream outputStream = encryptor.getDataStream(pOIFSFileSystem);
                    OPCPackage oPCPackage = OPCPackage.open((String)string);
                    oPCPackage.save(outputStream);
                    oPCPackage.close();
                    outputStream.close();
                    fileOutputStream = new FileOutputStream(XeniUtils.getXeniFileHandler(string).toFile());
                    pOIFSFileSystem.writeFilesystem((OutputStream)fileOutputStream);
                } else {
                    Biff8EncryptionKey.setCurrentUserPassword((String)string2);
                    this.workBook.write((OutputStream)fileOutputStream);
                }
            } else {
                this.workBook.write((OutputStream)fileOutputStream);
            }
            this.sendExportPartResponse(servletProvider, dataSet);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMessage("File not found. (" + this.context.getFileName() + ")");
            int n = -2020;
            return n;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
            int n = -2001;
            return n;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage());
            }
        }
        return 0;
    }

    private void setRowHeights(Sheet sheet, Map<Integer, Integer> map) {
        Set<Integer> set = map.keySet();
        for (Integer n : set) {
            Integer n2;
            Row row = sheet.getRow(n.intValue());
            if (row == null || (n2 = map.get(n)) == null) continue;
            row.setHeight((short)(n2 * 15));
        }
    }
}

