/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.util;

import com.nexacro.java.xapi.util.JavaEnvUtils;
import com.nexacro.java.xeni.util.XeniProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniErrorProperties {
    private static final String DEFAULT_ERROR_PROPERTIES = "en";
    private static final String DEFAULT_VALUE_STRING = "";
    private static final String RESNAME_EN = "error_en.properties";
    private static final String RESNAME_KO = "error_ko.properties";
    private static final String RESNAME_ZH = "error_zh.properties";
    private static Map errorMap;

    private XeniErrorProperties() {
    }

    public static String getErrorProperty(String string) {
        return XeniErrorProperties.getStringProperty(string);
    }

    public static String getErrorProperty(String string, String string2) {
        String string3 = XeniErrorProperties.getStringProperty(string);
        return string3.replace("{0}", string2 == null ? "{}" : string2);
    }

    public static String getErrorProperty(String string, String string2, String string3) {
        String string4 = XeniErrorProperties.getStringProperty(string);
        return string4.replace("{0}", string2 == null ? "{}" : string2).replace("{1}", string3 == null ? "{}" : string3);
    }

    public static Object getProperty(String string) {
        return errorMap.get(string);
    }

    public static String getStringProperty(String string) {
        return XeniErrorProperties.getStringProperty(string, DEFAULT_VALUE_STRING);
    }

    public static String getStringProperty(String string, String string2) {
        Object object = XeniErrorProperties.getProperty(string);
        return object == null ? string2 : object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(URL uRL) {
        if (uRL == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            errorMap.putAll(properties);
        }
        catch (IOException iOException) {
            Log log = LogFactory.getLog(XeniErrorProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not load properties file", (Throwable)iOException);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        }
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = null;
        try {
            uRL = XeniErrorProperties.getJarLocationResource(string);
            if (uRL == null) {
                uRL = XeniErrorProperties.getClasspathResource(string);
            }
            if (uRL == null) {
                uRL = classLoader.getResource("com/nexacro/java/xeni/util/error_en.properties");
            }
            return uRL;
        }
        catch (Throwable throwable) {
            Log log = LogFactory.getLog(XeniErrorProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not find properties file", throwable);
            }
            return null;
        }
    }

    private static URL getJarLocationResource(String string) {
        block13: {
            int n;
            int n2;
            String string2;
            String string3 = XeniErrorProperties.class.getName().replace('.', '/') + ".class";
            URL uRL = XeniErrorProperties.class.getClassLoader().getResource(string3);
            Log log = LogFactory.getLog(XeniErrorProperties.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): path=" + string3 + ", url=" + uRL));
            }
            String string4 = uRL.getProtocol();
            String string5 = string2 = uRL.getFile();
            if (JavaEnvUtils.isAtLeastJavaVersion((String)"1.4")) {
                try {
                    string5 = URLDecoder.decode(string5, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Could not decode filename: urlFile=" + string2), (Throwable)unsupportedEncodingException);
                    }
                }
            } else {
                string5 = URLDecoder.decode(string5);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): protocol=" + string4 + ", file=" + string5 + ", urlFile=" + string2));
            }
            if ((n2 = string5.indexOf("!/", n = string5.startsWith("file:") ? "file:".length() : 0)) > 0) {
                String string6 = string5.substring(n, n2);
                File file = new File(string6);
                File file2 = new File(file.getParent(), string);
                boolean bl = file2.exists();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getJarLocationResource(): jarFile=" + file + ", licenseFile=" + file2 + ", licenseExists=" + bl));
                }
                if (bl) {
                    try {
                        URL uRL2 = file2.toURL();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Loaded property file in JAR dir: path=" + file2.getAbsolutePath()));
                        }
                        return uRL2;
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!log.isInfoEnabled()) break block13;
                        log.info((Object)("Could not find property file in JAR dir: " + malformedURLException.getMessage()));
                    }
                }
            }
        }
        return null;
    }

    private static URL getClasspathResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Log log = LogFactory.getLog(XeniErrorProperties.class);
        try {
            URL uRL = classLoader.getResource(string);
            if (uRL != null && log.isInfoEnabled()) {
                log.info((Object)("Loaded property file in CLASSPATH: path=" + uRL));
            }
            return uRL;
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Could not find property file in CLASSPATH: " + throwable.getMessage()));
            }
            return null;
        }
    }

    static {
        String string;
        errorMap = new HashMap();
        switch (string = XeniProperties.getStringProperty("xeni.error.language", DEFAULT_ERROR_PROPERTIES)) {
            case "ko": {
                XeniErrorProperties.load(XeniErrorProperties.getResource(RESNAME_KO));
                break;
            }
            case "zh": {
                XeniErrorProperties.load(XeniErrorProperties.getResource(RESNAME_ZH));
                break;
            }
            default: {
                XeniErrorProperties.load(XeniErrorProperties.getResource(RESNAME_EN));
            }
        }
    }
}

