/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.importformats.ImportSheet;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.impl.HSSFEventModelHandlerBody;
import com.nexacro.java.xeni.ximport.impl.HSSFEventModelHandlerHead;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportExcelHSSFEvent
implements GridImportBase {
    private static final Log logger = LogFactory.getLog(GridImportExcelHSSFEvent.class);
    private int errorCode = 0;
    private String errorMsg = "SUCCESS";
    private POIFSFileSystem poiFs = null;
    private GridImportContext importContext = null;

    @Override
    public void setOPCPackage(OPCPackage oPCPackage) {
    }

    @Override
    public void setPOIFileSystem(POIFSFileSystem pOIFSFileSystem) {
        this.poiFs = pOIFSFileSystem;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
    }

    @Override
    public void setPartIndex(int n) {
    }

    @Override
    public int getPartIndex() {
        return 0;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMsg = string;
        if (logger.isInfoEnabled()) {
            logger.info((Object)StringUtils.normalizeSpace((String)string));
        }
    }

    @Override
    public void initialize(GridImportContext gridImportContext) {
        this.importContext = gridImportContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startImport() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Excute import : HSSF");
        }
        if (this.importContext.getFileUrl() == null || "".equals(this.importContext.getFileUrl())) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.path.empty"));
            return -2001;
        }
        this.errorCode = 0;
        DataSet dataSet = CommUtil.getDatasetImportResponse();
        dataSet.set(0, "filepath", this.importContext.getFileUrl());
        this.importContext.getPlatformData().getDataSetList().add(dataSet);
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            pOIFSFileSystem = this.poiFs;
            for (int i = 0; i < this.importContext.getImportFormat().getSheetCount(); ++i) {
                ImportSheet importSheet = this.importContext.getImportFormat().getSheet(i);
                if (importSheet == null) continue;
                DataSet dataSet2 = null;
                dataSet2 = "getsheetlist".equals(importSheet.getCommand()) ? this.getSheetList(importSheet, pOIFSFileSystem) : this.getSheetData(importSheet, pOIFSFileSystem);
                if (dataSet2 == null) continue;
                this.importContext.getPlatformData().getDataSetList().add(dataSet2);
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            this.errorCode = -2019;
            this.setErrorMessage(invalidFormatException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            this.errorCode = -2018;
            this.setErrorMessage(malformedURLException.getMessage());
        }
        catch (PlatformException platformException) {
            this.errorCode = -3101;
            this.setErrorMessage(platformException.getMessage());
        }
        catch (IOException iOException) {
            this.errorCode = -2003;
            this.setErrorMessage(iOException.getMessage());
        }
        catch (Exception exception) {
            this.errorCode = -2001;
            this.setErrorMessage(exception.getMessage());
        }
        finally {
            if (pOIFSFileSystem != null) {
                try {
                    pOIFSFileSystem.close();
                }
                catch (IOException iOException) {
                    this.errorCode = -2003;
                    this.setErrorMessage(iOException.getMessage());
                }
            }
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
        return this.errorCode;
    }

    private DataSet getSheetList(ImportSheet importSheet, POIFSFileSystem pOIFSFileSystem) throws Exception {
        String string;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get sheet list.");
        }
        if ((string = importSheet.getOutput()) == null || "".equals(string)) {
            string = "SHEETS";
        }
        DataSet dataSet = new DataSet(string);
        dataSet.addColumn("number", 3);
        dataSet.addColumn("sheetname", 2);
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords((HSSFListener)new HSSFEventModelHandlerHead(dataSet, "", HSSFEventModelHandlerHead.commandType.SHEETLIST, new ExcelDimensionInfo(), this.importContext));
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
        hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
        if (documentInputStream != null) {
            documentInputStream.close();
        }
        return dataSet;
    }

    private DataSet getSheetData(ImportSheet importSheet, POIFSFileSystem pOIFSFileSystem) throws Exception {
        String string;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get sheet data.");
        }
        if ((string = importSheet.getOutput()) == null || "".equals(string)) {
            string = "SHEETDATA";
        }
        DataSet dataSet = new DataSet(string);
        int[] nArray = new int[]{-1, -1};
        int[] nArray2 = new int[]{-1, -1};
        String string2 = null;
        String string3 = importSheet.getHead();
        if (string3 != null && string3.length() > 0) {
            string2 = CommUtil.getDataRange(string3, nArray, nArray2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Import head range : " + StringUtils.normalizeSpace((String)string3)));
        }
        ExcelDimensionInfo excelDimensionInfo = new ExcelDimensionInfo();
        excelDimensionInfo.setUserStartColumn(nArray[0]);
        excelDimensionInfo.setUserStartRow(nArray[1]);
        excelDimensionInfo.setUserEndColumn(nArray2[0]);
        excelDimensionInfo.setUserEndRow(nArray2[1]);
        HSSFEventModelHandlerHead hSSFEventModelHandlerHead = new HSSFEventModelHandlerHead(dataSet, string2, HSSFEventModelHandlerHead.commandType.HEAD, excelDimensionInfo, this.importContext);
        hSSFEventModelHandlerHead.excute(pOIFSFileSystem);
        if (!hSSFEventModelHandlerHead.isFoundSheet()) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.sheet.notfound", string2));
            throw new IOException(this.errorMsg);
        }
        int[] nArray3 = new int[]{-1, -1};
        int[] nArray4 = new int[]{-1, -1};
        string3 = importSheet.getBody();
        if (string3 != null && string3.length() > 0) {
            string2 = CommUtil.getDataRange(string3, nArray3, nArray4);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Import body range : " + StringUtils.normalizeSpace((String)string3)));
        }
        excelDimensionInfo.setUserStartColumn(nArray3[0]);
        excelDimensionInfo.setUserStartRow(nArray3[1]);
        excelDimensionInfo.setUserEndColumn(nArray4[0]);
        excelDimensionInfo.setUserEndRow(nArray4[1]);
        HSSFEventModelHandlerBody hSSFEventModelHandlerBody = new HSSFEventModelHandlerBody(dataSet, string2, excelDimensionInfo, this.importContext);
        hSSFEventModelHandlerBody.excute(pOIFSFileSystem);
        if (!hSSFEventModelHandlerBody.isFoundSheet()) {
            this.setErrorMessage("Unable to process: Not found '" + string2 + "' sheet.");
            throw new IOException(this.errorMsg);
        }
        return dataSet;
    }
}

