/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.importformats.ImportSheet;
import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.java.xeni.extend.XeniStylesTable;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import com.nexacro.java.xeni.ximport.impl.XSSFEventModelHandlerBody;
import com.nexacro.java.xeni.ximport.impl.XSSFEventModelHandlerHead;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class GridImportExcelXSSFEvent
implements GridImportBase {
    private static final Log logger = LogFactory.getLog(GridImportExcelXSSFEvent.class);
    private int errorCode = 0;
    private int partIndex;
    private String errorMsg = "SUCCESS";
    private boolean bHancell = false;
    private OPCPackage opcPackage = null;
    private GridImportContext importContext = null;

    @Override
    public void setOPCPackage(OPCPackage oPCPackage) {
        this.opcPackage = oPCPackage;
    }

    @Override
    public void setPOIFileSystem(POIFSFileSystem pOIFSFileSystem) {
    }

    @Override
    public void setInputStream(InputStream inputStream) {
    }

    @Override
    public void setPartIndex(int n) {
        this.partIndex = n;
    }

    @Override
    public int getPartIndex() {
        return this.partIndex;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMsg = string;
        logger.error((Object)StringUtils.normalizeSpace((String)string));
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    @Override
    public void initialize(GridImportContext gridImportContext) {
        this.importContext = gridImportContext;
        if (gridImportContext.getImportType() == 1040 || gridImportContext.getImportType() == 1056) {
            this.bHancell = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startImport() {
        if (this.importContext.getFileUrl() == null || "".equals(this.importContext.getFileUrl())) {
            this.setErrorMessage("Import file path is empty...");
            return -2001;
        }
        this.errorCode = 0;
        DataSet dataSet = CommUtil.getDatasetImportResponse();
        dataSet.set(0, "filepath", this.importContext.getFileUrl());
        this.importContext.getPlatformData().getDataSetList().add(dataSet);
        try {
            if (this.importContext.isPartData() && (this.errorCode = this.sendDataHead()) < 0) {
                int n = this.errorCode;
                return n;
            }
            XSSFReader xSSFReader = new XSSFReader(this.opcPackage);
            for (int i = 0; i < this.importContext.getImportFormat().getSheetCount(); ++i) {
                ImportSheet importSheet = this.importContext.getImportFormat().getSheet(i);
                if (importSheet == null) continue;
                DataSet dataSet2 = null;
                if ("getsheetlist".equals(importSheet.getCommand())) {
                    dataSet2 = this.getSheetList(xSSFReader, importSheet);
                    if (this.importContext.isPartData()) {
                        this.sendDataFirst(dataSet);
                        this.writePartDataset(dataSet2);
                    }
                } else {
                    dataSet2 = this.getSheetData(xSSFReader, importSheet, this.opcPackage, dataSet);
                }
                if (dataSet2 == null || this.importContext.isPartData()) continue;
                this.importContext.getPlatformData().getDataSetList().add(dataSet2);
            }
            if (this.importContext.isPartData()) {
                this.sendDataTail();
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            this.errorCode = -2019;
            this.setErrorMessage(invalidFormatException.getMessage());
        }
        catch (OpenXML4JException openXML4JException) {
            this.errorCode = -2001;
            this.setErrorMessage(openXML4JException.getMessage());
        }
        catch (SAXException sAXException) {
            this.errorCode = -2001;
            this.setErrorMessage(sAXException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            this.errorCode = -2018;
            this.setErrorMessage(malformedURLException.getMessage());
        }
        catch (PlatformException platformException) {
            this.errorCode = -3101;
            this.setErrorMessage(platformException.getMessage());
        }
        catch (IOException iOException) {
            this.errorCode = -2003;
            this.setErrorMessage(iOException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.errorCode = -2021;
            this.setErrorMessage(generalSecurityException.getMessage());
        }
        catch (Exception exception) {
            this.errorCode = -2001;
            this.setErrorMessage(exception.getMessage());
        }
        finally {
            try {
                if (this.opcPackage != null) {
                    this.opcPackage.close();
                }
            }
            catch (IOException iOException) {
                this.errorCode = -2003;
                this.setErrorMessage(iOException.getMessage());
            }
        }
        return this.errorCode;
    }

    private DataSet getSheetList(XSSFReader xSSFReader, ImportSheet importSheet) throws Exception {
        String string;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get sheet list.");
        }
        if ((string = importSheet.getOutput()) == null || "".equals(string)) {
            string = "SHEETS";
        }
        DataSet dataSet = new DataSet(string);
        dataSet.addColumn("number", 3);
        dataSet.addColumn("sheetname", 2);
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            InputStream inputStream = sheetIterator.next();
            int n = dataSet.newRow();
            dataSet.set(n, "number", n + 1);
            dataSet.set(n, "sheetname", sheetIterator.getSheetName());
            inputStream.close();
        }
        return dataSet;
    }

    private DataSet getSheetData(XSSFReader xSSFReader, ImportSheet importSheet, OPCPackage oPCPackage, DataSet dataSet) throws OpenXML4JException, SAXException, Exception {
        DataSet dataSet2;
        block12: {
            ExcelDimensionInfo excelDimensionInfo;
            InputSource inputSource;
            XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable;
            XMLReader xMLReader;
            DefaultHandler defaultHandler;
            StylesTable stylesTable;
            XeniStylesTable xeniStylesTable;
            block11: {
                block10: {
                    String string;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Get sheet data.");
                    }
                    if ((string = importSheet.getOutput()) == null || "".equals(string)) {
                        string = "SHEETDATA";
                    }
                    dataSet2 = new DataSet(string);
                    xeniStylesTable = new XeniStylesTable();
                    try {
                        xeniStylesTable.readFrom(oPCPackage);
                    }
                    catch (SAXException sAXException) {
                        if (sAXException.getException() instanceof POIEventModelException) break block10;
                        throw sAXException;
                    }
                }
                this.bHancell = xeniStylesTable.isHancellStyle();
                stylesTable = null;
                if (!this.bHancell) {
                    stylesTable = xSSFReader.getStylesTable();
                }
                defaultHandler = null;
                xMLReader = this.createXMLReader();
                xeniReadOnlySharedStringsTable = new XeniReadOnlySharedStringsTable(this.opcPackage);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Import head range : " + StringUtils.normalizeSpace((String)importSheet.getHead())));
                    logger.debug((Object)("Import body range : " + StringUtils.normalizeSpace((String)importSheet.getBody())));
                }
                int[] nArray = new int[]{-1, -1};
                int[] nArray2 = new int[]{-1, -1};
                inputSource = this.getSheetSource(xSSFReader, importSheet.getHead(), nArray, nArray2);
                excelDimensionInfo = new ExcelDimensionInfo();
                excelDimensionInfo.setUserStartColumn(nArray[0]);
                excelDimensionInfo.setUserStartRow(nArray[1]);
                excelDimensionInfo.setUserEndColumn(nArray2[0]);
                excelDimensionInfo.setUserEndRow(nArray2[1]);
                defaultHandler = new XSSFEventModelHandlerHead(dataSet2, excelDimensionInfo, stylesTable, xeniStylesTable, xeniReadOnlySharedStringsTable, false, this.bHancell, this.importContext);
                try {
                    xMLReader.setContentHandler(defaultHandler);
                    xMLReader.parse(inputSource);
                }
                catch (SAXException sAXException) {
                    if (sAXException.getException() instanceof POIEventModelException) break block11;
                    throw sAXException;
                }
            }
            int[] nArray = new int[]{-1, -1};
            int[] nArray3 = new int[]{-1, -1};
            inputSource = this.getSheetSource(xSSFReader, importSheet.getBody(), nArray, nArray3);
            excelDimensionInfo.setUserStartColumn(nArray[0]);
            excelDimensionInfo.setUserStartRow(nArray[1]);
            excelDimensionInfo.setUserEndColumn(nArray3[0]);
            excelDimensionInfo.setUserEndRow(nArray3[1]);
            defaultHandler = new XSSFEventModelHandlerBody(dataSet2, excelDimensionInfo, stylesTable, xeniStylesTable, xeniReadOnlySharedStringsTable, false, this.bHancell, this.importContext, dataSet);
            try {
                xMLReader.setContentHandler(defaultHandler);
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                if (sAXException.getException() instanceof POIEventModelException) break block12;
                throw sAXException;
            }
        }
        return dataSet2;
    }

    public InputSource getSheetSource(XSSFReader xSSFReader, String string, int[] nArray, int[] nArray2) throws OpenXML4JException, SAXException, InvalidFormatException, IOException {
        InputStream inputStream = null;
        if (string != null && string.length() > 0) {
            String string2 = CommUtil.getDataRange(string, nArray, nArray2);
            if (string2 == null || "".equals(string2)) {
                inputStream = this.getSheetStream(xSSFReader, null);
            } else {
                inputStream = this.getSheetStream(xSSFReader, string2);
                if (inputStream == null) {
                    this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.sheet.notfound", string2));
                    throw new IOException(this.errorMsg);
                }
            }
        } else {
            inputStream = this.getSheetStream(xSSFReader, null);
        }
        return new InputSource(inputStream);
    }

    private InputStream getSheetStream(XSSFReader xSSFReader, String string) throws InvalidFormatException, IOException {
        InputStream inputStream = null;
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            if (string == null) {
                inputStream = sheetIterator.next();
                break;
            }
            inputStream = sheetIterator.next();
            if (string.equalsIgnoreCase(sheetIterator.getSheetName())) break;
            inputStream.close();
            inputStream = null;
        }
        return inputStream;
    }

    private XMLReader createXMLReader() throws SAXException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return xMLReader;
    }

    private int sendDataHead() throws PlatformException, IOException {
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("");
        if (this.importContext.getServletProvider().getHttpServletResponse() == null) {
            this.setErrorMessage("Response is null.");
            return -2001;
        }
        this.importContext.setPartIndex(0);
        this.importContext.setPartIndex(1);
        StringWriter stringWriter = new StringWriter();
        CommUtil.writePartDataHead(stringWriter, this.importContext);
        xeniEncoder.encodeTo(this.importContext.getResponseWriter(), stringWriter.toString());
        this.importContext.setPartIndex(2);
        return 0;
    }

    private int sendDataFirst(DataSet dataSet) throws PlatformException, IOException {
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("");
        if (this.importContext.isPartData()) {
            if (this.importContext.getServletProvider().getHttpServletResponse() == null) {
                this.setErrorMessage("Response is null.");
                return -2001;
            }
            VariableList variableList = new VariableList();
            variableList.add("ErrorCode", 0);
            variableList.add("ErrorMsg", "SUCCESS");
            StringWriter stringWriter = new StringWriter();
            CommUtil.writePartDataVariableList(stringWriter, this.importContext, variableList);
            xeniEncoder.encodeTo(this.importContext.getResponseWriter(), stringWriter.toString());
            stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
            this.importContext.setPartIndex(3);
            dataSet.set(0, "importid", this.importContext.getImportId());
            this.writePartDataset(dataSet);
            this.importContext.setPartIndex(4);
        }
        return 0;
    }

    private void sendDataTail() throws IOException, PlatformException {
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("");
        StringWriter stringWriter = new StringWriter();
        CommUtil.writePartDataTail(stringWriter, this.importContext);
        xeniEncoder.encodeTo(this.importContext.getResponseWriter(), stringWriter.toString());
        this.importContext.getResponseWriter().flush();
        stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
        this.importContext.setPartIndex(6);
    }

    private void writePartDataset(DataSet dataSet) throws IOException, PlatformException {
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("");
        StringWriter stringWriter = new StringWriter();
        CommUtil.writePartDataDataset(stringWriter, this.importContext, dataSet);
        xeniEncoder.encodeTo(this.importContext.getResponseWriter(), stringWriter.toString());
        this.importContext.getResponseWriter().flush();
        stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
    }
}

