/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.java.xeni.extend.XeniStylesTable;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFEventModelHandlerHead
extends DefaultHandler {
    private static final Log logger = LogFactory.getLog(XSSFEventModelHandlerHead.class);
    private StylesTable stylesTable;
    private XeniStylesTable xeniStylesTable;
    private XeniReadOnlySharedStringsTable sharedStringsTable;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final XeniDataFormatter formatter;
    private boolean formulasNotResults;
    private int[] currCellRef = new int[]{-1, -1};
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private ExcelDimensionInfo dimInfo;
    private int nCurrDsCol = 0;
    private int nPreColIndex = 0;
    private int nLastColIndex = 0;
    private boolean isHancell = false;
    private boolean isUserDimension = false;
    private DataSet dsResult = null;
    private GridImportContext importContext;

    public XSSFEventModelHandlerHead(DataSet dataSet, ExcelDimensionInfo excelDimensionInfo, StylesTable stylesTable, XeniStylesTable xeniStylesTable, XeniReadOnlySharedStringsTable xeniReadOnlySharedStringsTable, boolean bl, boolean bl2, GridImportContext gridImportContext) {
        this.dsResult = dataSet;
        this.dimInfo = excelDimensionInfo;
        this.stylesTable = stylesTable;
        this.xeniStylesTable = xeniStylesTable;
        this.sharedStringsTable = xeniReadOnlySharedStringsTable;
        this.formulasNotResults = bl;
        this.formatter = new XeniDataFormatter();
        this.nextDataType = xssfDataType.NUMBER;
        this.isHancell = bl2;
        this.importContext = gridImportContext;
        this.isUserDimension = excelDimensionInfo.isUserDimension();
    }

    private boolean isTextTag(String string) {
        if ("v".equals(string)) {
            return true;
        }
        if ("inlineStr".equals(string)) {
            return true;
        }
        return "t".equals(string) && this.isIsOpen;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!"dimension".equals(string2)) {
            if (this.isTextTag(string2)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("is".equals(string2)) {
                this.isIsOpen = true;
            } else if ("f".equals(string2)) {
                this.formula.setLength(0);
                this.setStartFormula(attributes);
            } else if ("oddHeader".equals(string2) || "evenHeader".equals(string2) || "firstHeader".equals(string2) || "firstFooter".equals(string2) || "oddFooter".equals(string2) || "evenFooter".equals(string2)) {
                this.hfIsOpen = true;
                this.headerFooter.setLength(0);
            } else if ("row".equals(string2)) {
                int n = Integer.parseInt(attributes.getValue("r")) - 1;
                this.setStartRowIndex(n);
            } else if ("c".equals(string2)) {
                this.setStartCellValue(attributes);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object var4_4 = null;
        if (this.isTextTag(string2)) {
            this.vIsOpen = false;
            if (this.isUserDimension && this.isValidDimension()) {
                this.setCellValue(this.getCellValue());
            }
        } else if ("f".equals(string2)) {
            this.fIsOpen = false;
        } else if ("is".equals(string2)) {
            this.isIsOpen = false;
        } else if ("row".equals(string2)) {
            this.setEndRow();
        } else if ("oddHeader".equals(string2) || "evenHeader".equals(string2) || "firstHeader".equals(string2)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), true, string2);
        } else if ("oddFooter".equals(string2) || "evenFooter".equals(string2) || "firstFooter".equals(string2)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), false, string2);
        } else if ("c".equals(string2)) {
            this.value.setLength(0);
        } else if ("sheetData".equals(string2)) {
            if (!this.isUserDimension) {
                this.addColumn();
            } else {
                this.addEmptyColumn();
            }
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(cArray, n, n2);
        }
        if (this.fIsOpen) {
            this.formula.append(cArray, n, n2);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(cArray, n, n2);
        }
    }

    private void setDimension(String string) {
    }

    private void setStartFormula(Attributes attributes) {
        String string;
        if (this.nextDataType == xssfDataType.NUMBER) {
            this.nextDataType = xssfDataType.FORMULA;
        }
        if ((string = attributes.getValue("t")) != null && "shared".equals(string)) {
            String string2 = attributes.getValue("ref");
            String string3 = attributes.getValue("si");
            if (string2 != null) {
                this.fIsOpen = true;
            } else if (this.formulasNotResults && logger.isErrorEnabled()) {
                logger.error((Object)"Warning - shared formulas not yet supported!");
            }
        } else {
            this.fIsOpen = true;
        }
    }

    private void setStartRowIndex(int n) {
        this.nPreColIndex = 0;
        if (this.dimInfo.getStartRow() < 0) {
            this.dimInfo.setStartRow(n);
        }
        this.dimInfo.setEndRow(n);
    }

    private void setEndRow() {
    }

    private void setStartCellValue(Attributes attributes) {
        CommUtil.getRangeIndex(attributes.getValue("r"), this.currCellRef);
        if (this.dimInfo.getStartColumn() < 0) {
            this.dimInfo.setStartColumn(this.currCellRef[0]);
        } else if (this.dimInfo.getStartColumn() > this.currCellRef[0]) {
            this.dimInfo.setStartColumn(this.currCellRef[0]);
        }
        if (this.dimInfo.getEndColumn() < 0) {
            this.dimInfo.setEndColumn(this.currCellRef[0]);
        } else if (this.dimInfo.getEndColumn() < this.currCellRef[0]) {
            this.dimInfo.setEndColumn(this.currCellRef[0]);
        }
        this.nextDataType = xssfDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String string = attributes.getValue("t");
        String string2 = attributes.getValue("s");
        if ("b".equals(string)) {
            this.nextDataType = xssfDataType.BOOLEAN;
        } else if ("e".equals(string)) {
            this.nextDataType = xssfDataType.ERROR;
        } else if ("inlineStr".equals(string)) {
            this.nextDataType = xssfDataType.INLINE_STRING;
        } else if ("s".equals(string)) {
            this.nextDataType = xssfDataType.SST_STRING;
        } else if ("str".equals(string)) {
            this.nextDataType = xssfDataType.FORMULA;
        } else if (string2 != null) {
            int n = Integer.parseInt(string2);
            if (!this.isHancell) {
                XSSFCellStyle xSSFCellStyle = this.stylesTable.getStyleAt(n);
                if (xSSFCellStyle != null) {
                    this.formatIndex = xSSFCellStyle.getDataFormat();
                    this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : xSSFCellStyle.getDataFormatString();
                }
            } else {
                this.formatIndex = this.xeniStylesTable.getDataFormat(n);
                this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : this.xeniStylesTable.getDataFormatString(this.formatIndex);
            }
            if (this.formatString == null) {
                this.formatString = XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null);
            }
        }
    }

    private String getCellValue() {
        String string = null;
        switch (this.nextDataType) {
            case BOOLEAN: {
                char c = this.value.charAt(0);
                string = c == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                string = "ERROR:" + this.value.toString();
            }
            case FORMULA: {
                if (this.formulasNotResults) {
                    string = this.formula.toString();
                    break;
                }
                string = this.value.toString();
                if (this.importContext.isRawNumberValue() && this.importContext.getCompatibleMode() <= 0) break;
                try {
                    double d = Double.parseDouble(string);
                    string = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                    string = string.replaceAll("[\"*? ]", "");
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(numberFormatException.getMessage());
                }
                break;
            }
            case INLINE_STRING: {
                if (!this.isHancell) {
                    XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.value.toString());
                    string = xSSFRichTextString.toString();
                    break;
                }
                string = this.value.toString();
                break;
            }
            case SST_STRING: {
                String string2 = this.value.toString();
                try {
                    int n = Integer.parseInt(string2);
                    if (!this.isHancell) {
                        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(n));
                        string = xSSFRichTextString.toString();
                        break;
                    }
                    string = this.sharedStringsTable.getEntryAt(n);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isErrorEnabled()) break;
                    logger.error((Object)("Failed to parse SST index '" + StringUtils.normalizeSpace((String)string2) + "': " + StringUtils.normalizeSpace((String)numberFormatException.toString())));
                }
                break;
            }
            case NUMBER: {
                double d = Double.parseDouble(this.value.toString());
                string = this.formatter.formatRawCellContents(d, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                string = string.replaceAll("[\"*? ]", "");
                break;
            }
            default: {
                string = "(Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
            }
        }
        return string;
    }

    private void setCellValue(String string) throws SAXException {
        if (string != null && this.importContext.getCorsResponseType() == 1) {
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\"", "\\\\\"");
            string = string.replaceAll("\\\\", "\\\\\\\\");
        }
        int n = this.currCellRef[0] - this.nPreColIndex;
        if (this.nCurrDsCol == 0 && n > 0) {
            int n2 = this.dimInfo.getUserStartColumn() >= 0 ? this.dimInfo.getUserStartColumn() : this.dimInfo.getStartColumn();
            int n3 = this.currCellRef[0];
            for (int i = this.nPreColIndex; i < this.currCellRef[0]; ++i) {
                if (i < n2 || i > n3) continue;
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        } else if (this.nCurrDsCol != 0 && n > 1) {
            for (int i = 1; i < n; ++i) {
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        }
        this.nLastColIndex = this.nPreColIndex = this.currCellRef[0];
        if (string == null || "".equals(string)) {
            this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
        } else {
            this.dsResult.addColumn(string, 2, 256);
        }
        ++this.nCurrDsCol;
    }

    private boolean isValidDimension() {
        if (this.dimInfo.getEndRow() < 0 || this.dimInfo.getUserStartRow() >= 0 && this.dimInfo.getUserStartRow() > this.dimInfo.getEndRow()) {
            return false;
        }
        if (this.dimInfo.getUserEndRow() >= 0 && this.dimInfo.getUserEndRow() < this.dimInfo.getEndRow()) {
            return false;
        }
        if (this.dimInfo.getUserStartColumn() >= 0 && this.dimInfo.getUserStartColumn() > this.currCellRef[0]) {
            return false;
        }
        return this.dimInfo.getUserEndColumn() < 0 || this.dimInfo.getUserEndColumn() >= this.currCellRef[0];
    }

    private void setHeaderFooter(String string, boolean bl, String string2) {
    }

    private void addColumn() {
        for (int i = 0; i <= this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn(); ++i) {
            this.dsResult.addColumn("Column" + i, 2, 256);
        }
    }

    private void addEmptyColumn() {
        int n = this.currCellRef[0] - this.nLastColIndex;
        if (this.nCurrDsCol != 0 && n > 0) {
            int n2 = this.dimInfo.getUserStartColumn() >= 0 ? this.dimInfo.getUserStartColumn() : this.dimInfo.getStartColumn();
            int n3 = this.dimInfo.getUserEndColumn() >= 0 ? this.dimInfo.getUserEndColumn() : this.dimInfo.getEndColumn();
            for (int i = this.nLastColIndex + 1; i <= this.nLastColIndex + n; ++i) {
                if (n2 > i || i > n3) continue;
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        }
    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

