/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.services;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.services.ExportImportConfiguration;
import com.nexacro.java.xeni.services.ExportImportFileManager;
import com.nexacro.java.xeni.services.GridExportImportAgent;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridExportImportServlet
extends HttpServlet {
    private static final long serialVersionUID = -8877137699076711995L;
    private static final Log logger = LogFactory.getLog(GridExportImportServlet.class);
    private static final ExportImportConfiguration configuration = new ExportImportConfiguration();

    public void init() throws ServletException {
        super.init();
        this.setConfiguration();
    }

    public void destroy() {
        Timer timer;
        ExportImportFileManager exportImportFileManager = ExportImportFileManager.getInstance();
        if (exportImportFileManager != null && (timer = exportImportFileManager.getTimer()) != null) {
            timer.cancel();
        }
        super.destroy();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.setExportImportPath(httpServletRequest);
            GridExportImportAgent gridExportImportAgent = new GridExportImportAgent();
            ServletProvider servletProvider = new ServletProvider(httpServletRequest, httpServletResponse);
            int n = gridExportImportAgent.sendExportFileStream(servletProvider, configuration.getExportPath());
            if (n < 0) {
                this.sendErrorMessage(httpServletResponse, n, gridExportImportAgent.getErrorMessage());
            }
        }
        catch (Exception exception) {
            this.sendErrorMessage(httpServletResponse, -2001, exception + "");
            System.out.println(exception.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
        catch (PlatformException platformException) {
            this.sendErrorMessage(httpServletResponse, -3101, "Platform Error ( " + platformException.getMessage() + " )");
            System.out.println(platformException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.sendErrorMessage(httpServletResponse, -3201, "Illegal Argument ( " + illegalArgumentException.getMessage() + " )");
            System.out.println(illegalArgumentException.getMessage());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.sendErrorMessage(httpServletResponse, -3301, "Index Out Of Bounds ( " + indexOutOfBoundsException.getMessage() + " )");
            System.out.println(indexOutOfBoundsException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            this.sendErrorMessage(httpServletResponse, -3401, "Illegal State ( " + illegalStateException.getMessage() + " )");
            System.out.println(illegalStateException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.sendErrorMessage(httpServletResponse, -2004, nullPointerException + "");
            System.out.println(nullPointerException.getMessage());
        }
        catch (IOException iOException) {
            this.sendErrorMessage(httpServletResponse, -2003, iOException + "");
            System.out.println(iOException.getMessage());
        }
        catch (Exception exception) {
            this.sendErrorMessage(httpServletResponse, -2001, exception + "");
            System.out.println(exception.getMessage());
        }
    }

    private void sendErrorMessage(HttpServletResponse httpServletResponse, int n, String string) {
        block3: {
            PlatformData platformData = new PlatformData();
            VariableList variableList = platformData.getVariableList();
            variableList.add("ErrorCode", n);
            variableList.add("ErrorMsg", string);
            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(httpServletResponse, "PlatformSsv", "UTF-8");
            httpPlatformResponse.setData(platformData);
            if (logger.isInfoEnabled()) {
                logger.info((Object)StringUtils.normalizeSpace((String)string));
            }
            try {
                httpPlatformResponse.sendData();
            }
            catch (PlatformException platformException) {
                if (!logger.isInfoEnabled()) break block3;
                logger.info((Object)StringUtils.normalizeSpace((String)platformException.getMessage()));
            }
        }
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = 0;
        long l = System.currentTimeMillis();
        this.setExportImportPath(httpServletRequest);
        if (configuration.isFileManage()) {
            this.executeTimerSchedule(configuration);
        }
        String string = null;
        GridExportImportAgent gridExportImportAgent = new GridExportImportAgent();
        ServletProvider servletProvider = new ServletProvider(httpServletRequest, httpServletResponse);
        boolean bl = ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest);
        if (bl) {
            string = "import";
            n = gridExportImportAgent.gridImport(servletProvider, configuration);
        } else {
            string = "export";
            n = gridExportImportAgent.gridExport(servletProvider, configuration);
        }
        if (n < 0) {
            this.sendErrorMessage(httpServletResponse, n, gridExportImportAgent.getErrorMessage());
        }
        if (logger.isInfoEnabled()) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            logger.info((Object)StringUtils.normalizeSpace((String)(string + " running time.......[ " + l3 + " ]")));
        }
    }

    private void setConfiguration() {
        String[] stringArray;
        int n;
        String string = null;
        ServletContext servletContext = this.getServletContext();
        string = servletContext.getInitParameter("export-path");
        if (string == null || string.equalsIgnoreCase("")) {
            string = "export/";
        } else {
            if (string.startsWith("file://")) {
                string = string.substring(7);
                configuration.setExportAbsPath(true);
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        }
        configuration.setExportParamPath(string);
        string = servletContext.getInitParameter("import-path");
        if (string == null || string.equals("")) {
            string = "import";
        } else if (string.startsWith("file://")) {
            if (!(string = string.substring(7)).endsWith("/")) {
                string = string + "/";
            }
            configuration.setImportAbsPath(true);
        } else {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.lastIndexOf(47));
            }
        }
        configuration.setImportParamPath(string);
        configuration.setExportParamUrl(servletContext.getInitParameter("export-url"));
        string = servletContext.getInitParameter("monitor-enabled");
        if (string != null && "false".equalsIgnoreCase(string)) {
            configuration.setFileManage(false);
        }
        if ((string = servletContext.getInitParameter("monitor-cycle-time")) != null && string.length() > 0) {
            n = string.indexOf(47);
            if (n > 0) {
                stringArray = string.split("/");
                if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("sec")) {
                    configuration.setManagePeriodTime(Integer.parseInt(stringArray[0]));
                } else {
                    configuration.setManagePeriodTime(Integer.parseInt(stringArray[0]) * 60);
                }
            } else {
                configuration.setManagePeriodTime(Integer.parseInt(string) * 60);
            }
        }
        if ((string = servletContext.getInitParameter("file-storage-time")) != null && string.length() > 0) {
            n = string.indexOf(47);
            if (n > 0) {
                stringArray = string.split("/");
                if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("sec")) {
                    configuration.setFileArchiveTime(Integer.parseInt(stringArray[0]));
                } else {
                    configuration.setFileArchiveTime(Integer.parseInt(stringArray[0]) * 60);
                }
            } else {
                configuration.setFileArchiveTime(Integer.parseInt(string) * 60);
            }
        }
        if ((string = servletContext.getInitParameter("numFmt-lang")) != null && string.length() > 0) {
            configuration.setFormatLanguage(string);
        }
        if ((string = servletContext.getInitParameter("csv-quote")) != null && "false".equalsIgnoreCase(string)) {
            configuration.setCsvQuote(false);
        }
        if ((string = servletContext.getInitParameter("csv-bom")) != null && "false".equalsIgnoreCase(string)) {
            configuration.setCsvBom(false);
        }
        if ((string = servletContext.getInitParameter("import-temp-name")) != null && "true".equalsIgnoreCase(string)) {
            configuration.setTempName(true);
        }
    }

    private void setExportImportPath(HttpServletRequest httpServletRequest) throws Exception {
        CharSequence charSequence;
        String string = null;
        if (httpServletRequest.getSession() == null) {
            logger.info((Object)"Request session is null");
        } else if (httpServletRequest.getSession().getServletContext() == null) {
            logger.info((Object)"Servlet context is null");
        } else {
            string = httpServletRequest.getSession().getServletContext().getRealPath("/");
        }
        if (string == null) {
            if (!configuration.isExportAbsPath() || !configuration.isImportAbsPath()) {
                logger.error((Object)"Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
                throw new Exception("Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
            }
        } else if (!(string = string.replaceAll("\\\\", "/")).endsWith("/")) {
            string = string + "/";
        }
        if (configuration.isExportAbsPath()) {
            configuration.setExportPath(configuration.getExportParamPath());
        } else {
            configuration.setExportPath(string + configuration.getExportParamPath());
        }
        if (configuration.isImportAbsPath()) {
            configuration.setImportPath(configuration.getImportParamPath());
        } else {
            configuration.setImportPath(string + configuration.getImportParamPath());
        }
        String string2 = configuration.getExportParamUrl();
        if (string2 == null || "".equals(string2)) {
            charSequence = new StringBuffer();
            String string3 = httpServletRequest.getScheme();
            int n = httpServletRequest.getServerPort();
            if (n < 0) {
                n = 80;
            }
            ((StringBuffer)charSequence).append(string3).append("://");
            ((StringBuffer)charSequence).append(httpServletRequest.getServerName());
            if (string3.equals("http") && n != 80 || string3.equals("https") && n != 443) {
                ((StringBuffer)charSequence).append(':');
                ((StringBuffer)charSequence).append(n);
            }
            if (configuration.isExportAbsPath()) {
                ((StringBuffer)charSequence).append(httpServletRequest.getRequestURI());
            } else {
                ((StringBuffer)charSequence).append(httpServletRequest.getContextPath()).append("/");
            }
            string2 = ((StringBuffer)charSequence).toString();
        }
        if (configuration.isExportAbsPath()) {
            configuration.setExportUrl(string2);
        } else {
            charSequence = string2.substring(0, string2.lastIndexOf("/") + 1);
            configuration.setExportUrl((String)charSequence + configuration.getExportParamPath());
        }
    }

    private ExportImportConfiguration getConfiguration(HttpServletRequest httpServletRequest) throws Exception {
        String[] stringArray;
        ExportImportConfiguration exportImportConfiguration = new ExportImportConfiguration();
        ServletContext servletContext = this.getServletContext();
        String string = servletContext.getInitParameter("export-path");
        if (string == null || string.equalsIgnoreCase("")) {
            string = "export/";
        } else {
            if (string.startsWith("file://")) {
                string = string.substring(7);
                exportImportConfiguration.setExportAbsPath(true);
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        }
        String string2 = servletContext.getInitParameter("import-path");
        if (string2 == null || string2.equals("")) {
            string2 = "import";
        } else if (string2.startsWith("file://")) {
            if (!(string2 = string2.substring(7)).endsWith("/")) {
                string2 = string2 + "/";
            }
            exportImportConfiguration.setImportAbsPath(true);
        } else {
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.lastIndexOf(47));
            }
        }
        String string3 = servletContext.getInitParameter("export-url");
        String string4 = null;
        if (httpServletRequest.getSession() == null) {
            logger.info((Object)"Request session is null");
        } else if (httpServletRequest.getSession().getServletContext() == null) {
            logger.info((Object)"Servlet context is null");
        } else {
            string4 = httpServletRequest.getSession().getServletContext().getRealPath("/");
        }
        if (string4 == null) {
            if (!exportImportConfiguration.isExportAbsPath() || !exportImportConfiguration.isImportAbsPath()) {
                logger.error((Object)"Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
                throw new Exception("Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
            }
        } else if (!(string4 = string4.replaceAll("\\\\", "/")).endsWith("/")) {
            string4 = string4 + "/";
        }
        if (exportImportConfiguration.isExportAbsPath()) {
            exportImportConfiguration.setExportPath(string);
        } else {
            exportImportConfiguration.setExportPath(string4 + string);
        }
        if (exportImportConfiguration.isImportAbsPath()) {
            exportImportConfiguration.setImportPath(string2);
        } else {
            exportImportConfiguration.setImportPath(string4 + string2);
        }
        String string5 = null;
        string5 = string3 != null && !"".equals(string3) ? string3 : httpServletRequest.getRequestURL().toString();
        if (exportImportConfiguration.isExportAbsPath()) {
            exportImportConfiguration.setExportUrl(string5);
        } else {
            stringArray = string5.substring(0, string5.lastIndexOf("/") + 1);
            exportImportConfiguration.setExportUrl((String)stringArray + string);
        }
        string4 = servletContext.getInitParameter("monitor-enabled");
        if (string4 != null && "false".equalsIgnoreCase(string4)) {
            exportImportConfiguration.setFileManage(false);
        }
        if ((string4 = servletContext.getInitParameter("monitor-cycle-time")) != null && string4.length() > 0) {
            int n = string4.indexOf(47);
            if (n > 0) {
                stringArray = string4.split("/");
                if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("sec")) {
                    exportImportConfiguration.setManagePeriodTime(Integer.parseInt(stringArray[0]));
                } else {
                    exportImportConfiguration.setManagePeriodTime(Integer.parseInt(stringArray[0]) * 60);
                }
            } else {
                exportImportConfiguration.setManagePeriodTime(Integer.parseInt(string4) * 60);
            }
        }
        if ((string4 = servletContext.getInitParameter("file-storage-time")) != null && string4.length() > 0) {
            int n = string4.indexOf(47);
            if (n > 0) {
                stringArray = string4.split("/");
                if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("sec")) {
                    exportImportConfiguration.setFileArchiveTime(Integer.parseInt(stringArray[0]));
                } else {
                    exportImportConfiguration.setFileArchiveTime(Integer.parseInt(stringArray[0]) * 60);
                }
            } else {
                exportImportConfiguration.setFileArchiveTime(Integer.parseInt(string4) * 60);
            }
        }
        if ((string4 = servletContext.getInitParameter("numFmt-lang")) != null && string4.length() > 0) {
            exportImportConfiguration.setFormatLanguage(string4);
        }
        if ((string4 = servletContext.getInitParameter("csv-quote")) != null && "false".equalsIgnoreCase(string4)) {
            exportImportConfiguration.setCsvQuote(false);
        }
        if ((string4 = servletContext.getInitParameter("csv-bom")) != null && "false".equalsIgnoreCase(string4)) {
            exportImportConfiguration.setCsvBom(false);
        }
        if ((string4 = servletContext.getInitParameter("import-temp-name")) != null && "true".equalsIgnoreCase(string4)) {
            exportImportConfiguration.setTempName(true);
        }
        return exportImportConfiguration;
    }

    private void executeTimerSchedule(ExportImportConfiguration exportImportConfiguration) {
        ExportImportFileManager exportImportFileManager = ExportImportFileManager.getInstance();
        Timer timer = exportImportFileManager.getTimer();
        if (timer == null) {
            timer = exportImportFileManager.newTimerInstance();
            exportImportFileManager.setServiceDir(exportImportConfiguration.getExportPath(), exportImportConfiguration.getImportPath(), exportImportConfiguration.isFileManage());
            exportImportFileManager.setStorageTime(exportImportConfiguration.getFileArchiveTime());
            timer.scheduleAtFixedRate((TimerTask)exportImportFileManager, exportImportConfiguration.getManagePeriodTime() * 1000, (long)(exportImportConfiguration.getManagePeriodTime() * 1000));
        }
    }
}

