/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PartDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformSsvPartDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformXmlPartDataSerializer;
import com.nexacro.java.xeni.data.importformats.ImportFormat;
import com.nexacro.java.xeni.provider.ServletProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class GridImportContext {
    private PartDataSerializer serializer = null;
    private ServletProvider svltProvider = null;
    private Writer responseWriter;
    private PlatformData platformdata;
    private ImportFormat format;
    private String importId;
    private String userDomain;
    private String responseContentType;
    private String filePath;
    private String fileUrl;
    private String password;
    private String quoteChar;
    private char separator = (char)44;
    private int corsResponseType = 0;
    private int partSize = 100;
    private int partIndex = -1;
    private int importType;
    private int compatibleMode = 0;
    private float commandVersion = 1.0f;
    private boolean htmlTag = true;
    private boolean sentData;
    private boolean partData;
    private boolean serverMode;
    private boolean rawDate = false;
    private boolean rawNumber = true;
    private boolean monitor;
    private boolean csvQuote = true;

    public void setPartSize(int n) {
        this.partSize = n;
    }

    public int getPartSize() {
        return this.partSize;
    }

    public void setPartIndex(int n) {
        this.partIndex = n;
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public boolean isPartData() {
        return this.partData;
    }

    public void setPartData(boolean bl) {
        this.partData = bl;
    }

    public boolean isSentData() {
        return this.sentData;
    }

    public void setSentData(boolean bl) {
        this.sentData = bl;
    }

    public ServletProvider getServletProvider() {
        return this.svltProvider;
    }

    public void setServletProvider(ServletProvider servletProvider) {
        this.svltProvider = servletProvider;
    }

    public Writer getResponseWriter() throws IOException {
        if (this.responseWriter == null) {
            this.svltProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
            this.responseWriter = new OutputStreamWriter((OutputStream)this.svltProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        }
        return this.responseWriter;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String string) {
        this.importId = string;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public void setUserDomain(String string) {
        this.userDomain = string;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String string) {
        this.responseContentType = string;
        if ("ssv".equals(string) || "xml".equals(string)) {
            this.setPartData(true);
        }
    }

    public void initPartDataSerializer() {
        if ("ssv".equals(this.responseContentType)) {
            this.serializer = new PlatformSsvPartDataSerializer();
            this.serializer.setCharset("UTF-8");
        } else if ("xml".equals(this.responseContentType)) {
            this.serializer = new PlatformXmlPartDataSerializer();
            this.serializer.setCharset("UTF-8");
        }
    }

    public void setCsvQuote(boolean bl) {
        this.csvQuote = bl;
    }

    public boolean isCsvQuote() {
        return this.csvQuote;
    }

    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String string) {
        this.quoteChar = string == null || "default".equalsIgnoreCase(string) ? (this.isCsvQuote() ? "\"" : "") : ("none".equalsIgnoreCase(string) ? "" : "" + string.charAt(0));
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        if (this.getImportType() == 1296 && string != null && string.length() > 0) {
            this.separator = (char)Integer.parseInt(string.substring(2), 16);
        }
    }

    public PartDataSerializer getPartDataSerializer() {
        return this.serializer;
    }

    public int getCorsResponseType() {
        return this.corsResponseType;
    }

    public void setCorsResponseType(int n) {
        this.corsResponseType = n;
    }

    public boolean isUseHtmlTag() {
        return this.htmlTag;
    }

    public void setUseHtmlTag(boolean bl) {
        this.htmlTag = bl;
    }

    public void setCompatibleMode(int n) {
        this.compatibleMode = n;
    }

    public int getCompatibleMode() {
        return this.compatibleMode;
    }

    public void setCommandVersion(float f) {
        this.commandVersion = f;
    }

    public float getCommandVersion() {
        return this.commandVersion;
    }

    public void setPlatformData(PlatformData platformData) {
        this.platformdata = platformData;
    }

    public PlatformData getPlatformData() {
        return this.platformdata;
    }

    public void setImportFormat(ImportFormat importFormat) {
        this.format = importFormat;
    }

    public ImportFormat getImportFormat() {
        return this.format;
    }

    public void setImportType(int n) {
        this.importType = n;
    }

    public int getImportType() {
        return this.importType;
    }

    public void setServerMode(boolean bl) {
        this.serverMode = bl;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFileUrl(String string) {
        this.fileUrl = string;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFilePassword(String string) {
        this.password = string;
    }

    public String getFilePassword() {
        return this.password;
    }

    public void setRawDateValue(boolean bl) {
        this.rawDate = bl;
    }

    public boolean isRawDateValue() {
        return this.rawDate;
    }

    public void setRawNumberValue(boolean bl) {
        this.rawNumber = bl;
    }

    public boolean isRawNumberValue() {
        return this.rawNumber;
    }

    public void setFileMonitor(boolean bl) {
        this.monitor = bl;
    }

    public boolean isFileMonitor() {
        return this.monitor;
    }
}

