/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport;

import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.util.PathSanitizer;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.impl.GridImportCSV;
import com.nexacro.java.xeni.ximport.impl.GridImportExcelHSSFEvent;
import com.nexacro.java.xeni.ximport.impl.GridImportExcelXSSFEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.UUID;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportTypeFactory {
    private GridImportTypeFactory() {
    }

    public static GridImportBase getGridImporter(int n) {
        if (n == 256 || n == 272) {
            return new GridImportExcelHSSFEvent();
        }
        if (n == 288) {
            return new GridImportExcelXSSFEvent();
        }
        if (n == 1024 || n == 1040) {
            return new GridImportExcelXSSFEvent();
        }
        if (n == 1280) {
            return new GridImportCSV();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridImportBase getGridImporter(int n, String string, String string2, String string3) throws Exception {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream = null;
        String string4 = string2;
        if (string2.startsWith("http")) {
            int n2 = string2.lastIndexOf(47);
            object3 = string2.substring(0, n2 + 1);
            object2 = string2.substring(n2 + 1);
            object = new URL((String)object3 + URLEncoder.encode((String)object2, "UTF-8").replaceAll("\\+", "%20"));
            inputStream = new BufferedInputStream(((URL)object).openStream());
            string4 = string + "/" + UUID.randomUUID().toString() + "/" + URLEncoder.encode((String)object2, "UTF-8").replaceAll("\\+", "%20");
        } else {
            XeniExcelDataStorageBase xeniExcelDataStorageBase;
            if (string2.startsWith("/")) {
                string4 = string + string2;
            }
            if (!((xeniExcelDataStorageBase = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage")) instanceof XeniExcelDataStorageDef)) {
                string4 = PathSanitizer.getSanitizerPath(string4);
                inputStream = xeniExcelDataStorageBase.loadTargetStream(string4);
                object3 = XeniUtils.getXeniFileHandler(string4).toFile();
                if (!((File)object3).exists() && inputStream != null) {
                    string4 = string + "/" + UUID.randomUUID().toString() + "/importfile";
                }
            }
        }
        if (inputStream != null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, 8);
            }
            string4 = string4 + ".xeni";
            GridImportTypeFactory.saveImportStreamExt(inputStream, string4);
            inputStream.close();
            inputStream = null;
        }
        GridImportBase gridImportBase = null;
        object3 = null;
        try {
            object2 = XeniUtils.getXeniFileHandler(string4).toFile();
            if (FileMagic.valueOf((File)object2) == FileMagic.OLE2) {
                object = new POIFSFileSystem((File)object2);
                if (object.getRoot().hasEntry("EncryptionInfo")) {
                    gridImportBase = new GridImportExcelXSSFEvent();
                    if (string3 == null || string3.length() == 0) {
                        gridImportBase.setErrorCode(-2021);
                        gridImportBase.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.require.password"));
                        object.close();
                        GridImportBase gridImportBase2 = gridImportBase;
                        return gridImportBase2;
                    }
                    EncryptionInfo encryptionInfo = new EncryptionInfo((POIFSFileSystem)object);
                    Decryptor decryptor = Decryptor.getInstance((EncryptionInfo)encryptionInfo);
                    if (!decryptor.verifyPassword(string3)) {
                        gridImportBase.setErrorCode(-2021);
                        gridImportBase.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.doc.encrypted"));
                        GridImportBase gridImportBase3 = gridImportBase;
                        return gridImportBase3;
                    }
                    gridImportBase.setPOIFileSystem((POIFSFileSystem)object);
                    object3 = decryptor.getDataStream((POIFSFileSystem)object);
                    gridImportBase.setInputStream((InputStream)object3);
                    OPCPackage oPCPackage = OPCPackage.open((InputStream)object3);
                    gridImportBase.setOPCPackage(oPCPackage);
                } else {
                    gridImportBase = new GridImportExcelHSSFEvent();
                    if (string3 != null && string3.length() > 0) {
                        Biff8EncryptionKey.setCurrentUserPassword((String)string3);
                    }
                    gridImportBase.setPOIFileSystem((POIFSFileSystem)object);
                }
            } else if (FileMagic.valueOf((File)object2) == FileMagic.OOXML) {
                gridImportBase = new GridImportExcelXSSFEvent();
                object = OPCPackage.open((File)object2);
                gridImportBase.setOPCPackage((OPCPackage)object);
            } else if (n == 1280 || n == 1296) {
                gridImportBase = new GridImportCSV();
                gridImportBase.setInputStream(new FileInputStream((File)object2));
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (gridImportBase != null) {
                gridImportBase.setErrorCode(-2021);
                gridImportBase.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.doc.encrypted"));
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (object3 != null) {
                    ((InputStream)object3).close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        return gridImportBase;
    }

    private static void saveImportStreamExt(InputStream inputStream, String string) throws IOException {
        int n;
        File file;
        if (inputStream == null) {
            return;
        }
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            n2 = string.lastIndexOf(File.separator);
        }
        if (!(file = XeniUtils.getXeniFileHandler(string.substring(0, n2)).toFile()).exists()) {
            file.mkdirs();
        }
        file = XeniUtils.getXeniFileHandler(string).toFile();
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
    }
}

