/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.data.importformats.ImportSheet;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportCSV
implements GridImportBase {
    private static final Log objLogger = LogFactory.getLog(GridImportCSV.class);
    private int errorCode = 0;
    private String errorMsg = "";
    private InputStream inputStream = null;
    private GridImportContext importContext = null;

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void setPartIndex(int n) {
    }

    @Override
    public int getPartIndex() {
        return 0;
    }

    @Override
    public void setOPCPackage(OPCPackage oPCPackage) {
    }

    @Override
    public void setPOIFileSystem(POIFSFileSystem pOIFSFileSystem) {
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMsg = string;
        if (objLogger.isInfoEnabled()) {
            objLogger.info((Object)StringUtils.normalizeSpace((String)string));
        }
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    @Override
    public void initialize(GridImportContext gridImportContext) {
        this.importContext = gridImportContext;
    }

    @Override
    public int startImport() {
        if (objLogger.isDebugEnabled()) {
            objLogger.debug((Object)"Exceute import : CSV");
        }
        if (this.importContext.getFileUrl() == null || "".equals(this.importContext.getFileUrl())) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.path.empty"));
            return -2001;
        }
        this.errorCode = 0;
        DataSet dataSet = CommUtil.getDatasetImportResponse();
        dataSet.set(0, "filepath", this.importContext.getFileUrl());
        this.importContext.getPlatformData().getDataSetList().add(dataSet);
        for (int i = 0; i < this.importContext.getImportFormat().getSheetCount(); ++i) {
            DataSet dataSet2;
            ImportSheet importSheet = this.importContext.getImportFormat().getSheet(i);
            if (importSheet == null || "getsheetlist".equals(importSheet.getCommand()) || (dataSet2 = this.getCsvData(importSheet)) == null) continue;
            this.importContext.getPlatformData().getDataSetList().add(dataSet2);
        }
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getCsvData(ImportSheet importSheet) {
        DataSet dataSet;
        block48: {
            int n = 0;
            String string = importSheet.getOutput();
            if (string == null || "".equals(string)) {
                string = "CSVDATA";
            }
            dataSet = new DataSet(string);
            BufferedReader bufferedReader = null;
            InputStream inputStream = null;
            CSVReader cSVReader = null;
            try {
                int n2;
                String[] stringArray;
                inputStream = this.inputStream;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                cSVReader = new CSVReader(bufferedReader, this.importContext);
                int[] nArray = new int[]{-1, -1};
                int[] nArray2 = new int[]{-1, -1};
                int[] nArray3 = new int[]{-1, -1};
                int[] nArray4 = new int[]{-1, -1};
                boolean bl = this.getUserRange(importSheet, nArray, nArray2, nArray3, nArray4);
                dataSet.setChangeStructureWithData(true);
                if (objLogger.isDebugEnabled()) {
                    objLogger.debug((Object)StringUtils.normalizeSpace((String)("head start column : " + nArray[0] + "\nhead start row : " + nArray[1] + "\nhead end column : " + nArray2[0] + "\nhead end row : " + nArray2[1] + "\nbody start column : " + nArray3[0] + "\nbody start row : " + nArray3[1] + "\nbody end column : " + nArray4[0] + "\nbody end row : " + nArray4[1])));
                }
                if (bl) {
                    while ((stringArray = cSVReader.readNext(n)) != null) {
                        int n3;
                        int n4;
                        if (n == 0) {
                            for (n4 = 0; n4 < stringArray.length; ++n4) {
                                dataSet.addColumn("Column" + n4, 2, 256);
                            }
                        } else {
                            n4 = dataSet.getColumnCount();
                            if (stringArray.length > n4) {
                                for (n3 = n4; n3 < stringArray.length; ++n3) {
                                    dataSet.addColumn("Column" + n3, 2, 256);
                                }
                            }
                        }
                        n4 = dataSet.newRow();
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            dataSet.set(n4, n3, stringArray[n3]);
                        }
                        ++n;
                    }
                    break block48;
                }
                boolean bl2 = false;
                int n5 = nArray[0] < 0 ? 0 : nArray[0];
                int n6 = nArray[1] < 0 ? 0 : nArray[1];
                int n7 = nArray3[0] < 0 ? 0 : nArray3[0];
                int n8 = n2 = nArray3[1] < 0 ? 0 : nArray3[1];
                while ((stringArray = cSVReader.readNext(n)) != null) {
                    int n9;
                    int n10;
                    if (n == 0 && nArray[0] < 0 && nArray[1] < 0 && nArray2[0] < 0 && nArray2[1] < 0) {
                        for (n10 = 0; n10 < stringArray.length; ++n10) {
                            dataSet.addColumn("Column" + n10, 2, 256);
                        }
                        bl2 = true;
                    } else if (!bl2) {
                        int n11 = n10 = nArray2[0] < 0 ? stringArray.length - 1 : nArray2[0];
                        if (n6 <= n) {
                            for (n9 = n5; n9 <= n10; ++n9) {
                                dataSet.addColumn(stringArray[n9], 2, 256);
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        n10 = nArray4[0] < 0 ? stringArray.length - 1 : nArray4[0];
                        int n12 = n9 = nArray4[1] < 0 ? n : nArray4[1];
                        if (n2 <= n && n <= n9) {
                            int n13 = dataSet.newRow();
                            for (int i = n7; i <= n10; ++i) {
                                dataSet.set(n13, i - n7, stringArray[i]);
                            }
                        } else if (n > n9) {
                            break;
                        }
                    }
                    ++n;
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.errorCode = -2018;
                this.setErrorMessage(malformedURLException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errorCode = -2020;
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.no.such.file"));
            }
            catch (IOException iOException) {
                this.errorCode = -2003;
                this.setErrorMessage(iOException.getMessage());
            }
            catch (Exception exception) {
                this.errorCode = -2001;
                this.setErrorMessage(exception + "");
            }
            finally {
                try {
                    if (cSVReader != null) {
                        cSVReader.release();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.errorCode = -2003;
                    this.setErrorMessage(iOException.getMessage());
                }
            }
        }
        return dataSet;
    }

    private boolean getUserRange(ImportSheet importSheet, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.getDataRange(importSheet.getHead(), nArray, nArray2);
        this.getDataRange(importSheet.getBody(), nArray3, nArray4);
        return nArray[0] < 0 && nArray[1] < 0 && nArray2[0] < 0 && nArray2[1] < 0 && nArray3[0] < 0 && nArray3[1] < 0 && nArray4[0] < 0 && nArray4[1] < 0;
    }

    public void getDataRange(String string, int[] nArray, int[] nArray2) {
        if (objLogger.isDebugEnabled()) {
            objLogger.debug((Object)("Import range : " + StringUtils.normalizeSpace((String)string)));
        }
        if (string == null || "".equals(string)) {
            return;
        }
        try {
            String[] stringArray = string.split("\\:");
            String[] stringArray2 = stringArray[0].split("\\,");
            if (stringArray2[0] != null && !"".equals(stringArray2[0])) {
                nArray[0] = Integer.parseInt(stringArray2[0]);
            }
            if (stringArray2.length > 1 && stringArray2[1] != null && !"".equals(stringArray2[1])) {
                nArray[1] = Integer.parseInt(stringArray2[1]);
            }
            if (stringArray.length > 1) {
                String[] stringArray3 = stringArray[1].split("\\,");
                if (stringArray3[0] != null && !"".equals(stringArray3[0])) {
                    nArray2[0] = Integer.parseInt(stringArray3[0]);
                }
                if (stringArray3.length > 1 && stringArray3[1] != null && !"".equals(stringArray3[1])) {
                    nArray2[1] = Integer.parseInt(stringArray3[1]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException.getMessage());
        }
    }

    private class CSVReader {
        private BufferedReader bufreader;
        private boolean hasnextline = true;
        private char separator;
        private String quoteChars;

        public CSVReader(Reader reader, GridImportContext gridImportContext) {
            this.bufreader = new BufferedReader(reader);
            this.separator = gridImportContext.getSeparator();
            this.quoteChars = gridImportContext.getQuoteChar();
        }

        public void release() throws IOException {
            if (this.bufreader != null) {
                this.bufreader.close();
            }
        }

        public String[] readNext(int n) throws IOException {
            String string = this.getNextLine();
            if (string == null) {
                return null;
            }
            if (n == 0 && string.startsWith("\ufeff")) {
                string = string.substring(1);
            }
            return this.hasnextline ? this.parseLine(string) : null;
        }

        private String getNextLine() throws IOException {
            String string = this.bufreader.readLine();
            if (string == null) {
                this.hasnextline = false;
            }
            return this.hasnextline ? string : null;
        }

        private String[] parseLine(String string) throws IOException {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                if (bl) {
                    stringBuilder.append("\n");
                    string = this.getNextLine();
                    if (string == null) break;
                }
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\\') {
                        if (this.isEscapable(string, bl, i)) {
                            stringBuilder.append(string.charAt(i + 1));
                            ++i;
                            continue;
                        }
                        stringBuilder.append(c);
                        continue;
                    }
                    if (this.quoteChars.length() > 0 && c == this.quoteChars.charAt(0)) {
                        if (this.isEscapedQuote(string, bl, i)) {
                            stringBuilder.append(string.charAt(i + 1));
                            ++i;
                            continue;
                        }
                        boolean bl2 = bl = !bl;
                        if (i <= 2 || string.charAt(i - 1) == this.separator || string.length() <= i + 1 || string.charAt(i + 1) == this.separator) continue;
                        stringBuilder.append(c);
                        continue;
                    }
                    if (c == this.separator && !bl) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        continue;
                    }
                    stringBuilder.append(c);
                }
            } while (bl);
            arrayList.add(stringBuilder.toString());
            return arrayList.toArray(new String[0]);
        }

        private boolean isEscapedQuote(String string, boolean bl, int n) {
            return bl && string.length() > n + 1 && this.quoteChars.length() > 0 && string.charAt(n + 1) == this.quoteChars.charAt(0);
        }

        private boolean isEscapable(String string, boolean bl, int n) {
            return bl && string.length() > n + 1 && (this.quoteChars.length() > 0 && string.charAt(n + 1) == this.quoteChars.charAt(0) || string.charAt(n + 1) == '\\');
        }
    }
}

