/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.GridExportFormatFactory;
import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import com.nexacro.java.xeni.data.exportformats.FormatCell;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.extend.XeniDataValidationBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.util.IOUtils;

public class GridPartExportCsv
implements GridExportBase {
    private static final Log logger = LogFactory.getLog(GridPartExportCsv.class);
    private long accessTime = 0L;
    private boolean isEof = false;
    private boolean isAppended = false;
    private char separator = (char)44;
    private String errorMessage = "";
    private String quoteString = "";
    private String groupSeparator = String.valueOf('\u001d');
    private String absolutePath;
    private String downloadUrl;
    private GridExportContext context = null;
    private ExportFormat gridFormat = null;
    private BufferedWriter outputWriter = null;
    private XeniDataValidationBase validator = null;

    @Override
    public int initialize(GridExportContext gridExportContext, DataSet dataSet) {
        int n;
        String string;
        this.validator = XeniExtendLoader.getDataValidationFactory().getDataValidator();
        this.context = gridExportContext;
        String string2 = dataSet.getString(0, "separator");
        if (this.context.getExportType() == 1296 && string2 != null && string2.length() > 0) {
            this.separator = (char)Integer.parseInt(string2.substring(2), 16);
        }
        if ((string = dataSet.getString(0, "quotechar")) != null) {
            if ("default".equalsIgnoreCase(string)) {
                if (this.context.isCsvQuote()) {
                    this.quoteString = "\"";
                }
            } else if (!"none".equalsIgnoreCase(string)) {
                this.quoteString = "" + string.charAt(0);
            }
        }
        if ((n = this.getExportFilePath()) < 0) {
            return n;
        }
        if ("PlatformXml".equals(this.context.getRequestPlatformType())) {
            this.groupSeparator = "_x001D_";
        }
        String string3 = dataSet.getString(0, "format");
        if (this.context.getCommandVersion() == 2.0f) {
            string3 = new String(Base64.getDecoder().decode(string3), StandardCharsets.UTF_8);
        } else if (this.context.getCommandVersion() == 3.0f) {
            string3 = new String(new Base32().decode(string3), StandardCharsets.UTF_8);
        }
        this.gridFormat = new GridExportFormatFactory().readFormatString(string3);
        if (this.gridFormat == null) {
            this.setErrorMessage("Fail to create grid format.");
            return -2012;
        }
        this.outputWriter = this.getOutputWriter();
        if (this.outputWriter == null) {
            this.setErrorMessage("Fail to create output file. (" + this.context.getInstanceId() + "/" + this.context.getFileName() + ")");
            return -2012;
        }
        return 0;
    }

    @Override
    public int startExport(ServletProvider servletProvider, DataSet dataSet, DataSet dataSet2, DataSet dataSet3) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start export : " + StringUtils.normalizeSpace((String)this.context.getFileName())));
        }
        int n = 0;
        this.context.setSequence(dataSet.getInt(0, "seq"));
        this.setEof(dataSet.getBoolean(0, "eof"));
        if (this.context.getSequence() == 1) {
            if (!this.context.isNoHead() && this.gridFormat.getRowCountOfEachBand("head") > 0 && (n = this.setHead()) < 0) {
                return n;
            }
            if (!this.context.isNoSummary() && this.context.isTopSummary() && this.gridFormat.getRowCountOfEachBand("summ") > 0 && (n = this.setSummary()) < 0) {
                return n;
            }
        }
        if (this.gridFormat.getRowCountOfEachBand("body") > 0 && (n = this.setBody(dataSet3)) < 0) {
            return n;
        }
        if (this.isEof()) {
            if (!this.context.isNoSummary() && !this.context.isTopSummary() && (n = this.setSummary()) < 0) {
                return n;
            }
            n = this.saveExportFile(servletProvider, dataSet);
        } else {
            n = this.sendExportPartResponse(servletProvider, dataSet);
        }
        return n;
    }

    private int getExportFilePath() {
        if (this.context.getAppendUrl() == null) {
            String string = this.context.getFileName();
            String string2 = this.context.getInstanceId();
            if (!(string != null && string.length() > 0 || (string = this.context.getItemName()) != null && string.length() > 0)) {
                string = "TEMP";
            }
            if (string.contains(".") || string.contains("/") || string2.contains(".") || string2.contains("/")) {
                this.setErrorMessage("Invalid file or path name.");
                return -3201;
            }
            int n = 4;
            String string3 = string + ".csv";
            if (this.context.getExportType() == 1296) {
                n = 5;
                string3 = string + ".txt";
            }
            this.absolutePath = this.context.getAbsolutePath() + string2 + "/" + string3;
            if (this.context.isOutsidePath()) {
                try {
                    this.downloadUrl = this.context.getDownloadUrl() + "?command=export&key=" + this.context.getInstanceId() + "&name=" + URLEncoder.encode(string, "UTF-8") + "&type=" + n;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
            } else {
                this.downloadUrl = this.context.getDownloadUrl() + string2 + "/" + string3;
            }
        } else {
            String string = this.context.getAppendUrl();
            this.downloadUrl = string.replaceAll("&amp;", "&");
            if (this.context.isOutsidePath()) {
                int n = string.indexOf("key=");
                String string4 = string.substring(n + 4, string.indexOf(38, n));
                if (string4 == null || string4.contains(".") || string4.contains("/")) {
                    this.setErrorMessage("Invalid key name.");
                    return -3201;
                }
                n = string.indexOf("name=", n);
                String string5 = string.substring(n + 5, string.indexOf(38, n));
                try {
                    string5 = URLDecoder.decode(string5, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
                if (string5 == null || string5.contains(".") || string5.contains("/")) {
                    this.setErrorMessage("Invalid key name.");
                    return -3201;
                }
                n = string.indexOf("type=", n);
                int n2 = Integer.parseInt(string.substring(n + 5));
                String string6 = ".csv";
                if (n2 == 5) {
                    string6 = string6 + ".txt";
                }
                this.absolutePath = this.context.getAbsolutePath() + string4 + "/" + string5 + string6;
            } else {
                int n = string.lastIndexOf("/");
                String string7 = string.substring(0, n);
                String string8 = string.substring(n);
                String string9 = string8.substring(1, string8.lastIndexOf(46));
                if (string9 == null || string9.contains(".") || string9.contains("/")) {
                    this.setErrorMessage("Invalid file name.");
                    return -3201;
                }
                this.absolutePath = this.context.getAbsolutePath() + string7.substring(string7.lastIndexOf("/")) + string8;
            }
        }
        return 0;
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMessage = string;
        if (logger.isErrorEnabled()) {
            logger.error((Object)StringUtils.normalizeSpace((String)string));
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getAccessTime() {
        return this.accessTime;
    }

    @Override
    public void setAccessTime(long l) {
        this.accessTime = l;
    }

    @Override
    public boolean isEof() {
        return this.isEof;
    }

    @Override
    public void setEof(boolean bl) {
        this.isEof = bl;
    }

    @Override
    public GridExportContext getExportContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedWriter getOutputWriter() {
        BufferedWriter bufferedWriter = null;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (this.context.getAppendUrl() == null) {
                int n = this.absolutePath.lastIndexOf("/");
                String string = this.absolutePath.substring(0, n);
                File file = XeniUtils.getXeniFileHandler(string).toFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                bufferedWriter = this.getBufferedWriter(false);
            } else {
                XeniExcelDataStorageBase xeniExcelDataStorageBase = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
                if (xeniExcelDataStorageBase instanceof XeniExcelDataStorageDef) {
                    bufferedWriter = this.getBufferedWriter(true);
                } else {
                    int n;
                    inputStream = xeniExcelDataStorageBase.loadTargetStream(this.absolutePath);
                    if (inputStream == null) {
                        BufferedWriter bufferedWriter2 = null;
                        return bufferedWriter2;
                    }
                    byte[] byArray = new byte[8192];
                    fileOutputStream = new FileOutputStream(XeniUtils.getXeniFileHandler(this.absolutePath + ".xeni").toFile());
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    Files.move(XeniUtils.getXeniFileHandler(this.absolutePath + ".xeni").toPath(), XeniUtils.getXeniFileHandler(this.absolutePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    bufferedWriter = this.getBufferedWriter(true);
                }
            }
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
            BufferedWriter bufferedWriter3 = null;
            return bufferedWriter3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        return bufferedWriter;
    }

    private BufferedWriter getBufferedWriter(boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(XeniUtils.getXeniFileHandler(this.absolutePath).toFile(), bl);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        if (!bl && this.context.isCsvBom()) {
            bufferedWriter.append("\ufeff");
        }
        return bufferedWriter;
    }

    private void setCsvValue(String string) throws IOException {
        if (this.validator != null) {
            string = this.validator.checkData(string);
        }
        this.outputWriter.append(this.quoteString + string + this.quoteString);
    }

    private int setHead() {
        int n = 0;
        int n2 = 0;
        int n3 = this.gridFormat.getHeadCellCount();
        try {
            if (n3 > 0) {
                if (this.context.getAppendUrl() != null) {
                    this.outputWriter.append("\r\n");
                }
                this.isAppended = true;
            }
            for (int i = 0; i < n3; ++i) {
                FormatCell formatCell = this.gridFormat.getHeadCell(i);
                int n4 = Integer.parseInt(formatCell.getRow());
                int n5 = Integer.parseInt(formatCell.getCol());
                if (n4 > n) {
                    this.outputWriter.append("\r\n");
                    n2 = 0;
                }
                if (i > 0) {
                    for (int j = 0; j < n5 - n2; ++j) {
                        this.outputWriter.append(this.separator);
                    }
                }
                this.setCsvValue(formatCell.getText());
                n = n4;
                n2 = n5;
            }
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
            return -2003;
        }
        return 0;
    }

    private int setSummary() {
        int n = 0;
        int n2 = 0;
        int n3 = this.gridFormat.getSummaryCellCount();
        try {
            if (n3 > 0) {
                if (this.isAppended) {
                    this.outputWriter.append("\r\n");
                } else if (this.context.getAppendUrl() != null) {
                    this.outputWriter.append("\r\n");
                }
                this.isAppended = true;
            }
            for (int i = 0; i < n3; ++i) {
                FormatCell formatCell = this.gridFormat.getSummary(i);
                int n4 = Integer.parseInt(formatCell.getRow());
                int n5 = Integer.parseInt(formatCell.getCol());
                if (n4 > n) {
                    this.outputWriter.append("\r\n");
                    n2 = 0;
                }
                if (i > 0) {
                    for (int j = 0; j < n5 - n2; ++j) {
                        this.outputWriter.append(this.separator);
                    }
                }
                this.setCsvValue(formatCell.getText());
                n = n4;
                n2 = n5;
            }
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
            return -2003;
        }
        return 0;
    }

    private int setBody(DataSet dataSet) {
        int n;
        int n2 = dataSet.getColumnCount();
        if (n2 != (n = this.gridFormat.getBodyCellCount())) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fault.bodyformat", Integer.toString(n2), Integer.toString(n)));
            return -2014;
        }
        try {
            int n3 = 0;
            while (dataSet.getRowCount() > 0) {
                if (this.isAppended) {
                    this.outputWriter.append("\r\n");
                } else {
                    if (this.context.getAppendUrl() != null) {
                        this.outputWriter.append("\r\n");
                    }
                    this.isAppended = true;
                }
                int n4 = -1;
                for (int i = 0; i < n; ++i) {
                    String[] stringArray;
                    String string;
                    FormatCell formatCell = this.gridFormat.getBodyCell(i);
                    int n5 = Integer.parseInt(formatCell.getRow());
                    int n6 = Integer.parseInt(formatCell.getColspan());
                    if (i > 0) {
                        if (n5 > n4) {
                            this.outputWriter.append("\r\n");
                        } else {
                            this.outputWriter.append(this.separator);
                        }
                    }
                    if ((string = dataSet.getString(n3, i)) != null && string.length() > 0 && (stringArray = string.split(this.groupSeparator)).length > 0) {
                        String string2 = stringArray[0];
                        if (this.context.getCommandVersion() == 2.0f) {
                            string2 = new String(Base64.getDecoder().decode(string2), StandardCharsets.UTF_8);
                        } else if (this.context.getCommandVersion() == 3.0f) {
                            string2 = new String(new Base32().decode(string2), StandardCharsets.UTF_8);
                        }
                        this.setCsvValue(string2);
                    }
                    for (int j = 1; j < n6; ++j) {
                        this.outputWriter.append(this.separator);
                    }
                    n4 = n5;
                }
                dataSet.removeRow(n3);
            }
            this.outputWriter.flush();
        }
        catch (IOException iOException) {
            this.setErrorMessage(iOException.getMessage());
            return -2003;
        }
        return 0;
    }

    private int sendExportPartResponse(ServletProvider servletProvider, DataSet dataSet) {
        PlatformData platformData = new PlatformData();
        VariableList variableList = platformData.getVariableList();
        variableList.add("ErrorCode", 0);
        variableList.add("ErrorMsg", "SUCCESS");
        DataSet dataSet2 = CommUtil.getDatasetExportResponse(dataSet);
        if (this.isEof()) {
            dataSet2.set(0, "url", this.downloadUrl);
        }
        platformData.addDataSet(dataSet2);
        try {
            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(servletProvider.getHttpServletResponse(), this.context.getResponsePlatformType(), "UTF-8");
            httpPlatformResponse.setData(platformData);
            httpPlatformResponse.sendData();
        }
        catch (PlatformException platformException) {
            this.setErrorMessage(platformException.getMessage());
            return -2001;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveExportFile(ServletProvider servletProvider, DataSet dataSet) {
        int n = 0;
        FileInputStream fileInputStream = null;
        try {
            XeniExcelDataStorageBase xeniExcelDataStorageBase = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
            if (xeniExcelDataStorageBase == null) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fail.create.extendclass", "xeni.exportimport.storage"));
                int n2 = -2004;
                return n2;
            }
            this.outputWriter.flush();
            if (xeniExcelDataStorageBase instanceof XeniExcelDataStorageDef) {
                this.sendExportPartResponse(servletProvider, dataSet);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                fileInputStream = new FileInputStream(XeniUtils.getXeniFileHandler(this.absolutePath).toFile());
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream);
                n = xeniExcelDataStorageBase.saveExportStream(this.context.getUserVariableList(), dataSet, byteArrayOutputStream, this.absolutePath, this.downloadUrl, servletProvider.getHttpServletResponse());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.no.such.file"));
            n = -2020;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
            n = -2001;
        }
        finally {
            try {
                if (this.outputWriter != null) {
                    this.outputWriter.close();
                }
            }
            catch (IOException iOException) {
                this.setErrorMessage(iOException.getMessage());
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        return n;
    }
}

