/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xeni.extend.XeniDataValidationBase;
import com.nexacro.java.xeni.extend.XeniDataValidationFactory;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageFactory;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartProcDef;
import com.nexacro.java.xeni.extend.XeniMultipartProcFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public class XeniExtendLoader {
    static final XeniDataValidationFactory dataValidationFactory = XeniExtendLoader.loadDataValidationFactory();
    static final XeniExcelDataStorageFactory excelDataStorageFactory = XeniExtendLoader.loadExcelDataStorageFactory();
    static final XeniMultipartProcFactory multipartProcFactory = XeniExtendLoader.loadMultipartProcFactory();

    public static XeniDataValidationFactory getDataValidationFactory() {
        return dataValidationFactory;
    }

    public static XeniExcelDataStorageFactory getExcelDataStorageFactory() {
        return excelDataStorageFactory;
    }

    public static XeniMultipartProcFactory getMultipartProcFactory() {
        return multipartProcFactory;
    }

    protected static final XeniDataValidationFactory loadDataValidationFactory() {
        XeniDataValidationFactory xeniDataValidationFactory = null;
        ServiceLoader<XeniDataValidationFactory> serviceLoader = ServiceLoader.load(XeniDataValidationFactory.class);
        Iterator<XeniDataValidationFactory> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            XeniDataValidationFactory xeniDataValidationFactory2;
            xeniDataValidationFactory = xeniDataValidationFactory2 = iterator.next();
        }
        if (xeniDataValidationFactory == null) {
            xeniDataValidationFactory = new DataValidationFactory();
        }
        return xeniDataValidationFactory;
    }

    protected static final XeniExcelDataStorageFactory loadExcelDataStorageFactory() {
        XeniExcelDataStorageFactory xeniExcelDataStorageFactory = null;
        ServiceLoader<XeniExcelDataStorageFactory> serviceLoader = ServiceLoader.load(XeniExcelDataStorageFactory.class);
        Iterator<XeniExcelDataStorageFactory> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            XeniExcelDataStorageFactory xeniExcelDataStorageFactory2;
            xeniExcelDataStorageFactory = xeniExcelDataStorageFactory2 = iterator.next();
        }
        if (xeniExcelDataStorageFactory == null) {
            xeniExcelDataStorageFactory = new ExcelDataStorageFactory();
        }
        return xeniExcelDataStorageFactory;
    }

    protected static final XeniMultipartProcFactory loadMultipartProcFactory() {
        XeniMultipartProcFactory xeniMultipartProcFactory = null;
        ServiceLoader<XeniMultipartProcFactory> serviceLoader = ServiceLoader.load(XeniMultipartProcFactory.class);
        Iterator<XeniMultipartProcFactory> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            XeniMultipartProcFactory xeniMultipartProcFactory2;
            xeniMultipartProcFactory = xeniMultipartProcFactory2 = iterator.next();
        }
        if (xeniMultipartProcFactory == null) {
            xeniMultipartProcFactory = new MultipartProcFactory();
        }
        return xeniMultipartProcFactory;
    }

    private XeniExtendLoader() {
    }

    public static class MultipartProcFactory
    implements XeniMultipartProcFactory {
        @Override
        public XeniMultipartProcBase getMultipartProc(String string) {
            return new XeniMultipartProcDef();
        }
    }

    public static class ExcelDataStorageFactory
    implements XeniExcelDataStorageFactory {
        @Override
        public XeniExcelDataStorageBase getExtendClass(String string) {
            return new XeniExcelDataStorageDef();
        }
    }

    public static class DataValidationFactory
    implements XeniDataValidationFactory {
        @Override
        public XeniDataValidationBase getDataValidator() {
            return null;
        }
    }
}

