/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartReqData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniMultipartProcDef
implements XeniMultipartProcBase {
    private static final Log logger = LogFactory.getLog(XeniMultipartProcDef.class);

    @Override
    public XeniMultipartReqData getImportData(HttpServletRequest httpServletRequest) throws Exception {
        ServletFileUpload servletFileUpload = new ServletFileUpload();
        XeniMultipartReqData xeniMultipartReqData = new XeniMultipartReqData();
        servletFileUpload.setHeaderEncoding("UTF-8");
        FileItemIterator fileItemIterator = servletFileUpload.getItemIterator(httpServletRequest);
        String string = null;
        while (fileItemIterator.hasNext()) {
            FileItemStream fileItemStream = fileItemIterator.next();
            if (fileItemStream.isFormField()) {
                xeniMultipartReqData.setPlatformData(this.getPlatformData(fileItemStream.openStream()));
            } else {
                string = fileItemStream.getName();
                int n = (string = string.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (n >= 0) {
                    string = string.substring(n + 1);
                }
                xeniMultipartReqData.setFileName(string);
                InputStream inputStream = fileItemStream.openStream();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream));
                xeniMultipartReqData.setFileStream(byteArrayInputStream);
                inputStream.close();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("File field " + fileItemStream.getFieldName() + " with file name " + string + " detected."));
        }
        return xeniMultipartReqData;
    }

    private boolean IsValidName(String string) {
        boolean bl = false;
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        if (string2.length() > 0 && ("xls".equalsIgnoreCase(string2) || "xlsx".equalsIgnoreCase(string2) || "cell".equalsIgnoreCase(string2) || "csv".equalsIgnoreCase(string2) || "xlsm".equalsIgnoreCase(string2) || "pia".equalsIgnoreCase(string2))) {
            bl = true;
        }
        return bl;
    }

    private PlatformData getPlatformData(InputStream inputStream) throws PlatformException {
        PlatformRequest platformRequest = new PlatformRequest(inputStream);
        platformRequest.receiveData();
        return platformRequest.getData();
    }
}

