/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xeni.extend.XeniCTXf;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XeniStylesTable
extends DefaultHandler {
    private boolean bHancell = false;
    private Boolean bIsCTXF = false;
    private final List<XeniCTXf> styleXfs = new ArrayList<XeniCTXf>();
    private final List<XeniCTXf> xfs = new ArrayList<XeniCTXf>();
    private XeniCTXf ctXf = null;
    private XeniCTXf styleCtXf = null;

    public XeniStylesTable() {
    }

    public XeniStylesTable(OPCPackage oPCPackage) throws IOException, SAXException, XmlException {
        ArrayList arrayList = oPCPackage.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (arrayList.size() > 0) {
            this.bHancell = true;
            PackagePart packagePart = (PackagePart)arrayList.get(0);
            this.readFrom(packagePart.getInputStream());
        }
    }

    public void readFrom(OPCPackage oPCPackage) throws IOException, SAXException {
        ArrayList arrayList = oPCPackage.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (arrayList.size() > 0) {
            this.bHancell = true;
            PackagePart packagePart = (PackagePart)arrayList.get(0);
            this.readFrom(packagePart.getInputStream());
        }
    }

    public void readFrom(InputStream inputStream) throws IOException, SAXException {
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("SAX parser appears to be broken - " + parserConfigurationException.getMessage());
        }
    }

    public List<XeniCTXf> getArrCtxf() {
        return this.xfs;
    }

    public short getDataFormat(int n) {
        return this.xfs.get(n).getNumFmtId();
    }

    public String getDataFormatString(Short s) {
        String string = null;
        List<XeniCTXf> list = this.styleXfs;
        for (XeniCTXf xeniCTXf : list) {
            if (xeniCTXf.getNumFmtId() != s.shortValue()) continue;
            string = xeniCTXf.getFormatCode();
            break;
        }
        return string;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("x:numFmt") || string3.equals("numFmt")) {
            this.styleCtXf = new XeniCTXf();
            this.styleCtXf.setNumFmtId(Short.parseShort(attributes.getValue("numFmtId")));
            this.styleCtXf.setFormatCode(attributes.getValue("formatCode"));
        } else if (string3.equals("x:cellXfs") || string3.equals("cellXfs")) {
            this.bIsCTXF = true;
        } else if (string3.equals("mc:Choice") || string3.equals("Choice")) {
            this.bIsCTXF = false;
        } else if (string3.equals("mc:Fallback") || string3.equals("Fallback")) {
            this.bIsCTXF = true;
        } else if (this.bIsCTXF.booleanValue() && (string3.equals("x:xf") || string3.equals("xf"))) {
            this.ctXf = new XeniCTXf();
            this.ctXf.setNumFmtId(Short.parseShort(attributes.getValue("numFmtId")));
        } else if (string3.equals("styleSheet") && attributes.getIndex("xmlns:x") < 0) {
            this.bHancell = false;
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("x:cellXfs") || string3.equals("cellXfs")) {
            this.bIsCTXF = false;
        } else if (string3.equals("x:numFmt") || string3.equals("numFmt")) {
            this.styleXfs.add(this.styleCtXf);
        } else if (this.bIsCTXF.booleanValue() && (string3.equals("x:xf") || string3.equals("xf"))) {
            this.xfs.add(this.ctXf);
        }
    }

    public boolean isHancellStyle() {
        return this.bHancell;
    }
}

