/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.services;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xapi.tx.impl.PlatformJsonDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformSsvDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformXmlDataSerializer;
import com.nexacro.java.xeni.data.GridExportDataFactory;
import com.nexacro.java.xeni.data.GridImportFormatFactory;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.export.GridExportTypeFactory;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartReqData;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.services.ExportImportConfiguration;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.GridImportTypeFactory;
import com.nexacro.java.xeni.ximport.PlatformCsvDataSerializer;
import com.nexacro.java.xeni.ximport.impl.GridImportExcelXSSFEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class GridExportImportAgent {
    private static final Log logger = LogFactory.getLog(GridExportImportAgent.class);
    private String errorMsg = "";
    private String securityPattern = XeniProperties.getStringProperty("xeni.security.pattern");
    private String securityPattern2;

    public GridExportImportAgent() {
        if (this.securityPattern == null || this.securityPattern.length() <= 0) {
            this.securityPattern = "'|\"|:|;|\\(|\\)|<|>|\\[|\\]|\\{|\\}|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
            this.securityPattern2 = "'|\"|:|;|<|>|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
        } else {
            this.securityPattern2 = this.securityPattern;
        }
        String string = XeniProperties.getStringProperty("xeni.guard.maxentry.size", null);
        String string2 = XeniProperties.getStringProperty("xeni.guard.maxtext.size", null);
        String string3 = XeniProperties.getStringProperty("xeni.guard.mininflate.ratio", null);
        if (string != null) {
            ZipSecureFile.setMaxEntrySize((long)Long.parseLong(string));
        }
        if (string2 != null) {
            ZipSecureFile.setMaxTextSize((long)Long.parseLong(string2));
        }
        if (string3 != null) {
            ZipSecureFile.setMinInflateRatio((double)Double.parseDouble(string3));
        }
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public int gridExport(ServletProvider servletProvider, ExportImportConfiguration exportImportConfiguration) throws PlatformException, IOException {
        Object object;
        HashMap<String, GridExportBase> hashMap;
        Object object2;
        Object object3;
        Object object4;
        int n = 0;
        PlatformRequest platformRequest = new PlatformRequest((InputStream)servletProvider.getHttpServletRequest().getInputStream());
        platformRequest.receiveData();
        PlatformData platformData = platformRequest.getData();
        if (platformData == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            return -2006;
        }
        DataSetList dataSetList = platformData.getDataSetList();
        VariableList variableList = platformData.getVariableList();
        DataSet dataSet = dataSetList.get("COMMAND");
        if (dataSet == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            return -2006;
        }
        String string = dataSet.getString(0, "command");
        if (!string.equals("export")) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.not.exporttype", string);
            return -2006;
        }
        String string2 = dataSet.getString(0, "instanceid");
        if (string2 == null || string2.equals("")) {
            string2 = this.createInstanceId(servletProvider);
        }
        if (logger.isInfoEnabled()) {
            object4 = dataSet.getString(0, "item");
            object3 = dataSet.getString(0, "seq");
            object2 = dataSet.getString(0, "eof");
            hashMap = dataSet.getString(0, "url");
            object = dataSet.getString(0, "instanceid");
            logger.info((Object)("Input export data : [ Item = " + StringUtils.normalizeSpace((String)object4) + ", Seq. = " + StringUtils.normalizeSpace((String)object3) + ", EOF = " + StringUtils.normalizeSpace((String)object2) + ", Url = " + StringUtils.normalizeSpace((String)((Object)hashMap)) + ", Inst.Id = " + StringUtils.normalizeSpace((String)object) + " ]"));
        }
        object4 = null;
        object3 = dataSetList.get("STYLE");
        object2 = dataSetList.get("CELL");
        hashMap = GridExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        if (hashMap.containsKey(string2)) {
            object4 = hashMap.get(string2);
            object = object4.getExportContext();
            ((GridExportContext)object).setAbsolutePath(exportImportConfiguration.getExportPath());
            ((GridExportContext)object).setDownloadUrl(exportImportConfiguration.getExportUrl());
            ((GridExportContext)object).setUserVariableList(variableList);
            n = object4.startExport(servletProvider, dataSet, (DataSet)object3, (DataSet)object2);
            if (!object4.isEof() && n == 0) {
                object4.setAccessTime(System.currentTimeMillis());
            } else {
                hashMap.remove(string2);
            }
        } else {
            int n2 = dataSet.getInt(0, "type");
            object4 = GridExportTypeFactory.getGridExporter(n2);
            if (object4 == null) {
                this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.fail.create.exporter", Integer.toHexString(n2));
                if (logger.isErrorEnabled()) {
                    logger.error((Object)StringUtils.normalizeSpace((String)this.errorMsg));
                }
                return -2008;
            }
            dataSet.set(0, "instanceid", string2);
            GridExportContext gridExportContext = this.getExportContext(dataSet, variableList, platformRequest.getContentType(), exportImportConfiguration);
            n = object4.initialize(gridExportContext, dataSet);
            if (n >= 0) {
                n = object4.startExport(servletProvider, dataSet, (DataSet)object3, (DataSet)object2);
            }
            if (!object4.isEof() && n == 0) {
                object4.setAccessTime(System.currentTimeMillis());
                hashMap.put(string2, (GridExportBase)object4);
            }
        }
        if (n != 0) {
            this.errorMsg = object4.getErrorMessage();
            if (hashMap.containsKey(string2)) {
                hashMap.remove(string2);
            }
        }
        return n;
    }

    private GridExportContext getExportContext(DataSet dataSet, VariableList variableList, String string, ExportImportConfiguration exportImportConfiguration) {
        GridExportContext gridExportContext = new GridExportContext();
        gridExportContext.setCsvQuote(exportImportConfiguration.isCsvQuote());
        gridExportContext.setCsvBom(exportImportConfiguration.isCsvBom());
        gridExportContext.setRequestPlatformType(string);
        gridExportContext.setResponsePlatformType(XeniProperties.getStringProperty("xeni.export.commdataformat"));
        gridExportContext.setAbsolutePath(exportImportConfiguration.getExportPath());
        gridExportContext.setDownloadUrl(exportImportConfiguration.getExportUrl());
        gridExportContext.setOutsidePath(exportImportConfiguration.isExportAbsPath());
        gridExportContext.setUserVariableList(variableList);
        gridExportContext.setAppendUrl(dataSet.getString(0, "url"));
        gridExportContext.setExportType(dataSet.getInt(0, "type"));
        gridExportContext.setItemName(dataSet.getString(0, "item"));
        gridExportContext.setFileName(dataSet.getString(0, "exportfilename"));
        gridExportContext.setInstanceId(dataSet.getString(0, "instanceid"));
        String string2 = dataSet.getString(0, "exporthead");
        if (string2 != null) {
            gridExportContext.setNoHead(string2.contains("nohead"));
            gridExportContext.setNoSummary(string2.contains("nosumm"));
        }
        gridExportContext.setTopSummary("top".equals(dataSet.getString(0, "summarytype")));
        if ("both".equals(dataSet.getString(0, "exportsize"))) {
            gridExportContext.setApplyHeight(true);
        } else if ("height".equals(dataSet.getString(0, "exportsize"))) {
            gridExportContext.setApplyWidth(false);
            gridExportContext.setApplyHeight(true);
        }
        gridExportContext.setWrapText(dataSet.getBoolean(0, "wraptext"));
        gridExportContext.setRtl(dataSet.getBoolean(0, "righttoleft"));
        gridExportContext.setPassword(dataSet.getString(0, "password"));
        gridExportContext.setCommandVersion(dataSet.getFloat(0, "commandversion"));
        return gridExportContext;
    }

    public int gridImport(ServletProvider servletProvider, ExportImportConfiguration exportImportConfiguration) throws IOException, PlatformException, Exception {
        int n;
        Object object;
        XeniMultipartProcBase xeniMultipartProcBase = XeniExtendLoader.getMultipartProcFactory().getMultipartProc("xeni.multipart.proc");
        if (xeniMultipartProcBase == null) {
            this.errorMsg = "Could not create extend class : " + XeniProperties.getStringProperty("xeni.multipart.proc");
            return -3101;
        }
        XeniMultipartReqData xeniMultipartReqData = xeniMultipartProcBase.getImportData(servletProvider.getHttpServletRequest());
        if (xeniMultipartReqData == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.request.data.null");
            return -3101;
        }
        PlatformData platformData = xeniMultipartReqData.getPlatformData();
        if (platformData == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.command.data.null");
            return -3101;
        }
        VariableList variableList = platformData.getVariableList();
        DataSetList dataSetList = platformData.getDataSetList();
        DataSet dataSet = dataSetList.get("COMMAND");
        GridImportContext gridImportContext = this.getImportContext(dataSet, variableList, exportImportConfiguration);
        if (logger.isInfoEnabled()) {
            object = dataSet.getString(0, "filemode");
            String string = dataSet.getString(0, "url");
            String string2 = dataSet.getString(0, "usehtmltag");
            String string3 = dataSet.getString(0, "rawnumbervalue");
            logger.info((Object)("Input import data : [ Mode = " + StringUtils.normalizeSpace((String)object) + ", Url = " + StringUtils.normalizeSpace((String)string) + ", Html tag = " + StringUtils.normalizeSpace((String)string2) + ", Raw num = " + StringUtils.normalizeSpace((String)string3) + " ]"));
        }
        if (!"import".equals(dataSet.getString(0, "command"))) {
            this.errorMsg = "Not import type. The type is " + dataSet.getString(0, "command");
            return this.sendImportError(servletProvider, -2006, this.errorMsg, gridImportContext);
        }
        if (!gridImportContext.isServerMode() && (n = this.saveImportStream(this.createInstanceId(servletProvider), variableList, exportImportConfiguration.isTempName(), gridImportContext, xeniMultipartReqData)) < 0) {
            return this.sendImportError(servletProvider, n, this.errorMsg, gridImportContext);
        }
        object = null;
        try {
            object = this.getGridImporter(gridImportContext);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg = "File or directory not found. [" + gridImportContext.getFileUrl() + "]";
            return this.sendImportError(servletProvider, -2003, this.errorMsg, gridImportContext);
        }
        catch (Exception exception) {
            if (gridImportContext.isFileMonitor() && !gridImportContext.isServerMode()) {
                CommUtil.deleteDir(gridImportContext.getFilePath() + gridImportContext.getFileUrl());
            }
            this.errorMsg = exception.getMessage();
            return this.sendImportError(servletProvider, -2005, this.errorMsg, gridImportContext);
        }
        if (!(object instanceof GridImportExcelXSSFEvent)) {
            gridImportContext.setPartData(false);
        }
        if (gridImportContext.isPartData()) {
            gridImportContext.setServletProvider(servletProvider);
            gridImportContext.initPartDataSerializer();
        }
        gridImportContext.setPlatformData(new PlatformData());
        object.initialize(gridImportContext);
        int n2 = object.startImport();
        n2 = this.sendImportResponse(servletProvider, gridImportContext, n2, object.getErrorMessage());
        if (n2 < 0) {
            n2 = this.sendImportError(servletProvider, n2, this.errorMsg, gridImportContext);
        }
        return n2;
    }

    private GridImportContext getImportContext(DataSet dataSet, VariableList variableList, ExportImportConfiguration exportImportConfiguration) throws UnsupportedEncodingException {
        GridImportContext gridImportContext = new GridImportContext();
        gridImportContext.setCsvQuote(exportImportConfiguration.isCsvQuote());
        gridImportContext.setFilePath(exportImportConfiguration.getImportPath());
        gridImportContext.setFileMonitor(exportImportConfiguration.isFileManage());
        gridImportContext.setImportId(dataSet.getString(0, "importid"));
        gridImportContext.setUserDomain(variableList.getString("domain"));
        gridImportContext.setImportType(dataSet.getInt(0, "type"));
        gridImportContext.setFilePassword(dataSet.getString(0, "password"));
        gridImportContext.setResponseContentType(XeniProperties.getStringProperty("xeni.import.commdataformat", "ssv"));
        gridImportContext.setCommandVersion(dataSet.getFloat(0, "commandversion"));
        gridImportContext.setCompatibleMode(variableList.getInt("compatiblemode"));
        gridImportContext.setSentData(false);
        String string = null;
        string = dataSet.getString(0, "filemode");
        if ("local".equals(string)) {
            gridImportContext.setServerMode(false);
        } else {
            gridImportContext.setServerMode(true);
            gridImportContext.setFileUrl(URLDecoder.decode(dataSet.getString(0, "url"), "UTF-8"));
        }
        string = dataSet.getString(0, "responsetype");
        if (string != null) {
            gridImportContext.setCorsResponseType(Integer.parseInt(string));
        }
        string = dataSet.getString(0, "format");
        if (gridImportContext.getCommandVersion() == 2.0f) {
            string = new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
        } else if (gridImportContext.getCommandVersion() == 3.0f) {
            string = new String(new Base32().decode(string), StandardCharsets.UTF_8);
        }
        gridImportContext.setImportFormat(new GridImportFormatFactory().readFormatString(string));
        string = dataSet.getString(0, "rawdatevalue");
        if (string != null && "true".equals(string)) {
            gridImportContext.setRawDateValue(true);
        }
        if ((string = dataSet.getString(0, "usehtmltag")) == null || "false".equals(string)) {
            gridImportContext.setUseHtmlTag(false);
        }
        if ((string = dataSet.getString(0, "rawnumbervalue")) != null && "false".equals(string)) {
            gridImportContext.setRawNumberValue(false);
        }
        gridImportContext.setSeparator(dataSet.getString(0, "separator"));
        gridImportContext.setQuoteChar(dataSet.getString(0, "quotechar"));
        return gridImportContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveImportStream(String string, VariableList variableList, boolean bl, GridImportContext gridImportContext, XeniMultipartReqData xeniMultipartReqData) {
        Object object;
        InputStream inputStream = xeniMultipartReqData.getFileStream();
        if (inputStream == null) {
            this.errorMsg = "Upload file stream is null.";
            return -3101;
        }
        String string2 = xeniMultipartReqData.getFileName();
        if (bl) {
            object = "";
            int n = string2.lastIndexOf(46);
            if (n > 0) {
                object = string2.substring(n);
            }
            string2 = "import_temp" + (String)object;
        }
        if (!this.isValidFileName(string2)) {
            return -3101;
        }
        object = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
        if (object == null) {
            this.errorMsg = "Could not create extend class : " + XeniProperties.getStringProperty("xeni.exportimport.storage");
            return -3101;
        }
        try {
            String string3 = "/" + string + "/" + string2;
            String string4 = object.saveImportStream(variableList, inputStream, gridImportContext.getFilePath() + string3);
            if (string4 != null) {
                string3 = string4;
            }
            gridImportContext.setFileUrl(string3);
        }
        catch (Exception exception) {
            this.errorMsg = exception.getMessage();
            int n = -3101;
            return n;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        }
        return 0;
    }

    private GridImportBase getGridImporter(GridImportContext gridImportContext) throws Exception {
        GridImportBase gridImportBase = GridImportTypeFactory.getGridImporter(gridImportContext.getImportType(), gridImportContext.getFilePath(), gridImportContext.getFileUrl(), gridImportContext.getFilePassword());
        if (gridImportBase == null || gridImportBase.getErrorCode() < 0) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.fail.create.importer");
            this.errorMsg = gridImportBase != null ? this.errorMsg + " [" + gridImportBase.getErrorMessage() + "]" : this.errorMsg + " [" + XeniErrorProperties.getErrorProperty("err.agent.unsupported.format") + "]";
            if (logger.isErrorEnabled()) {
                logger.error((Object)StringUtils.normalizeSpace((String)this.errorMsg));
            }
            throw new Exception(this.errorMsg);
        }
        return gridImportBase;
    }

    private int sendImportResponse(ServletProvider servletProvider, GridImportContext gridImportContext, int n, String string) {
        if (n == 0 && gridImportContext.isPartData()) {
            return 0;
        }
        try {
            VariableList variableList = gridImportContext.getPlatformData().getVariableList();
            if (n == 0) {
                gridImportContext.getPlatformData().getDataSet("IMPORTFILES").set(0, "importid", gridImportContext.getImportId());
                variableList.add("ErrorCode", 0);
                variableList.add("ErrorMsg", "SUCCESS");
            } else {
                variableList.add("ErrorCode", n);
                variableList.add("ErrorMsg", string);
                int n2 = gridImportContext.getPartIndex();
                if (gridImportContext.isPartData() && n2 >= 1) {
                    this.sendPartData(variableList, gridImportContext, n2);
                    return 0;
                }
            }
            String string2 = gridImportContext.getResponseContentType();
            if (gridImportContext.getCorsResponseType() == 1) {
                this.sendCorsReviseResponse(servletProvider, gridImportContext.getPlatformData(), string2);
            } else {
                String string3 = gridImportContext.getUserDomain();
                if (string3 != null && string3.length() > 0) {
                    this.sendDomainResponse(servletProvider, gridImportContext.getPlatformData(), string3, string2);
                } else {
                    this.sendCommonResponse(servletProvider, gridImportContext.getPlatformData(), string2, gridImportContext.isUseHtmlTag());
                }
            }
        }
        catch (PlatformException platformException) {
            this.errorMsg = platformException.getMessage();
            return -3101;
        }
        catch (Exception exception) {
            this.errorMsg = exception.getMessage();
            return -2001;
        }
        return 0;
    }

    private String createInstanceId(ServletProvider servletProvider) {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendExportFileStream(ServletProvider servletProvider, String string) throws IOException {
        Map<String, String> map = this.getQueryParameters(servletProvider.getHttpServletRequest().getQueryString());
        if (map == null) {
            this.errorMsg = "Invalid export file parameter.";
            return -3201;
        }
        int n = 0;
        String string2 = map.get("command");
        if (string2 == null || !string2.equals("export")) {
            this.errorMsg = string2 != null && this.isContainSecureCharacter(string2) ? XeniErrorProperties.getErrorProperty("err.agent.fail.excute.command", "") : XeniErrorProperties.getErrorProperty("err.agent.fail.excute.command", string2);
            return -3201;
        }
        String string3 = map.get("key");
        if (string3 == null || string3.contains(".") || string3.contains("/")) {
            this.errorMsg = this.isContainSecureCharacter(string3) ? XeniErrorProperties.getErrorProperty("err.agent.invalid.export.key", "") : XeniErrorProperties.getErrorProperty("err.agent.invalid.export.key", string3);
            return -3201;
        }
        String string4 = map.get("name");
        String string5 = "";
        try {
            string5 = URLDecoder.decode(string4, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errorMsg = this.isContainSecureCharacter(string5) ? XeniErrorProperties.getErrorProperty("err.agent.fail.decode.name", "") : XeniErrorProperties.getErrorProperty("err.agent.fail.decode.name", string5);
            return -3201;
        }
        if (string5 == null || string5.contains(".") || string5.contains("/")) {
            this.errorMsg = this.isContainSecureCharacter(string5) ? XeniErrorProperties.getErrorProperty("err.agent.invalid.filename", "") : XeniErrorProperties.getErrorProperty("err.agent.invalid.filename", string5);
            return -3201;
        }
        String string6 = map.get("type");
        if (string6 == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", "");
            return -3201;
        }
        int n2 = 1;
        try {
            n2 = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            this.errorMsg = this.isContainSecureCharacter(string6) ? XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", "") : XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", string6);
            return -3201;
        }
        String string7 = "";
        String string8 = "";
        if (n2 == 0) {
            string7 = ".xls";
            string8 = "application/vnd.ms-excel";
        } else if (n2 == 1) {
            string7 = ".xlsx";
            string8 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (n2 == 2) {
            string7 = ".cell";
            string8 = "application/vnd.ms-excel";
        } else if (n2 == 3) {
            string7 = ".cell";
            string8 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (n2 == 4) {
            string7 = ".csv";
            servletProvider.getHttpServletResponse().setContentType("text/csv");
        } else if (n2 == 5) {
            string7 = ".txt";
            servletProvider.getHttpServletResponse().setContentType("text/csv");
        } else {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", Integer.toString(n2));
            return -3201;
        }
        String string9 = string + string3 + "/" + string5 + string7;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(XeniUtils.getXeniFileHandler(string9).toFile());
            servletProvider.getHttpServletResponse().setContentType(StringUtils.normalizeSpace((String)string8));
            String string10 = "attachment; filename=" + URLEncoder.encode(string5, "UTF-8").replaceAll("\\+", "%20") + string7;
            servletProvider.getHttpServletResponse().addHeader("Content-Disposition", StringUtils.normalizeSpace((String)string10));
            servletProvider.writeOutputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg = this.isContainSecureCharacter(string3) || this.isContainSecureCharacter(string5) ? XeniErrorProperties.getErrorProperty("err.agent.file.notfound", "") : XeniErrorProperties.getErrorProperty("err.agent.file.notfound", string3 + "/" + string5 + string7);
            n = -2001;
        }
        catch (IOException iOException) {
            this.errorMsg = iOException.getMessage();
            n = -2003;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                servletProvider.closeOutputStream();
            }
            catch (IOException iOException) {
                this.errorMsg = iOException.getMessage();
                n = -2003;
            }
        }
        if (n == 0) {
            CommUtil.deleteDir(string + string3);
        }
        return n;
    }

    private Map<String, String> getQueryParameters(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        String[] stringArray = string.split("&");
        if (stringArray != null && stringArray.length > 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                String string3 = stringArray2[0];
                String string4 = "";
                if (stringArray2.length > 1) {
                    string4 = stringArray2[1];
                }
                hashMap.put(string3, string4);
            }
            return hashMap;
        }
        return null;
    }

    private boolean isContainSecureCharacter(String string) {
        Pattern pattern = Pattern.compile("(?i)(" + this.securityPattern + "){1,}");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private String containSecureCharacter2(String string) {
        Pattern pattern = Pattern.compile("(?i)(" + this.securityPattern2 + "){1,}");
        Matcher matcher = pattern.matcher(string);
        String string2 = "";
        if (matcher.find()) {
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + matcher.group();
        }
        return string2;
    }

    private int sendImportError(ServletProvider servletProvider, int n, String string, GridImportContext gridImportContext) throws Exception {
        PlatformData platformData = new PlatformData();
        VariableList variableList = platformData.getVariableList();
        variableList.add("ErrorCode", n);
        variableList.add("ErrorMsg", string);
        String string2 = gridImportContext.getResponseContentType();
        if (gridImportContext.getCorsResponseType() == 1) {
            this.sendCorsReviseResponse(servletProvider, platformData, string2);
            return 0;
        }
        String string3 = gridImportContext.getUserDomain();
        if (string3 != null && string3.length() > 0) {
            this.sendDomainResponse(servletProvider, platformData, string3, string2);
        } else {
            this.sendCommonResponse(servletProvider, platformData, string2, gridImportContext.isUseHtmlTag());
        }
        return 0;
    }

    public void sendDomainResponse(ServletProvider servletProvider, PlatformData platformData, String string, String string2) throws Exception {
        servletProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)servletProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        DataSerializer dataSerializer = this.getImportDataSerializer(string2);
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("js");
        xeniEncoder.encodeTo(outputStreamWriter, "<html><script>document.domain = \"" + string + "\";</script>");
        dataSerializer.writeData((Writer)outputStreamWriter, platformData, null, "UTF-8");
        xeniEncoder.encodeTo(outputStreamWriter, "</html>");
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }

    private void sendCommonResponse(ServletProvider servletProvider, PlatformData platformData, String string, boolean bl) throws IOException, PlatformException {
        servletProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)servletProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        DataSerializer dataSerializer = this.getImportDataSerializer(string);
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("js");
        if (bl) {
            xeniEncoder.encodeTo(outputStreamWriter, "<!--[if lt IE 9]><comment><![endif]--><noscript>");
        }
        dataSerializer.writeData((Writer)outputStreamWriter, platformData, null, "UTF-8");
        if (bl) {
            xeniEncoder.encodeTo(outputStreamWriter, "</noscript></comment>");
        }
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }

    private void sendCorsReviseResponse(ServletProvider servletProvider, PlatformData platformData, String string) throws Exception {
        DataSerializer dataSerializer = this.getImportDataSerializer(string);
        servletProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)servletProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("js");
        xeniEncoder.encodeTo(outputStreamWriter, "<script type=\"text/javascript\">");
        xeniEncoder.encodeTo(outputStreamWriter, "var retValue = \"\";");
        xeniEncoder.encodeTo(outputStreamWriter, "window.onload = function() { ");
        xeniEncoder.encodeTo(outputStreamWriter, "if (window.addEventListener) { ");
        xeniEncoder.encodeTo(outputStreamWriter, "window.addEventListener (\"message\", OnMessage, false); }");
        xeniEncoder.encodeTo(outputStreamWriter, "else { ");
        xeniEncoder.encodeTo(outputStreamWriter, "if (window.attachEvent) { ");
        xeniEncoder.encodeTo(outputStreamWriter, "window.attachEvent(\"onmessage\", OnMessage); }");
        xeniEncoder.encodeTo(outputStreamWriter, " } }; ");
        xeniEncoder.encodeTo(outputStreamWriter, "function OnMessage (event) { ");
        xeniEncoder.encodeTo(outputStreamWriter, "message = `");
        StringWriter stringWriter = new StringWriter();
        dataSerializer.writeData((Writer)stringWriter, platformData, null, "UTF-8");
        xeniEncoder.encodeTo(outputStreamWriter, stringWriter.toString().replace("`", "\\`").replace("${", "\\${"));
        xeniEncoder.encodeTo(outputStreamWriter, "`;");
        xeniEncoder.encodeTo(outputStreamWriter, "message = event.data + message;");
        xeniEncoder.encodeTo(outputStreamWriter, "event.source.postMessage (message, event.origin); }");
        xeniEncoder.encodeTo(outputStreamWriter, "</script>");
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }

    private boolean isValidFileName(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        if (!(string2.length() > 0 && ("xls".equalsIgnoreCase(string2) || "xlsx".equalsIgnoreCase(string2) || "cell".equalsIgnoreCase(string2) || "csv".equalsIgnoreCase(string2) || "xlsm".equalsIgnoreCase(string2) || "txt".equalsIgnoreCase(string2)))) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.invalid.filename", string);
            return false;
        }
        String string3 = this.containSecureCharacter2(string);
        if (string3.length() > 0) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.violate.security") + "[" + string3 + "]";
            return false;
        }
        return true;
    }

    private String getResponsePlatformType(String string) {
        String string2 = "PlatformSsv";
        String string3 = XeniProperties.getStringProperty(string);
        if (string3 != null) {
            if ("xml".equalsIgnoreCase(string3)) {
                string2 = "PlatformXml";
            } else if ("json".equalsIgnoreCase(string3)) {
                string2 = "PlatformJson";
            } else if ("binary".equalsIgnoreCase(string3)) {
                string2 = "PlatformBinary";
            }
        }
        return string2;
    }

    private DataSerializer getImportDataSerializer(String string) {
        Object object = null;
        object = "csv".equalsIgnoreCase(string) ? new PlatformCsvDataSerializer() : ("xml".equalsIgnoreCase(string) ? new PlatformXmlDataSerializer() : ("json".equalsIgnoreCase(string) ? new PlatformJsonDataSerializer() : new PlatformSsvDataSerializer()));
        return object;
    }

    private String getHeaderContentType(String string) {
        String string2 = "text/html;charset=UTF-8";
        if ("ssv".equalsIgnoreCase(string)) {
            string2 = "text/plain;charset=UTF-8";
        } else if ("xml".equalsIgnoreCase(string)) {
            string2 = "text/xml;charset=UTF-8";
        } else if ("json".equalsIgnoreCase(string)) {
            string2 = "application/json;charset=UTF-8";
        }
        return string2;
    }

    private void sendPartData(VariableList variableList, GridImportContext gridImportContext, int n) throws IOException, PlatformException {
        StringWriter stringWriter;
        XeniUtils.XeniEncoder xeniEncoder = XeniUtils.getXeniEncoder("js");
        if (n < 2) {
            stringWriter = new StringWriter();
            CommUtil.writePartDataHead(stringWriter, gridImportContext);
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), stringWriter.toString());
        }
        stringWriter = new StringWriter();
        CommUtil.writePartDataVariableList(stringWriter, gridImportContext, variableList);
        if (gridImportContext.getCorsResponseType() == 1) {
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), stringWriter.toString());
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), "`;");
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), "message = event.data + message;");
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), "event.source.postMessage (message, event.origin); }");
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), "</script>");
        } else {
            xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), stringWriter.toString());
            if (gridImportContext.getUserDomain() != null) {
                xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), "</html>");
            } else if (gridImportContext.isUseHtmlTag()) {
                xeniEncoder.encodeTo(gridImportContext.getResponseWriter(), "</noscript></comment>");
            }
        }
        stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
    }
}

