/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.util;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CommUtil {
    public static String generateSerialNo() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");
        String string = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        int n = new SecureRandom().nextInt();
        String string2 = String.format("%s%02d", string, n);
        return string2;
    }

    public static boolean isNumber(String string) {
        if (string.length() < 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getDataRange(String string, int[] nArray, int[] nArray2) {
        if (string == null || "".equals(string)) {
            return null;
        }
        String[] stringArray = string.split("\\!");
        String string2 = stringArray[0];
        if (stringArray.length > 1 && !"".equals(stringArray[1])) {
            String[] stringArray2 = stringArray[1].split("\\:");
            CommUtil.getRangeIndex(stringArray2[0], nArray);
            if (stringArray2.length > 1) {
                CommUtil.getRangeIndex(stringArray2[1], nArray2);
            }
        }
        return string2;
    }

    public static void getRangeIndex(String string, int[] nArray) {
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                string3 = string.substring(i);
                break;
            }
            string2 = string2 + c;
        }
        if (!"".equals(string2)) {
            nArray[0] = CommUtil.getColumnIndexFormChars(string2);
        }
        if (!"".equals(string3)) {
            nArray[1] = Integer.parseInt(string3) - 1;
        }
    }

    public static int getColumnIndexFormChars(String string) {
        int n = 0;
        int n2 = 1;
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            n += (cArray[i] - 65 + 1) * n2;
            n2 *= 26;
        }
        return --n;
    }

    public static DataSet getDatasetImportResponse() {
        DataSet dataSet = new DataSet("IMPORTFILES");
        dataSet.addColumn("filename", 2);
        dataSet.addColumn("filesize", 5);
        dataSet.addColumn("filetype", 2);
        dataSet.addColumn("filepath", 2);
        dataSet.addColumn("importid", 2);
        dataSet.newRow();
        return dataSet;
    }

    public static DataSet getDatasetExportResponse(DataSet dataSet) {
        DataSet dataSet2 = new DataSet("RESPONSE");
        dataSet2.addColumn("command", 2, 32);
        dataSet2.addColumn("type", 3);
        dataSet2.addColumn("item", 2, 256);
        dataSet2.addColumn("instanceid", 2, 256);
        dataSet2.addColumn("lastseq", 3);
        dataSet2.addColumn("eof", 4);
        dataSet2.addColumn("url", 2, 1024);
        int n = dataSet2.newRow();
        dataSet2.set(n, "command", dataSet.getString(0, "command"));
        dataSet2.set(n, "type", dataSet.getInt(0, "type"));
        dataSet2.set(n, "item", dataSet.getString(0, "item"));
        dataSet2.set(n, "instanceid", dataSet.getString(0, "instanceid"));
        dataSet2.set(n, "lastseq", dataSet.getInt(0, "seq"));
        dataSet2.set(n, "eof", dataSet.getBoolean(0, "eof"));
        dataSet2.set(n, "url", "");
        return dataSet2;
    }

    public static void deleteDir(String string) throws IOException {
        File file = null;
        File file2 = XeniUtils.getXeniFileHandler(string).toFile();
        file = file2.isDirectory() ? file2 : file2.getParentFile();
        if (file != null) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    file3.delete();
                }
            }
            file.delete();
        }
    }

    public static void writePartDataHead(StringWriter stringWriter, GridImportContext gridImportContext) throws PlatformException {
        if (gridImportContext.getCorsResponseType() == 1) {
            stringWriter.write("<script type=\"text/javascript\">");
            stringWriter.write("var retValue = \"\";");
            stringWriter.write("window.onload = function() { ");
            stringWriter.write("if (window.addEventListener) { ");
            stringWriter.write("window.addEventListener (\"message\", OnMessage, false); }");
            stringWriter.write("else { ");
            stringWriter.write("if (window.attachEvent) { ");
            stringWriter.write("window.attachEvent(\"onmessage\", OnMessage); }");
            stringWriter.write(" } }; ");
            stringWriter.write("function OnMessage (event) { ");
            stringWriter.write("message = `");
        } else if (gridImportContext.getUserDomain() != null) {
            stringWriter.write("<html><script>document.domain = \"" + gridImportContext.getUserDomain() + "\";</script>");
        } else if (gridImportContext.isUseHtmlTag()) {
            stringWriter.write("<!--[if lt IE 9]><comment><![endif]--><noscript>");
        }
        gridImportContext.getPartDataSerializer().setWriter((Writer)stringWriter);
        gridImportContext.getPartDataSerializer().writeHead();
    }

    public static void writePartDataTail(StringWriter stringWriter, GridImportContext gridImportContext) throws PlatformException {
        gridImportContext.getPartDataSerializer().setWriter((Writer)stringWriter);
        gridImportContext.getPartDataSerializer().writeTail();
        if (gridImportContext.getCorsResponseType() == 1) {
            stringWriter.write("`;");
            stringWriter.write("message = event.data + message;");
            stringWriter.write("event.source.postMessage (message, event.origin); }");
            stringWriter.write("</script>");
        } else if (gridImportContext.getUserDomain() != null) {
            stringWriter.write("</html>");
        } else if (gridImportContext.isUseHtmlTag()) {
            stringWriter.write("</noscript></comment>");
        }
    }

    public static void writePartDataVariableList(StringWriter stringWriter, GridImportContext gridImportContext, VariableList variableList) throws PlatformException {
        StringWriter stringWriter2 = null;
        if (gridImportContext.getCorsResponseType() == 1) {
            stringWriter2 = new StringWriter();
            gridImportContext.getPartDataSerializer().setWriter((Writer)stringWriter2);
        } else {
            gridImportContext.getPartDataSerializer().setWriter((Writer)stringWriter);
        }
        for (int i = 0; i < variableList.size(); ++i) {
            gridImportContext.getPartDataSerializer().writeVariable(variableList.get(i));
        }
        if (gridImportContext.getCorsResponseType() == 1) {
            stringWriter.append(stringWriter2.toString().replace("`", "\\`").replace("${", "\\${"));
        }
    }

    public static void writePartDataDataset(StringWriter stringWriter, GridImportContext gridImportContext, DataSet dataSet) throws PlatformException {
        StringWriter stringWriter2 = null;
        if (gridImportContext.getCorsResponseType() == 1) {
            stringWriter2 = new StringWriter();
            gridImportContext.getPartDataSerializer().setWriter((Writer)stringWriter2);
        } else {
            gridImportContext.getPartDataSerializer().setWriter((Writer)stringWriter);
        }
        gridImportContext.getPartDataSerializer().writeDataSet(dataSet);
        dataSet.clearData();
        if (gridImportContext.getCorsResponseType() == 1) {
            stringWriter.write(stringWriter2.toString().replace("`", "\\`").replace("${", "\\${"));
        }
    }
}

