/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class HSSFEventModelHandlerBody
extends AbortableHSSFListener {
    private static final Log logger = LogFactory.getLog(HSSFEventModelHandlerBody.class);
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private boolean outputFormulaValues = true;
    private SSTRecord sstRecord;
    private XeniDataFormatter formatter;
    private String sSheetName;
    private DataSet dsResult;
    private int nSheetIdx = 0;
    private int nCurrExlRow = -1;
    private boolean bFoundSheet = false;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private final Map<Integer, FormatRecord> customFormatRecords = new Hashtable<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> extFormatRecords = new ArrayList<ExtendedFormatRecord>();
    private GridImportContext importContext;
    private ExcelDimensionInfo dimInfo;

    public HSSFEventModelHandlerBody(DataSet dataSet, String string, ExcelDimensionInfo excelDimensionInfo, GridImportContext gridImportContext) {
        this.dsResult = dataSet;
        this.sSheetName = string;
        this.dimInfo = excelDimensionInfo;
        this.formatter = new XeniDataFormatter();
        this.importContext = gridImportContext;
        if (this.dimInfo.getUserStartColumn() >= 0) {
            this.dimInfo.setStartColumn(this.dimInfo.getUserStartColumn());
        }
        if (this.dimInfo.getUserEndColumn() >= 0) {
            this.dimInfo.setEndColumn(this.dimInfo.getUserEndColumn());
        }
        if (this.dimInfo.getUserStartRow() >= 0) {
            this.dimInfo.setStartRow(this.dimInfo.getUserStartRow());
        }
        if (this.dimInfo.getUserEndRow() >= 0) {
            this.dimInfo.setEndRow(this.dimInfo.getUserEndRow());
        }
    }

    public void excute(POIFSFileSystem pOIFSFileSystem) throws IOException {
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords((HSSFListener)this);
        hSSFEventFactory.processWorkbookEvents(hSSFRequest, pOIFSFileSystem.getRoot());
    }

    public short abortableProcessRecord(Record record) throws HSSFUserException {
        short s = record.getSid();
        if (!this.bFoundSheet && s != 1054 && s != 224 && s != 133 && s != 2057 && s != 10 && s != 252) {
            return 0;
        }
        short s2 = 0;
        int n = -1;
        int n2 = -1;
        String string = null;
        switch (s) {
            case 1054: {
                FormatRecord formatRecord = (FormatRecord)record;
                this.customFormatRecords.put(formatRecord.getIndexCode(), formatRecord);
                break;
            }
            case 224: {
                ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)record;
                this.extFormatRecords.add(extendedFormatRecord);
                break;
            }
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord bOFRecord = (BOFRecord)record;
                if (bOFRecord.getType() != 16) break;
                this.findSheet();
                break;
            }
            case 512: {
                DimensionsRecord dimensionsRecord = (DimensionsRecord)record;
                s2 = this.setDimension(dimensionsRecord);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 10: {
                if (!this.bFoundSheet) break;
                s2 = -1;
                break;
            }
            case 513: {
                BlankRecord blankRecord = (BlankRecord)record;
                n = blankRecord.getRow();
                n2 = blankRecord.getColumn();
                string = "";
                break;
            }
            case 6: {
                FormulaRecord formulaRecord = (FormulaRecord)record;
                n = formulaRecord.getRow();
                n2 = formulaRecord.getColumn();
                string = this.getFormulaValue(formulaRecord);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord stringRecord = (StringRecord)record;
                string = stringRecord.getString();
                n = this.nextRow;
                n2 = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord labelRecord = (LabelRecord)record;
                n = labelRecord.getRow();
                n2 = labelRecord.getColumn();
                string = labelRecord.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                n = labelSSTRecord.getRow();
                n2 = labelSSTRecord.getColumn();
                if (this.sstRecord == null) {
                    string = "";
                    break;
                }
                string = this.sstRecord.getString(labelSSTRecord.getSSTIndex()).toString();
                break;
            }
            case 515: {
                NumberRecord numberRecord = (NumberRecord)record;
                n = numberRecord.getRow();
                n2 = numberRecord.getColumn();
                string = this.formatNumberDateCell((CellValueRecordInterface)numberRecord, numberRecord.getValue());
                break;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                n = boolErrRecord.getRow();
                n2 = boolErrRecord.getColumn();
                byte by = boolErrRecord.getErrorValue();
                string = by == 0 ? "FALSE" : "TRUE";
                break;
            }
            case 520: {
                break;
            }
        }
        if (s2 > -1 && n >= 0 && n2 >= 0) {
            s2 = this.setCellValue(n, n2, string);
        }
        return s2;
    }

    private void findSheet() {
        if (this.sSheetName == null || "".equals(this.sSheetName)) {
            this.bFoundSheet = true;
        } else {
            String string = this.boundSheetRecords.get(this.nSheetIdx).getSheetname();
            if (string.equalsIgnoreCase(this.sSheetName)) {
                this.bFoundSheet = true;
            }
        }
        ++this.nSheetIdx;
    }

    private short setDimension(DimensionsRecord dimensionsRecord) throws HSSFUserException {
        long l;
        long l2 = Long.parseLong(XeniProperties.getStringProperty("xeni.import.cell.max", "-1"));
        if (l2 > 0L && (l = (long)(this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn() + 1) * (long)(this.dimInfo.getEndRow() - this.dimInfo.getStartRow() + 1)) > l2) {
            throw new HSSFUserException("Maximum number of cells exceeded. (" + l + ":" + l2 + ")");
        }
        return 0;
    }

    public boolean isFoundSheet() {
        return this.bFoundSheet;
    }

    private String getFormulaValue(FormulaRecord formulaRecord) {
        String string = "";
        if (this.outputFormulaValues) {
            int n = formulaRecord.getCachedResultType();
            if (n == 1) {
                this.outputNextStringRecord = true;
                this.nextRow = formulaRecord.getRow();
                this.nextColumn = formulaRecord.getColumn();
            } else {
                string = n == 4 ? (formulaRecord.getCachedBooleanValue() ? "TRUE" : "FALSE") : (n == 5 ? "ERROR:" + formulaRecord.getCachedErrorValue() : this.formatNumberDateCell((CellValueRecordInterface)formulaRecord, formulaRecord.getValue()));
            }
        } else {
            string = HSSFFormulaParser.toFormulaString(null, (Ptg[])formulaRecord.getParsedExpression());
        }
        return string;
    }

    private String formatNumberDateCell(CellValueRecordInterface cellValueRecordInterface, double d) {
        int n = this.getFormatIndex(cellValueRecordInterface);
        String string = this.getFormatString(n);
        String string2 = "";
        string2 = this.formatter.formatRawCellContents(d, n, string, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
        string2 = string2.replaceAll("[\"*? ]", "");
        return string2;
    }

    private int getFormatIndex(CellValueRecordInterface cellValueRecordInterface) {
        ExtendedFormatRecord extendedFormatRecord = this.extFormatRecords.get(cellValueRecordInterface.getXFIndex());
        if (extendedFormatRecord == null) {
            return -1;
        }
        return extendedFormatRecord.getFormatIndex();
    }

    private String getFormatString(int n) {
        if (n == -1) {
            return null;
        }
        String string = null;
        if (n == 14) {
            string = XeniBuiltinFormats.getBuiltinFormat(n, null);
        } else if (n >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord formatRecord = this.customFormatRecords.get(n);
            if (formatRecord != null) {
                string = formatRecord.getFormatString();
            }
        } else {
            string = XeniBuiltinFormats.getBuiltinFormat(n, null);
        }
        if (string == null) {
            string = XeniBuiltinFormats.getBuiltinFormat(n, null);
        }
        return string;
    }

    private boolean isValidDimension(int n, int n2) {
        return n >= this.dimInfo.getStartRow() && n2 >= this.dimInfo.getStartColumn() && n2 <= this.dimInfo.getEndColumn();
    }

    private void setRowRecordIndex(int n) {
        if (this.nCurrExlRow == n) {
            return;
        }
        if (this.nCurrExlRow >= 0 && n - this.nCurrExlRow > 1) {
            for (int i = this.nCurrExlRow + 1; i < n && n <= this.dimInfo.getEndRow(); ++i) {
                this.dsResult.newRow();
            }
        }
        if (n >= this.dimInfo.getStartRow() && n <= this.dimInfo.getEndRow()) {
            this.dsResult.newRow();
        }
        this.nCurrExlRow = n;
    }

    private short setCellValue(int n, int n2, String string) {
        if (n > this.dimInfo.getEndRow()) {
            return -1;
        }
        if (!this.isValidDimension(n, n2)) {
            return 0;
        }
        this.setRowRecordIndex(n);
        if (this.importContext.getCorsResponseType() == 1 && string != null) {
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\"", "\\\\\"");
            string = string.replaceAll("\\\\", "\\\\\\\\");
        }
        if (string != null) {
            this.dsResult.set(n - this.dimInfo.getStartRow(), n2 - this.dimInfo.getStartColumn(), string);
        }
        return 0;
    }
}

