/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class HSSFEventModelHandlerHead
extends AbortableHSSFListener {
    private static final Log logger = LogFactory.getLog(HSSFEventModelHandlerHead.class);
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private boolean outputFormulaValues = true;
    private SSTRecord sstRecord;
    private XeniDataFormatter formatter;
    private commandType cmdType;
    private String sSheetName = null;
    private int nCurrDsCol = 0;
    private int nPreColIndex = 0;
    private DataSet dsResult = null;
    private int nSheetIdx = 0;
    private boolean bFoundSheet = false;
    private boolean bUserDimensin = false;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private final Map<Integer, FormatRecord> customFormatRecords = new Hashtable<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> extFormatRecords = new ArrayList<ExtendedFormatRecord>();
    private GridImportContext importContext;
    private ExcelDimensionInfo dimInfo;

    public HSSFEventModelHandlerHead(DataSet dataSet, String string, commandType commandType2, ExcelDimensionInfo excelDimensionInfo, GridImportContext gridImportContext) {
        this.dsResult = dataSet;
        this.sSheetName = string;
        this.importContext = gridImportContext;
        this.cmdType = commandType2;
        this.dimInfo = excelDimensionInfo;
        this.formatter = new XeniDataFormatter();
        this.bUserDimensin = excelDimensionInfo.isUserDimension();
    }

    public void excute(POIFSFileSystem pOIFSFileSystem) throws IOException {
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords((HSSFListener)this);
        hSSFEventFactory.processWorkbookEvents(hSSFRequest, pOIFSFileSystem.getRoot());
    }

    public short abortableProcessRecord(Record record) throws HSSFUserException {
        short s = record.getSid();
        if (!this.bFoundSheet && s != 1054 && s != 224 && s != 133 && s != 2057 && s != 10 && s != 252) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string = null;
        switch (s) {
            case 1054: {
                FormatRecord formatRecord = (FormatRecord)record;
                this.customFormatRecords.put(formatRecord.getIndexCode(), formatRecord);
                break;
            }
            case 224: {
                ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)record;
                this.extFormatRecords.add(extendedFormatRecord);
                break;
            }
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord bOFRecord = (BOFRecord)record;
                if (bOFRecord.getType() != 16) break;
                this.findSheet();
                break;
            }
            case 512: {
                DimensionsRecord dimensionsRecord = (DimensionsRecord)record;
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 10: {
                if (this.cmdType == commandType.SHEETLIST) {
                    n = this.getSheetList();
                    break;
                }
                if (!this.bFoundSheet) break;
                this.addDefaultColumn();
                n = -1;
                break;
            }
            case 513: {
                BlankRecord blankRecord = (BlankRecord)record;
                n2 = blankRecord.getRow();
                n3 = blankRecord.getColumn();
                string = "";
                break;
            }
            case 6: {
                FormulaRecord formulaRecord = (FormulaRecord)record;
                n2 = formulaRecord.getRow();
                n3 = formulaRecord.getColumn();
                string = this.getFormulaValue(formulaRecord);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord stringRecord = (StringRecord)record;
                string = stringRecord.getString();
                n2 = this.nextRow;
                n3 = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord labelRecord = (LabelRecord)record;
                n2 = labelRecord.getRow();
                n3 = labelRecord.getColumn();
                string = labelRecord.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                n2 = labelSSTRecord.getRow();
                n3 = labelSSTRecord.getColumn();
                if (this.sstRecord == null) {
                    string = "";
                    break;
                }
                string = this.sstRecord.getString(labelSSTRecord.getSSTIndex()).toString();
                break;
            }
            case 515: {
                NumberRecord numberRecord = (NumberRecord)record;
                n2 = numberRecord.getRow();
                n3 = numberRecord.getColumn();
                string = this.formatNumberDateCell((CellValueRecordInterface)numberRecord, numberRecord.getValue());
                break;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                n2 = boolErrRecord.getRow();
                n3 = boolErrRecord.getColumn();
                byte by = boolErrRecord.getErrorValue();
                string = by == 0 ? "FALSE" : "TRUE";
                break;
            }
            case 520: {
                break;
            }
        }
        if (n > -1 && n2 >= 0 && n3 >= 0) {
            n = this.setCellValue(n2, n3, string);
        }
        return (short)n;
    }

    private void addDefaultColumn() {
        if (!this.bUserDimensin) {
            for (int i = 0; i <= this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn(); ++i) {
                this.dsResult.addColumn("Column" + i, 2, 256);
            }
        }
    }

    private String getFormulaValue(FormulaRecord formulaRecord) {
        String string = "";
        if (this.outputFormulaValues) {
            int n = formulaRecord.getCachedResultType();
            if (n == 1) {
                this.outputNextStringRecord = true;
                this.nextRow = formulaRecord.getRow();
                this.nextColumn = formulaRecord.getColumn();
            } else {
                string = n == 4 ? (formulaRecord.getCachedBooleanValue() ? "TRUE" : "FALSE") : (n == 5 ? "ERROR:" + formulaRecord.getCachedErrorValue() : this.formatNumberDateCell((CellValueRecordInterface)formulaRecord, formulaRecord.getValue()));
            }
        } else {
            string = HSSFFormulaParser.toFormulaString(null, (Ptg[])formulaRecord.getParsedExpression());
        }
        return string;
    }

    private void findSheet() {
        if (this.sSheetName == null || "".equals(this.sSheetName)) {
            this.bFoundSheet = true;
        } else {
            String string = this.boundSheetRecords.get(this.nSheetIdx).getSheetname();
            if (string.equalsIgnoreCase(this.sSheetName)) {
                this.bFoundSheet = true;
            }
        }
        ++this.nSheetIdx;
    }

    public boolean isFoundSheet() {
        return this.bFoundSheet;
    }

    private String formatNumberDateCell(CellValueRecordInterface cellValueRecordInterface, double d) {
        int n = this.getFormatIndex(cellValueRecordInterface);
        String string = this.getFormatString(n);
        String string2 = "";
        string2 = this.formatter.formatRawCellContents(d, n, string, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
        string2 = string2.replaceAll("[\"*? ]", "");
        return string2;
    }

    private int getFormatIndex(CellValueRecordInterface cellValueRecordInterface) {
        ExtendedFormatRecord extendedFormatRecord = this.extFormatRecords.get(cellValueRecordInterface.getXFIndex());
        if (extendedFormatRecord == null) {
            return -1;
        }
        return extendedFormatRecord.getFormatIndex();
    }

    private String getFormatString(int n) {
        if (n == -1) {
            return null;
        }
        String string = null;
        if (n == 14) {
            string = XeniBuiltinFormats.getBuiltinFormat(n, null);
        } else if (n >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord formatRecord = this.customFormatRecords.get(n);
            if (formatRecord != null) {
                string = formatRecord.getFormatString();
            }
        } else {
            string = XeniBuiltinFormats.getBuiltinFormat(n, null);
        }
        if (string == null) {
            string = XeniBuiltinFormats.getBuiltinFormat(n, null);
        }
        return string;
    }

    private short getSheetList() {
        for (int i = 0; i < this.boundSheetRecords.size(); ++i) {
            int n = this.dsResult.newRow();
            BoundSheetRecord boundSheetRecord = this.boundSheetRecords.get(i);
            this.dsResult.set(n, "number", i + 1);
            this.dsResult.set(n, "sheetname", boundSheetRecord == null ? "" : boundSheetRecord.getSheetname());
        }
        return -1;
    }

    private void setDimension(int n, int n2) {
        if (this.dimInfo.getStartRow() < 0) {
            this.dimInfo.setStartRow(n);
        }
        this.dimInfo.setEndRow(n);
        if (this.dimInfo.getStartColumn() < 0) {
            this.dimInfo.setStartColumn(n2);
        } else if (this.dimInfo.getStartColumn() > n2) {
            this.dimInfo.setStartColumn(n2);
        }
        if (this.dimInfo.getEndColumn() < 0) {
            this.dimInfo.setEndColumn(n2);
        } else if (this.dimInfo.getEndColumn() < n2) {
            this.dimInfo.setEndColumn(n2);
        }
    }

    private boolean isValidDimension(int n, int n2) {
        if (n < 0 || this.dimInfo.getUserStartRow() >= 0 && this.dimInfo.getUserStartRow() > n) {
            return false;
        }
        if (this.dimInfo.getUserEndRow() >= 0 && this.dimInfo.getUserEndRow() < n) {
            return false;
        }
        if (this.dimInfo.getUserStartColumn() >= 0 && this.dimInfo.getUserStartColumn() > n2) {
            return false;
        }
        return this.dimInfo.getUserEndColumn() < 0 || this.dimInfo.getUserEndColumn() >= n2;
    }

    private short setCellValue(int n, int n2, String string) {
        this.setDimension(n, n2);
        if (!this.bUserDimensin || !this.isValidDimension(n, n2)) {
            return 0;
        }
        if (this.importContext.getCorsResponseType() == 1 && string != null) {
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\"", "\\\\\"");
            string = string.replaceAll("\\\\", "\\\\\\\\");
        }
        int n3 = n2 - this.nPreColIndex;
        this.nPreColIndex = n2;
        if (this.nCurrDsCol != 0 && n3 > 1) {
            for (int i = 1; i < n3; ++i) {
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        }
        if (string == null || "".equals(string)) {
            this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
        } else {
            this.dsResult.addColumn(string, 2, 256);
        }
        ++this.nCurrDsCol;
        return 0;
    }

    static enum commandType {
        SHEETLIST,
        HEAD,
        BODY;

    }
}

