/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.spring.dao;

import com.nexacro.spring.dao.DbColumn;
import com.nexacro.spring.data.metadata.NexacroMetaData;
import com.nexacro.spring.data.metadata.support.BeanMetaData;
import com.nexacro.spring.data.metadata.support.MapMetaData;
import com.nexacro.spring.data.metadata.support.UnsupportedMetaData;
import com.nexacro.spring.data.support.NexacroConverterHelper;
import com.nexacro.xapi.data.datatype.DataType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ClassUtils;

public abstract class DbMetaDataGathererUtil {
    public static NexacroMetaData generateMetaDataFromClass(Class clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            if (ClassUtils.isPrimitiveOrWrapper((Class)clazz)) {
                return new UnsupportedMetaData(null);
            }
            return new BeanMetaData(clazz);
        }
        return null;
    }

    public static MapMetaData generateMetaDataFromDbColumns(List<DbColumn> dbColumns) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        for (DbColumn column : dbColumns) {
            String name = column.getName();
            DataType dataType = column.getDataType();
            Object defaultValue = NexacroConverterHelper.getDefaultMetaDataValue((DataType)dataType);
            mapData.put(name, defaultValue);
        }
        return new MapMetaData(mapData);
    }
}

