/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.spring.dao;

import com.nexacro.spring.dao.Dbms;
import com.nexacro.spring.dao.DbmsProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.executor.BaseExecutor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class DbVendorsProvider
implements DbmsProvider {
    private static final Log log = LogFactory.getLog(BaseExecutor.class);
    private Map<String, Dbms> dbvendors;

    public Map<String, Dbms> getDbvendors() {
        return this.dbvendors;
    }

    public void setDbvendors(Map<String, Dbms> dbvendors) {
        this.dbvendors = dbvendors;
    }

    @Override
    public Dbms getDbms(Connection conn) {
        if (conn == null) {
            throw new NullPointerException("Connection cannot be null");
        }
        try {
            String productName = this.getDataBaseProductName(conn);
            if (this.dbvendors != null) {
                Dbms dbms = this.dbvendors.get(productName);
                if (dbms == null) {
                    throw new NullPointerException("Dbms cannot be null");
                }
                return dbms;
            }
        }
        catch (SQLException e) {
            log.error("Could not get a Dbms from Connection", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dbms getDbms(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource cannot be null");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Dbms dbms = this.getDbms(connection);
            return dbms;
        }
        catch (SQLException e) {
            log.error("Could not get a Dbms from dataSource", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    private String getDataBaseProductName(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        return metaData.getDatabaseProductName();
    }
}

