/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.jakarta.dao.dbms;

import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.uiadapter.jakarta.dao.AbstractDbms;
import com.nexacro.uiadapter.jakarta.dao.DbColumn;

public class EnterpriseDB
extends AbstractDbms {
    @Override
    public void handleColumnDataType(DbColumn column) {
        if (column == null) {
            return;
        }
        String vendorsTypeName = column.getVendorsTypeName();
        if ("BPCHAR".equals(vendorsTypeName) || "VARCHAR".equals(vendorsTypeName) || "BYTEA".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("BOOL".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BOOLEAN);
        } else if ("INT4".equals(vendorsTypeName) || "INT2".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.INT);
        } else if ("INT8".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.LONG);
        } else if ("FLOAT8".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DOUBLE);
        } else if ("FLOAT4".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.FLOAT);
        } else if ("NUMERIC".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BIG_DECIMAL);
        } else if ("DATE".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DATE);
        } else if (column.getVendorsTypeName().startsWith("TIME")) {
            column.setDataType(PlatformDataType.DATE_TIME);
            column.setSize(6);
            column.setDecimalDigit(null);
        }
    }
}

