/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.jakarta.dao.dbms;

import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.uiadapter.jakarta.dao.AbstractDbms;
import com.nexacro.uiadapter.jakarta.dao.DbColumn;

public class Postgre
extends AbstractDbms {
    @Override
    public void handleColumnDataType(DbColumn column) {
        if (column == null) {
            return;
        }
        String vendorsTypeName = column.getVendorsTypeName();
        if ("char".equals(vendorsTypeName) || "bpchar".equals(vendorsTypeName) || "varchar".equals(vendorsTypeName) || "text".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("bool".equals(vendorsTypeName) || "bit".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BOOLEAN);
        } else if ("int4".equals(vendorsTypeName) || "int2".equals(vendorsTypeName) || "serial".equals(vendorsTypeName) || "smallserial".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.INT);
        } else if ("int8".equals(vendorsTypeName) || "bigserial".equals(vendorsTypeName) || "oid".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.LONG);
        } else if ("float8".equals(vendorsTypeName) || "money".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DOUBLE);
        } else if ("float4".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.FLOAT);
        } else if ("numeric".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BIG_DECIMAL);
        } else if ("date".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DATE);
        } else if (column.getVendorsTypeName().startsWith("time")) {
            column.setDataType(PlatformDataType.DATE_TIME);
            column.setSize(6);
            column.setDecimalDigit(null);
        } else if ("xml".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("bytea".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BLOB);
        }
    }
}

