/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.jakarta.dao.jdbc;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.uiadapter.jakarta.core.data.NexacroFirstRowHandler;
import com.nexacro.uiadapter.jakarta.dao.DbColumn;
import com.nexacro.uiadapter.jakarta.dao.Dbms;
import com.nexacro.uiadapter.jakarta.dao.NexacroFirstRowException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class JdbcRowHandler
implements RowCallbackHandler {
    private static final int DEFAULT_FIRSTROW_COUNT = 1000;
    private Dbms dbms;
    private NexacroFirstRowHandler firstRowHandler;
    private String resultName;
    private int firstRowCount;
    private DataSet currentDataSet;
    private int currentCount = 0;

    public JdbcRowHandler(Dbms dbms, NexacroFirstRowHandler firstRowHandler, String resultName, int firstRowCount) {
        this.dbms = dbms;
        this.firstRowHandler = firstRowHandler;
        this.resultName = resultName;
        this.firstRowCount = firstRowCount;
        if (this.firstRowCount <= 0) {
            this.firstRowCount = 1000;
        }
    }

    public void processRow(ResultSet rs) throws SQLException {
        this.prepareDataSet(rs);
        this.addRow(rs);
        try {
            ++this.currentCount;
            if (this.currentCount % this.firstRowCount == 0) {
                this.sendDataSet();
            }
        }
        catch (PlatformException e) {
            throw new SQLException("could not send data. e=" + e.getMessage());
        }
    }

    public void sendRemainData() {
        DataSet remainDataSet = this.getDataSet();
        if (remainDataSet != null && remainDataSet.getRowCount() > 0) {
            try {
                this.firstRowHandler.sendDataSet(remainDataSet);
            }
            catch (PlatformException e) {
                throw new NexacroFirstRowException("could not send remain data. e=" + e.getMessage(), e);
            }
        }
    }

    private void sendDataSet() throws PlatformException {
        this.firstRowHandler.sendDataSet(this.currentDataSet);
    }

    private void addRow(ResultSet rs) throws SQLException {
        int newRow = this.currentDataSet.newRow();
        int columnCount = this.currentDataSet.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            Object object = rs.getObject(columnIndex + 1);
            this.currentDataSet.set(newRow, columnIndex, object);
        }
    }

    private void prepareDataSet(ResultSet rs) throws SQLException {
        if (this.currentDataSet != null) {
            return;
        }
        this.currentDataSet = new DataSet(this.resultName != null ? this.resultName : "RESULT0");
        ResultSetMetaData metaData = rs.getMetaData();
        List<DbColumn> dbColumns = this.dbms.getDbColumns(metaData);
        for (DbColumn column : dbColumns) {
            String name = column.getName();
            DataType dataType = column.getDataType();
            int size = column.getSize();
            this.currentDataSet.addColumn(name, dataType, size);
        }
    }

    public DataSet getDataSet() {
        return this.currentDataSet;
    }
}

