package com.nexacro.uiadapter.jakarta.dao.dbms;

import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.uiadapter.jakarta.dao.AbstractDbms;
import com.nexacro.uiadapter.jakarta.dao.DbColumn;

/**
 * <p>Postgre에서 사용되는 데이터 타입과 <code>DataSet</code>의 데이터 타입간의 매핑 정보를 제공한다.
 *
 * @author Tobesoft
 * @since 11.10.2021
 * @version 1.0
 * @see
 */
public class Postgre extends AbstractDbms {

	// Postgre Mappings From SQL/JDBC Data Types to Java Data Types
	// https://www.instaclustr.com/postgresql-data-types-mappings-to-sql-jdbc-and-java-data-types/
	
    @Override
    public void handleColumnDataType(final DbColumn column) {

    	if (column == null) {
            return;
        }
        
        final String vendorsTypeName = column.getVendorsTypeName();
        
        if("char".equals(vendorsTypeName) 
        		|| "bpchar".equals(vendorsTypeName) 
        		|| "varchar".equals(vendorsTypeName) 
        		|| "text".equals(vendorsTypeName) ) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("bool".equals(vendorsTypeName) 
        		|| "bit".equals(vendorsTypeName) ) {
            column.setDataType(PlatformDataType.BOOLEAN);
        } else if ("int4".equals(vendorsTypeName) 
        		|| "int2".equals(vendorsTypeName) 
        		|| "serial".equals(vendorsTypeName) 
        		|| "smallserial".equals(vendorsTypeName) ) {
            column.setDataType(PlatformDataType.INT);
        } else if ("int8".equals(vendorsTypeName) 
        		|| "bigserial".equals(vendorsTypeName) 
        		|| "oid".equals(vendorsTypeName) ) {
            column.setDataType(PlatformDataType.LONG);
        } else if ("float8".equals(vendorsTypeName) 
        		|| "money".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DOUBLE);
        } else if ("float4".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.FLOAT);
        } else if ("numeric".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BIG_DECIMAL);
        } else if ("date".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DATE);
        } else if (column.getVendorsTypeName().startsWith("time")) { 
            column.setDataType(PlatformDataType.DATE_TIME);
            column.setSize(6);
            column.setDecimalDigit(null);
        } else if ("xml".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("bytea".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BLOB);
        }
        // 그 외 Postgre 타입의 경우 자동 변환은 수행하지 않는다.
    }
}
