/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.jakarta.dao;

import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.DataTypeFactory;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.uiadapter.jakarta.dao.DbColumn;
import com.nexacro.uiadapter.jakarta.dao.Dbms;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.mapping.ResultMapping;

public abstract class AbstractDbms
implements Dbms {
    public abstract void handleColumnDataType(DbColumn var1);

    @Override
    public List<DbColumn> getDbColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<DbColumn> columnList = new ArrayList<DbColumn>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            if (columnName == null || columnName.equals("")) {
                columnName = resultSetMetaData.getColumnName(i);
            }
            String vendorsTypeName = resultSetMetaData.getColumnTypeName(i);
            String typeJavaClassName = resultSetMetaData.getColumnClassName(i);
            DataType dataType = DataTypeFactory.getSqlDataType((String)vendorsTypeName);
            if (dataType == null) {
                int javaSqlTypeNumber = resultSetMetaData.getColumnType(i);
                dataType = DataTypeFactory.getSqlDataType((int)javaSqlTypeNumber);
            }
            if ((dataType = DataTypeFactory.getPlatformDataType((DataType)dataType)) == null) {
                dataType = PlatformDataType.UNDEFINED;
            }
            int precision = resultSetMetaData.getPrecision(i);
            int scale = resultSetMetaData.getScale(i);
            int columnSize = resultSetMetaData.getColumnDisplaySize(i);
            DbColumn column = new DbColumn(columnName, dataType, columnSize, vendorsTypeName);
            column.setTypeJavaClassName(typeJavaClassName);
            column.setPrecision(precision);
            column.setScale(scale);
            this.handleColumnDataType(column);
            columnList.add(column);
        }
        return columnList;
    }

    @Override
    public List<DbColumn> getDbColumns(List<ResultMapping> resultMappings) throws SQLException {
        ArrayList<DbColumn> columnList = new ArrayList<DbColumn>();
        int columnCount = resultMappings.size();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = resultMappings.get(i).getColumn();
            String vendorsTypeName = resultMappings.get(i).getJdbcType() != null ? resultMappings.get(i).getJdbcType().name() : "VARCHAR";
            String typeJavaClassName = resultMappings.get(i).getJavaType().getName();
            DataType dataType = DataTypeFactory.getSqlDataType((String)vendorsTypeName);
            if (dataType == null) {
                int javaSqlTypeNumber = 12;
                dataType = DataTypeFactory.getSqlDataType((int)javaSqlTypeNumber);
            }
            if ((dataType = DataTypeFactory.getPlatformDataType((DataType)dataType)) == null) {
                dataType = PlatformDataType.UNDEFINED;
            }
            int precision = 0;
            int scale = 0;
            int columnSize = 256;
            DbColumn column = new DbColumn(columnName, dataType, columnSize, vendorsTypeName);
            column.setTypeJavaClassName(typeJavaClassName);
            column.setPrecision(precision);
            column.setScale(scale);
            this.handleColumnDataType(column);
            columnList.add(column);
        }
        return columnList;
    }

    protected DataType findPlatformDataType(int javaSqlTypeNumber, String vendorsTypeName) {
        DataType dataType = DataTypeFactory.getSqlDataType((String)vendorsTypeName);
        if (dataType == null) {
            dataType = DataTypeFactory.getSqlDataType((int)javaSqlTypeNumber);
        }
        if ((dataType = DataTypeFactory.getPlatformDataType((DataType)dataType)) == null) {
            dataType = PlatformDataType.UNDEFINED;
        }
        return dataType;
    }
}

