/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.jakarta.dao.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.nexacro.uiadapter.jakarta.core.util.ReflectionUtil;
import com.nexacro.uiadapter.jakarta.dao.Dbms;
import com.nexacro.uiadapter.jakarta.dao.DbmsProvider;
import com.nexacro.uiadapter.jakarta.dao.ibatis.NexacroIbatisMetaDataGatherer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexacroIbatisMetaDataProvider {
    private static String SPRING_INTERFACE_NAME = "org.springframework.orm.ibatis.SqlMapClientCallback";
    private static String EGOVFRAMEWORK_INTERFACE_NAME = "egovframework.rte.psl.orm.ibatis.SqlMapClientCallback";
    private Logger logger = LoggerFactory.getLogger(NexacroIbatisMetaDataProvider.class);
    private DbmsProvider dbmsProvider;

    public DbmsProvider getDbmsProvider() {
        return this.dbmsProvider;
    }

    public void setDbmsProvider(DbmsProvider dbmsProvider) {
        this.dbmsProvider = dbmsProvider;
    }

    public Object getQueryMetaData(ProceedingJoinPoint pjp) throws Throwable {
        List listResult;
        Object target = pjp.getTarget();
        JoinPoint.StaticPart staticPart = pjp.getStaticPart();
        Object result = pjp.proceed();
        if (result instanceof List && (listResult = (List)result).size() == 0) {
            return this.doGetQueryMetaData(pjp.getTarget(), pjp.getArgs());
        }
        return result;
    }

    public Object doGetQueryMetaData(Object daoObject, Object[] arguments) {
        if (arguments == null || arguments.length < 2) {
            return new ArrayList();
        }
        Class<?> daoClass = daoObject.getClass();
        String statementName = (String)arguments[0];
        Object parameterObject = arguments[1];
        Object sqlMapClientTemplate = null;
        Object sqlMapClientCallback = null;
        Method executeMethod = null;
        try {
            Method getSqlMapClientTemplateMethod = ReflectionUtil.getMethod(daoClass, (String)"getSqlMapClientTemplate", (Class[])new Class[0]);
            if (getSqlMapClientTemplateMethod == null) {
                throw new UnsupportedOperationException("getSqlMapClientTemplate method is null.");
            }
            sqlMapClientTemplate = getSqlMapClientTemplateMethod.invoke(daoObject, null);
            Method getDataSourceMethod = ReflectionUtil.getMethod(sqlMapClientTemplate.getClass(), (String)"getDataSource", (Class[])new Class[0]);
            if (getDataSourceMethod == null) {
                throw new UnsupportedOperationException("getDataSource method is null.");
            }
            DataSource dataSource = (DataSource)getDataSourceMethod.invoke(sqlMapClientTemplate, null);
            Dbms dbms = this.dbmsProvider.getDbms(dataSource);
            Method getSqlMapClientMethod = ReflectionUtil.getMethod(daoClass, (String)"getSqlMapClient", (Class[])new Class[0]);
            if (getSqlMapClientMethod == null) {
                throw new UnsupportedOperationException("getSqlMapClient method is null.");
            }
            SqlMapClient sqlMapClient = (SqlMapClient)getSqlMapClientMethod.invoke(daoObject, null);
            Class<?> findedSqlMapClientCallbackInterface = this.findSqlMapClientCallbackInterface();
            sqlMapClientCallback = this.createProxiedSqlMapClientCallback(dbms, sqlMapClient, statementName, parameterObject, findedSqlMapClientCallbackInterface);
            executeMethod = ReflectionUtil.getMethod(sqlMapClientTemplate.getClass(), (String)"execute", (Class[])new Class[]{findedSqlMapClientCallbackInterface});
        }
        catch (Throwable e) {
            this.logger.error("unsupported getting metadata. e={}", (Object)e.getMessage());
            return new ArrayList();
        }
        Object queryMetaData = null;
        try {
            queryMetaData = executeMethod.invoke(sqlMapClientTemplate, sqlMapClientCallback);
        }
        catch (Throwable e) {
            this.logger.error("an error has occurred while querying the metadata. e={}", (Object)e.getMessage());
            return new ArrayList();
        }
        return queryMetaData;
    }

    private Object createProxiedSqlMapClientCallback(Dbms dbms, SqlMapClient sqlMapClient, String statementName, Object parameterObject, Class<?> findedSqlMapClientCallbackInterface) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        NexacroIbatisMetaDataGatherer sqlMapClientCallbackImpl = new NexacroIbatisMetaDataGatherer(dbms, sqlMapClient, statementName, parameterObject);
        return Proxy.newProxyInstance(classLoader, new Class[]{findedSqlMapClientCallbackInterface}, (InvocationHandler)sqlMapClientCallbackImpl);
    }

    private Class<?> findSqlMapClientCallbackInterface() {
        Class<?> sqlMapClient = null;
        try {
            sqlMapClient = Class.forName(SPRING_INTERFACE_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (sqlMapClient == null) {
            try {
                sqlMapClient = Class.forName(EGOVFRAMEWORK_INTERFACE_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (sqlMapClient == null) {
                throw new UnsupportedOperationException("does not exist SqlMapClientCallback interface. unsupported getting metadata");
            }
        }
        return sqlMapClient;
    }
}

