/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.jakarta.dao.mybatis;

import com.nexacro.uiadapter.jakarta.core.data.metadata.NexacroMetaData;
import com.nexacro.uiadapter.jakarta.core.data.metadata.support.BeanMetaData;
import com.nexacro.uiadapter.jakarta.core.data.metadata.support.MapMetaData;
import com.nexacro.uiadapter.jakarta.core.data.metadata.support.UnsupportedMetaData;
import com.nexacro.uiadapter.jakarta.dao.mybatis.LookupResultSetMetaDataConfig;
import com.nexacro.uiadapter.jakarta.dao.mybatis.LookupResultSetMetaDataHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.NullCacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class NexacroMybatisMetaDataProvider
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(NexacroMybatisMetaDataProvider.class);
    private Properties properties = new Properties();
    private String ignoreProcedureZeroResult;

    private void setIgnoreProcedureZeroResult(String property) {
        this.ignoreProcedureZeroResult = property;
    }

    private String getIgnoreProcedureZeroResult() {
        return this.ignoreProcedureZeroResult;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.setIgnoreProcedureZeroResult(properties.getProperty("ignoreProcedureZeroResult"));
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args;
        MappedStatement ms;
        StatementType statementType;
        Object proceed = invocation.proceed();
        if (this.getIgnoreProcedureZeroResult() != null && (statementType = (ms = (MappedStatement)(args = invocation.getArgs())[0]).getStatementType()).name().equalsIgnoreCase("CALLABLE")) {
            logger.debug("ignoreProcedureZeroResult is enabled.");
            return proceed;
        }
        if (proceed instanceof List) {
            List list = (List)proceed;
            if (list.size() == 0) {
                return this.getNexacroMetaData(invocation);
            }
            if (((List)proceed).get(0) instanceof List) {
                ArrayList multiList = (ArrayList)proceed;
                int listSize = multiList.size();
                boolean isContainDataAll = true;
                boolean[] isContainDataArr = new boolean[listSize];
                for (int idx = 0; idx < listSize; ++idx) {
                    if (((ArrayList)multiList.get(idx)).size() == 0) {
                        isContainDataArr[idx] = false;
                        isContainDataAll = false;
                        continue;
                    }
                    isContainDataArr[idx] = true;
                }
                if (!isContainDataAll) {
                    return this.getNexacroMetaDataMulti(invocation, proceed, isContainDataArr);
                }
            }
        }
        return proceed;
    }

    private Object getNexacroMetaData(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        List resultMaps = ms.getResultMaps();
        for (ResultMap resultMap : resultMaps) {
            if (this.requireExecuteQuery(resultMap)) continue;
            return this.generateMetaDataFromClass(resultMap.getType());
        }
        LookupResultSetMetaDataConfig config = new LookupResultSetMetaDataConfig(true, ms);
        LookupResultSetMetaDataHolder.setLookupResultSetMetaDataConfig(config);
        try {
            Executor executor = (Executor)invocation.getTarget();
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            BoundSql boundSql = ms.getBoundSql(parameter);
            NullCacheKey cacheKey = new NullCacheKey();
            List list = executor.query(ms, parameter, rowBounds, resultHandler, (CacheKey)cacheKey, boundSql);
            return list;
        }
        catch (Throwable e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("failed to query the metadata information. statement=" + ms.getId(), e);
            throw new RuntimeException(e);
        }
        finally {
            LookupResultSetMetaDataHolder.resetLookupResultSetMetaDataConfig();
        }
    }

    private Object getNexacroMetaDataMulti(Invocation invocation, Object proceed) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        LookupResultSetMetaDataConfig config = new LookupResultSetMetaDataConfig(true, ms);
        LookupResultSetMetaDataHolder.setLookupResultSetMetaDataConfig(config);
        try {
            List resultList;
            Executor executor = (Executor)invocation.getTarget();
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            BoundSql boundSql = ms.getBoundSql(parameter);
            NullCacheKey cacheKey = new NullCacheKey();
            List list = resultList = executor.query(ms, parameter, rowBounds, resultHandler, (CacheKey)cacheKey, boundSql);
            return list;
        }
        catch (Throwable e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("failed to query the metadata information. statement=" + ms.getId(), e);
            throw new RuntimeException(e);
        }
        finally {
            LookupResultSetMetaDataHolder.resetLookupResultSetMetaDataConfig();
        }
    }

    private Object getNexacroMetaDataMulti(Invocation invocation, Object proceed, boolean[] isContainDataArr) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        LookupResultSetMetaDataConfig config = new LookupResultSetMetaDataConfig(true, ms);
        LookupResultSetMetaDataHolder.setLookupResultSetMetaDataConfig(config);
        try {
            Executor executor = (Executor)invocation.getTarget();
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            BoundSql boundSql = ms.getBoundSql(parameter);
            NullCacheKey cacheKey = new NullCacheKey();
            List resultList = executor.query(ms, parameter, rowBounds, resultHandler, (CacheKey)cacheKey, boundSql);
            for (int idx = 0; idx < isContainDataArr.length; ++idx) {
                if (!isContainDataArr[idx]) continue;
                resultList.set(idx, ((ArrayList)proceed).get(idx));
            }
            List list = resultList;
            return list;
        }
        catch (Throwable e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("failed to query the metadata information. statement=" + ms.getId(), e);
            throw new RuntimeException(e);
        }
        finally {
            LookupResultSetMetaDataHolder.resetLookupResultSetMetaDataConfig();
        }
    }

    private List doGetMetaData(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) {
        BoundSql boundSql = ms.getBoundSql(parameter);
        Executor wrapper = executor;
        Configuration configuration = ms.getConfiguration();
        StatementHandler handler = configuration.newStatementHandler(wrapper, ms, parameter, rowBounds, resultHandler, boundSql);
        Statement stmt = null;
        try {
            Transaction transaction = executor.getTransaction();
            Connection connection = null;
            try {
                connection = transaction.getConnection();
            }
            catch (SQLException e) {
                logger.warn("getting connection failed for MetaData.", (Throwable)e);
                return new ArrayList();
            }
            stmt = handler.prepare(connection, null);
            handler.parameterize(stmt);
        }
        catch (SQLException e) {
            logger.warn("create statement and parameterize failed.", (Throwable)e);
            return new ArrayList();
        }
        try {
            handler.query(stmt, resultHandler);
        }
        catch (SQLException e) {
            logger.error("failed to query the metadata information. statement=" + ms.getId(), (Throwable)e);
        }
        return new ArrayList();
    }

    private boolean requireExecuteQuery(ResultMap resultMap) {
        Class resultClass = resultMap.getType();
        Boolean autoMapping = resultMap.getAutoMapping();
        return Map.class.isAssignableFrom(resultClass);
    }

    private NexacroMetaData generateMetaDataFromClass(Class clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            if (ClassUtils.isPrimitiveOrWrapper((Class)clazz)) {
                return new UnsupportedMetaData(null);
            }
            return new BeanMetaData(clazz);
        }
        return null;
    }

    private NexacroMetaData generateMetaDataFromMap(ResultMap resultMap) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (ResultMapping resultMapping : resultMap.getResultMappings()) {
            String column = resultMapping.getColumn();
            if (column == null) continue;
            columnMap.put(column.toUpperCase(Locale.ENGLISH), "");
        }
        return new MapMetaData(columnMap);
    }
}

