/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.boot.excel.servlet;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.impl.PlatformXmlDataDeserializer;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartReqData;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class XeniMultipartHandler
implements XeniMultipartProcBase {
    private Logger logger = LoggerFactory.getLogger(XeniMultipartHandler.class);

    public XeniMultipartReqData getImportData(HttpServletRequest servletRequest) throws Exception {
        XeniMultipartReqData requestData = new XeniMultipartReqData();
        if (!(servletRequest instanceof MultipartHttpServletRequest)) {
            throw new IllegalArgumentException("Request is not a MultipartHttpServletRequest");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)servletRequest;
        PlatformData platformData = this.findPlatformData(multipartRequest);
        requestData.setPlatformData(platformData);
        String sName = null;
        ByteArrayInputStream insFile = null;
        Map fileMap = multipartRequest.getFileMap();
        Set keySet = fileMap.keySet();
        for (String name : keySet) {
            MultipartFile multipartFile = (MultipartFile)fileMap.get(name);
            sName = multipartFile.getOriginalFilename();
            int nIdx = (sName = sName.replaceAll("\\\\", "/")).lastIndexOf(47);
            if (nIdx >= 0) {
                sName = sName.substring(nIdx + 1);
            }
            InputStream in = multipartFile.getInputStream();
            insFile = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)in));
            in.close();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("File field " + name + " with file name " + sName + " detected.");
        }
        requestData.setFileName(sName);
        requestData.setFileStream(insFile);
        return requestData;
    }

    private PlatformData findPlatformData(MultipartHttpServletRequest multipartRequest) throws IOException, PlatformException {
        String parameterName = "ds_command";
        String parameter = multipartRequest.getParameter(parameterName);
        if (parameter == null || "".equals(parameter)) {
            throw new PlatformException("ds_command is Null !");
        }
        PlatformXmlDataDeserializer dataDes = new PlatformXmlDataDeserializer();
        PlatformData platformData = dataDes.readData((Reader)new StringReader(parameter), null, "UTF-8");
        if (platformData == null) {
            throw new PlatformException("PlatformData is Null !");
        }
        DataSet dsCmd = platformData.getDataSet("COMMAND");
        if (dsCmd == null) {
            return platformData;
        }
        String command = dsCmd.getString(0, "command");
        if (!"import".equalsIgnoreCase(command)) {
            throw new PlatformException("multipart request is supported only import");
        }
        return platformData;
    }
}

