/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.spring.dao.dbms;

import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.DataTypeFactory;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.uiadapter.spring.dao.AbstractDbms;
import com.nexacro.uiadapter.spring.dao.DbColumn;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Postgre
extends AbstractDbms {
    @Override
    public List<DbColumn> getDbColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<DbColumn> columnList = new ArrayList<DbColumn>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            if (columnName == null || columnName.equals("")) {
                columnName = resultSetMetaData.getColumnName(i);
            }
            String vendorsTypeName = resultSetMetaData.getColumnTypeName(i);
            String typeJavaClassName = resultSetMetaData.getColumnClassName(i);
            DataType dataType = DataTypeFactory.getSqlDataType((String)vendorsTypeName);
            if (dataType == null) {
                int javaSqlTypeNumber = resultSetMetaData.getColumnType(i);
                dataType = DataTypeFactory.getSqlDataType((int)javaSqlTypeNumber);
            }
            if ((dataType = DataTypeFactory.getPlatformDataType((DataType)dataType)) == null) {
                dataType = PlatformDataType.UNDEFINED;
            }
            int precision = resultSetMetaData.getPrecision(i);
            int scale = resultSetMetaData.getScale(i);
            int columnSize = resultSetMetaData.getColumnDisplaySize(i);
            DbColumn column = new DbColumn(columnName, dataType, columnSize, vendorsTypeName);
            column.setTypeJavaClassName(typeJavaClassName);
            column.setPrecision(precision);
            column.setScale(scale);
            this.handleColumnDataType(column);
            columnList.add(column);
        }
        return columnList;
    }

    @Override
    public void handleColumnDataType(DbColumn column) {
        if (column == null) {
            return;
        }
        String vendorsTypeName = column.getVendorsTypeName();
        if ("char".equals(vendorsTypeName) || "bpchar".equals(vendorsTypeName) || "varchar".equals(vendorsTypeName) || "text".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("bool".equals(vendorsTypeName) || "bit".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BOOLEAN);
        } else if ("int4".equals(vendorsTypeName) || "int2".equals(vendorsTypeName) || "serial".equals(vendorsTypeName) || "smallserial".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.INT);
        } else if ("int8".equals(vendorsTypeName) || "bigserial".equals(vendorsTypeName) || "oid".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.LONG);
        } else if ("float8".equals(vendorsTypeName) || "money".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DOUBLE);
        } else if ("float4".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.FLOAT);
        } else if ("numeric".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BIG_DECIMAL);
        } else if ("date".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.DATE);
        } else if (column.getVendorsTypeName().startsWith("time")) {
            column.setDataType(PlatformDataType.DATE_TIME);
            column.setSize(6);
            column.setDecimalDigit(null);
        } else if ("xml".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("bytea".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.BLOB);
        }
    }
}

