/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.spring.dao;

import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.uiadapter.spring.core.data.metadata.NexacroMetaData;
import com.nexacro.uiadapter.spring.core.data.metadata.support.BeanMetaData;
import com.nexacro.uiadapter.spring.core.data.metadata.support.MapMetaData;
import com.nexacro.uiadapter.spring.core.data.metadata.support.UnsupportedMetaData;
import com.nexacro.uiadapter.spring.core.data.support.NexacroConverterHelper;
import com.nexacro.uiadapter.spring.dao.DbColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ClassUtils;

public abstract class DbMetaDataGathererUtil {
    public static NexacroMetaData generateMetaDataFromClass(Class clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            if (ClassUtils.isPrimitiveOrWrapper((Class)clazz)) {
                return new UnsupportedMetaData(null);
            }
            return new BeanMetaData(clazz);
        }
        return null;
    }

    public static MapMetaData generateMetaDataFromDbColumns(List<DbColumn> dbColumns) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        for (DbColumn column : dbColumns) {
            String name = column.getName();
            DataType dataType = column.getDataType();
            Object defaultValue = NexacroConverterHelper.getDefaultMetaDataValue((DataType)dataType);
            mapData.put(name, defaultValue);
        }
        return new MapMetaData(mapData);
    }
}

