/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.spring.dao.mybatis;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.uiadapter.spring.core.data.NexacroFirstRowHandler;
import com.nexacro.uiadapter.spring.core.data.convert.NexacroConvertException;
import com.nexacro.uiadapter.spring.core.data.support.ObjectToDataSetConverter;
import com.nexacro.uiadapter.spring.dao.NexacroFirstRowException;
import java.util.Map;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

public class MybatisRowHandler
implements ResultHandler {
    private static final int DEFAULT_FIRSTROW_COUNT = 1000;
    private ObjectToDataSetConverter converter;
    private NexacroFirstRowHandler firstRowHandler;
    private String resultName;
    private int firstRowCount;
    private DataSet currentDataSet;
    private int currentCount = 0;

    public MybatisRowHandler(NexacroFirstRowHandler firstRowHandler, String resultName, int firstRowCount) {
        this.firstRowHandler = firstRowHandler;
        this.resultName = resultName;
        this.firstRowCount = firstRowCount;
        if (this.firstRowCount <= 0) {
            this.firstRowCount = 1000;
        }
        this.converter = new ObjectToDataSetConverter();
    }

    public void handleResult(ResultContext context) {
        Object valueObject = context.getResultObject();
        try {
            this.prepareDataSet(valueObject);
            this.addRow(valueObject);
            ++this.currentCount;
            if (this.currentCount % this.firstRowCount == 0) {
                this.sendDataSet();
            }
        }
        catch (PlatformException e) {
            throw new NexacroFirstRowException("could not send data. e=" + e.getMessage(), e);
        }
        catch (NexacroConvertException e) {
            throw new NexacroFirstRowException("object to dataset convert failed. e=" + e.getMessage(), e);
        }
    }

    public void sendRemainData() {
        DataSet remainDataSet = this.getDataSet();
        if (remainDataSet != null && remainDataSet.getRowCount() > 0) {
            try {
                this.firstRowHandler.sendDataSet(remainDataSet);
            }
            catch (PlatformException e) {
                throw new NexacroFirstRowException("could not send remain data. e=" + e.getMessage(), e);
            }
        }
    }

    private void sendDataSet() throws PlatformException {
        this.firstRowHandler.sendDataSet(this.currentDataSet);
    }

    private void addRow(Object valueObject) throws NexacroConvertException {
        if (valueObject instanceof Map) {
            this.converter.addRowIntoDataSet(this.currentDataSet, (Map)valueObject, false);
        } else {
            this.converter.addRowIntoDataSet(this.currentDataSet, valueObject);
        }
    }

    private void prepareDataSet(Object valueObject) throws NexacroConvertException {
        if (this.currentDataSet != null) {
            return;
        }
        this.currentDataSet = new DataSet(this.resultName != null ? this.resultName : "RESULT0");
        if (valueObject instanceof Map) {
            this.converter.addColumnIntoDataSet(this.currentDataSet, (Map)valueObject);
        } else {
            this.converter.addColumnIntoDataSet(this.currentDataSet, valueObject);
        }
    }

    public DataSet getDataSet() {
        return this.currentDataSet;
    }
}

