/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter.spring.dao.mybatis;

import com.nexacro.uiadapter.spring.core.data.metadata.NexacroMetaData;
import com.nexacro.uiadapter.spring.core.data.metadata.support.BeanMetaData;
import com.nexacro.uiadapter.spring.core.data.metadata.support.UnsupportedMetaData;
import com.nexacro.uiadapter.spring.dao.mybatis.LookupResultSetMetaDataConfig;
import com.nexacro.uiadapter.spring.dao.mybatis.LookupResultSetMetaDataHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.NullCacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class NexacroMybatisMetaDataProvider
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(NexacroMybatisMetaDataProvider.class);

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public Object intercept(Invocation invocation) throws Throwable {
        List list;
        Object proceed = invocation.proceed();
        if (proceed instanceof List && (list = (List)proceed).size() == 0) {
            return this.getNexacroMetaData(invocation);
        }
        return proceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNexacroMetaData(Invocation invocation) {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        List resultMaps = ms.getResultMaps();
        for (ResultMap resultMap : resultMaps) {
            if (this.requireExecuteQuery(resultMap)) continue;
            return this.generateMetaDataFromClass(resultMap.getType());
        }
        LookupResultSetMetaDataConfig config = new LookupResultSetMetaDataConfig(true, ms);
        LookupResultSetMetaDataHolder.setLookupResultSetMetaDataConfig(config);
        try {
            Executor executor = (Executor)invocation.getTarget();
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            BoundSql boundSql = ms.getBoundSql(parameter);
            NullCacheKey cacheKey = new NullCacheKey();
            List list = executor.query(ms, parameter, rowBounds, resultHandler, (CacheKey)cacheKey, boundSql);
            return list;
        }
        catch (Throwable e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("failed to query the metadata information. statement=" + ms.getId(), e);
        }
        finally {
            LookupResultSetMetaDataHolder.resetLookupResultSetMetaDataConfig();
        }
        return new ArrayList();
    }

    private List doGetMetaData(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) {
        BoundSql boundSql = ms.getBoundSql(parameter);
        Executor wrapper = executor;
        Configuration configuration = ms.getConfiguration();
        StatementHandler handler = configuration.newStatementHandler(wrapper, ms, parameter, rowBounds, resultHandler, boundSql);
        Statement stmt = null;
        try {
            Transaction transaction = executor.getTransaction();
            Connection connection = null;
            try {
                connection = transaction.getConnection();
            }
            catch (SQLException e) {
                logger.warn("getting connection failed for MetaData.", (Throwable)e);
                return new ArrayList();
            }
            stmt = handler.prepare(connection);
            handler.parameterize(stmt);
        }
        catch (SQLException e) {
            logger.warn("create statement and parameterize failed.", (Throwable)e);
            return new ArrayList();
        }
        try {
            handler.query(stmt, resultHandler);
        }
        catch (SQLException e) {
            logger.error("failed to query the metadata information. statement=" + ms.getId(), (Throwable)e);
        }
        return new ArrayList();
    }

    private boolean requireExecuteQuery(ResultMap resultMap) {
        Class resultClass = resultMap.getType();
        Boolean autoMapping = resultMap.getAutoMapping();
        return Map.class.isAssignableFrom(resultClass);
    }

    private NexacroMetaData generateMetaDataFromClass(Class clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            if (ClassUtils.isPrimitiveOrWrapper((Class)clazz)) {
                return new UnsupportedMetaData(null);
            }
            return new BeanMetaData(clazz);
        }
        return null;
    }
}

