/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter17.spring.dao;

import com.nexacro.uiadapter17.spring.dao.DbColumn;
import com.nexacro.uiadapter17.spring.dao.Dbms;
import com.nexacro17.xapi.data.datatype.DataType;
import com.nexacro17.xapi.data.datatype.DataTypeFactory;
import com.nexacro17.xapi.data.datatype.PlatformDataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDbms
implements Dbms {
    public abstract void handleColumnDataType(DbColumn var1);

    @Override
    public List<DbColumn> getDbColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<DbColumn> columnList = new ArrayList<DbColumn>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            if (columnName == null || columnName.equals("")) {
                columnName = resultSetMetaData.getColumnName(i);
            }
            String vendorsTypeName = resultSetMetaData.getColumnTypeName(i);
            String typeJavaClassName = resultSetMetaData.getColumnClassName(i);
            DataType dataType = DataTypeFactory.getSqlDataType((String)vendorsTypeName);
            if (dataType == null) {
                int javaSqlTypeNumber = resultSetMetaData.getColumnType(i);
                dataType = DataTypeFactory.getSqlDataType((int)javaSqlTypeNumber);
            }
            if ((dataType = DataTypeFactory.getPlatformDataType((DataType)dataType)) == null) {
                dataType = PlatformDataType.UNDEFINED;
            }
            int precision = resultSetMetaData.getPrecision(i);
            int scale = resultSetMetaData.getScale(i);
            int columnSize = resultSetMetaData.getColumnDisplaySize(i);
            DbColumn column = new DbColumn(columnName, dataType, columnSize, vendorsTypeName);
            column.setTypeJavaClassName(typeJavaClassName);
            column.setPrecision(precision);
            column.setScale(scale);
            this.handleColumnDataType(column);
            columnList.add(column);
        }
        return columnList;
    }

    protected DataType findPlatformDataType(int javaSqlTypeNumber, String vendorsTypeName) {
        DataType dataType = DataTypeFactory.getSqlDataType((String)vendorsTypeName);
        if (dataType == null) {
            dataType = DataTypeFactory.getSqlDataType((int)javaSqlTypeNumber);
        }
        if ((dataType = DataTypeFactory.getPlatformDataType((DataType)dataType)) == null) {
            dataType = PlatformDataType.UNDEFINED;
        }
        return dataType;
    }
}

