/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter17.spring.dao.mybatis;

import com.nexacro.uiadapter17.spring.core.context.SpringAppContext;
import com.nexacro.uiadapter17.spring.core.data.metadata.support.MapMetaData;
import com.nexacro.uiadapter17.spring.core.data.support.NexacroConverterHelper;
import com.nexacro.uiadapter17.spring.dao.DbColumn;
import com.nexacro.uiadapter17.spring.dao.DbMetaDataGathererUtil;
import com.nexacro.uiadapter17.spring.dao.DbVendorsProvider;
import com.nexacro.uiadapter17.spring.dao.Dbms;
import com.nexacro.uiadapter17.spring.dao.DbmsProvider;
import com.nexacro.uiadapter17.spring.dao.mybatis.LookupResultSetMetaDataConfig;
import com.nexacro.uiadapter17.spring.dao.mybatis.LookupResultSetMetaDataHolder;
import com.nexacro17.xapi.data.datatype.DataType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class NexacroMybatisResultSetHandler
implements Interceptor {
    private static DbmsProvider dbmsProvider;

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public Object intercept(Invocation invocation) throws Throwable {
        LookupResultSetMetaDataConfig config = LookupResultSetMetaDataHolder.getLookupResultSetMetaDataConfig();
        if (config != null && config.isSearchMetaData()) {
            Object[] args = invocation.getArgs();
            Statement statement = (Statement)args[0];
            return this.getMetaDataFromResultSet(config, statement);
        }
        return invocation.proceed();
    }

    private Object getMetaDataFromResultSet(LookupResultSetMetaDataConfig config, Statement statement) {
        MapMetaData generateMapMetaData;
        block3: {
            this.initDbmsProvider();
            generateMapMetaData = null;
            MappedStatement mappedStatement = config.getMappedStatement();
            try {
                ResultSet rs = statement.getResultSet();
                ResultSetMetaData metaData = rs.getMetaData();
                Connection connection = statement.getConnection();
                Dbms dbms = dbmsProvider.getDbms(connection);
                List<DbColumn> dbColumns = dbms.getDbColumns(metaData);
                List resultMaps = mappedStatement.getResultMaps();
                if (this.validResultMaps(resultMaps)) {
                    ResultMap resultMap = (ResultMap)resultMaps.get(0);
                    this.mappingDbColumnAndResultMappings(dbColumns, resultMap);
                }
                generateMapMetaData = DbMetaDataGathererUtil.generateMetaDataFromDbColumns(dbColumns);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                if (!logger.isErrorEnabled()) break block3;
                logger.error("failed to query the metadata information.", (Throwable)e);
            }
        }
        return generateMapMetaData;
    }

    private void mappingDbColumnAndResultMappings(List<DbColumn> dbColumns, ResultMap resultMap) {
        Class resultType = resultMap.getType();
        if (resultType != Map.class) {
            return;
        }
        List propertyMappings = resultMap.getPropertyResultMappings();
        if (propertyMappings.size() == 0) {
            return;
        }
        int size = dbColumns.size();
        block0: for (int i = size - 1; i >= 0; --i) {
            DbColumn dbColumn = dbColumns.get(i);
            String name = dbColumn.getName();
            boolean existColumn = false;
            for (ResultMapping propertyMapping : propertyMappings) {
                DataType dataType;
                Class javaType;
                String columnName = propertyMapping.getColumn();
                String propertyName = propertyMapping.getProperty();
                if (!name.equalsIgnoreCase(columnName) && !name.equalsIgnoreCase(propertyName)) continue;
                if (propertyName != null) {
                    dbColumn.setName(propertyName);
                }
                if ((javaType = propertyMapping.getJavaType()) != null && (dataType = NexacroConverterHelper.getDataType((Class)javaType)).getType() != 0) {
                    dbColumn.setDataType(dataType);
                }
                existColumn = true;
                continue block0;
            }
        }
    }

    private boolean validResultMaps(List<ResultMap> resultMaps) {
        return resultMaps != null && resultMaps.size() >= 1;
    }

    private boolean shouldApplyAutomaticMappings(ResultMap resultMap, boolean def) {
        return resultMap.getAutoMapping() != null ? resultMap.getAutoMapping() : def;
    }

    private void initDbmsProvider() {
        if (dbmsProvider != null) {
            return;
        }
        ApplicationContext applicationContext = SpringAppContext.getInstance().getApplicationContext();
        if (applicationContext != null) {
            dbmsProvider = (DbmsProvider)applicationContext.getBean("dbmsProvider");
        }
        if (dbmsProvider == null) {
            dbmsProvider = new DbVendorsProvider();
        }
    }

    protected Class<?> resolveInterface(Class<?> type) {
        Class classToCreate = type == List.class || type == Collection.class || type == Iterable.class ? ArrayList.class : (type == Map.class ? HashMap.class : (type == SortedSet.class ? TreeSet.class : (type == Set.class ? HashSet.class : type)));
        return classToCreate;
    }
}

