/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter17.spring.dao.dbms;

import com.nexacro.uiadapter17.spring.dao.AbstractDbms;
import com.nexacro.uiadapter17.spring.dao.DbColumn;
import com.nexacro17.xapi.data.datatype.PlatformDataType;
import java.math.BigDecimal;

public class Oracle
extends AbstractDbms {
    @Override
    public void handleColumnDataType(DbColumn column) {
        if (column == null) {
            return;
        }
        if ("VARCHAR2".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.STRING);
        } else if ("NUMBER".equals(column.getVendorsTypeName())) {
            if (Double.class.getName().equals(column.getTypeJavaClassName())) {
                column.setDataType(PlatformDataType.DOUBLE);
            } else if (BigDecimal.class.getName().equals(column.getTypeJavaClassName())) {
                if (column.getScale() > 0) {
                    column.setDataType(PlatformDataType.BIG_DECIMAL);
                } else {
                    column.setDataType(PlatformDataType.FLOAT);
                }
            } else {
                column.setDataType(PlatformDataType.INT);
            }
        } else if ("LONG".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.LONG);
        } else if (column.getVendorsTypeName().startsWith("INTERVAL YEAR")) {
            column.setDataType(PlatformDataType.DATE_TIME);
        } else if (column.getVendorsTypeName().startsWith("INTERVAL DAY")) {
            column.setDataType(PlatformDataType.DATE_TIME);
        } else if ("BFILE".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.BLOB);
        } else if ("BINARY_FLOAT".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.FLOAT);
        } else if ("BINARY_DOUBLE".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.DOUBLE);
        } else if (column.getVendorsTypeName().startsWith("TIMESTAMP")) {
            column.setDataType(PlatformDataType.DATE_TIME);
            column.setSize(6);
            column.setDecimalDigit(null);
        } else if ("NVARCHAR2".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.STRING);
            column.setSize(column.getSize() / 2);
        } else if ("NVARCHAR".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.STRING);
            column.setSize(column.getSize() / 2);
        } else if ("NCHAR".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.STRING);
            column.setSize(column.getSize() / 2);
        } else if ("SYS.XMLTYPE".equals(column.getVendorsTypeName())) {
            column.setDataType(PlatformDataType.STRING);
        } else if (column.getVendorsTypeName().endsWith("ROWID")) {
            column.setDataType(PlatformDataType.INT);
        } else if (column.getVendorsTypeName().endsWith("NCLOB")) {
            column.setDataType(PlatformDataType.STRING);
        }
        if (column.getVendorsTypeName().indexOf("(") > 0) {
            column.setVendorsTypeName(column.getVendorsTypeName().replaceAll("\\(.*\\)", ""));
        }
    }
}

