/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.uiadapter17.spring.dao.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.nexacro.uiadapter17.spring.core.data.metadata.NexacroMetaData;
import com.nexacro.uiadapter17.spring.core.data.metadata.support.MapMetaData;
import com.nexacro.uiadapter17.spring.core.data.metadata.support.UnsupportedMetaData;
import com.nexacro.uiadapter17.spring.core.data.support.NexacroConverterHelper;
import com.nexacro.uiadapter17.spring.dao.DbColumn;
import com.nexacro.uiadapter17.spring.dao.DbMetaDataGathererUtil;
import com.nexacro.uiadapter17.spring.dao.Dbms;
import com.nexacro17.xapi.data.datatype.DataType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexacroIbatisMetaDataGatherer
implements InvocationHandler {
    private Dbms dbms;
    private SqlMapClient sqlMapClient;
    private String statementName;
    private Object parameterObject;

    public NexacroIbatisMetaDataGatherer(Dbms dbms, SqlMapClient sqlMapClient, String statementName, Object parameterObject) {
        this.dbms = dbms;
        this.sqlMapClient = sqlMapClient;
        this.statementName = statementName;
        this.parameterObject = parameterObject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("doInSqlMapClient".equals(method.getName())) {
            return this.doInSqlMapClient((SqlMapExecutor)args[0]);
        }
        return null;
    }

    public NexacroMetaData doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
        UnsupportedMetaData nexacroMetaData;
        block4: {
            nexacroMetaData = null;
            try {
                SqlMapSession session = (SqlMapSession)executor;
                Connection currentConnection = session.getCurrentConnection();
                Method method = this.sqlMapClient.getClass().getMethod("getMappedStatement", String.class);
                MappedStatement mappedStatement = (MappedStatement)method.invoke((Object)this.sqlMapClient, this.statementName);
                SessionScope sessionScope = new SessionScope();
                StatementScope statementScope = new StatementScope(sessionScope);
                mappedStatement.initRequest(statementScope);
                Sql sql = mappedStatement.getSql();
                ParameterMap parameterMap = sql.getParameterMap(statementScope, this.parameterObject);
                ResultMap resultMap = mappedStatement.getResultMap();
                if (!this.requireExecuteQuery(resultMap)) {
                    return DbMetaDataGathererUtil.generateMetaDataFromClass(resultMap.getResultClass());
                }
                statementScope.setParameterMap(parameterMap);
                statementScope.setResultMap(resultMap);
                Object[] parameters = parameterMap.getParameterObjectValues(statementScope, this.parameterObject);
                String strSql = sql.getSql(statementScope, this.parameterObject);
                nexacroMetaData = this.executeQuery(statementScope, currentConnection, strSql, parameters);
                sql.cleanup(statementScope);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                if (!logger.isErrorEnabled()) break block4;
                logger.error("failed to query the metadata information. statement=" + this.statementName, (Throwable)e);
            }
        }
        if (nexacroMetaData == null) {
            nexacroMetaData = new UnsupportedMetaData(null);
        }
        return nexacroMetaData;
    }

    private MapMetaData executeQuery(StatementScope statementScope, Connection conn, String sqlString, Object[] parameters) throws Exception {
        Statement ps = null;
        ResultSet rs = null;
        MapMetaData generateMapMetaData = null;
        try {
            Integer rsType = statementScope.getStatement().getResultSetType();
            ps = rsType != null ? this.prepareStatement(statementScope.getSession(), conn, sqlString, rsType) : this.prepareStatement(statementScope.getSession(), conn, sqlString);
            this.setStatementTimeout(statementScope.getStatement(), ps);
            Integer fetchSize = statementScope.getStatement().getFetchSize();
            if (fetchSize != null) {
                ps.setFetchSize(fetchSize);
            }
            statementScope.getParameterMap().setParameters(statementScope, (PreparedStatement)ps, parameters);
            rs = ps.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            List<DbColumn> dbColumns = this.dbms.getDbColumns(metaData);
            ResultMap resultMap = statementScope.getResultMap();
            this.mappingDbColumnAndResultMappings(dbColumns, resultMap);
            generateMapMetaData = DbMetaDataGathererUtil.generateMetaDataFromDbColumns(dbColumns);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return generateMapMetaData;
    }

    private void mappingDbColumnAndResultMappings(List<DbColumn> dbColumns, ResultMap resultMap) {
        ResultMapping[] resultMappings = resultMap.getResultMappings();
        if (resultMappings == null) {
            return;
        }
        int size = dbColumns.size();
        for (int i = size - 1; i >= 0; --i) {
            DbColumn dbColumn = dbColumns.get(i);
            String name = dbColumn.getName();
            boolean existColumn = false;
            for (ResultMapping mapping : resultMappings) {
                DataType dataType;
                Class javaType;
                String columnName = mapping.getColumnName();
                String propertyName = mapping.getPropertyName();
                if (!name.equals(columnName) && !name.equals(propertyName)) continue;
                if (propertyName != null) {
                    dbColumn.setName(propertyName);
                }
                if ((javaType = mapping.getJavaType()) != null && (dataType = NexacroConverterHelper.getDataType((Class)javaType)).getType() != 0) {
                    dbColumn.setDataType(dataType);
                }
                existColumn = true;
                break;
            }
            if (existColumn) continue;
            dbColumns.remove(i);
        }
    }

    private void setStatementTimeout(MappedStatement mappedStatement, Statement statement) throws SQLException {
        if (mappedStatement.getTimeout() != null) {
            statement.setQueryTimeout(mappedStatement.getTimeout());
        }
    }

    private PreparedStatement prepareStatement(SessionScope sessionScope, Connection conn, String sql, Integer rsType) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        return ps;
    }

    private PreparedStatement prepareStatement(SessionScope sessionScope, Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        return ps;
    }

    private boolean requireExecuteQuery(ResultMap resultMap) {
        Class resultClass = resultMap.getResultClass();
        return Map.class.isAssignableFrom(resultClass);
    }
}

