package com.nexacro.uiadapter17.spring.dao.dbms;

import com.nexacro17.xapi.data.datatype.PlatformDataType;
import com.nexacro.uiadapter17.spring.dao.AbstractDbms;
import com.nexacro.uiadapter17.spring.dao.DbColumn;

/**
 * <p>Postgre에서 사용되는 데이터 타입과 <code>DataSet</code>의 데이터 타입간의 매핑 정보를 제공한다.
 *
 * @author Tobesoft
 * @since 11.10.2021
 * @version 1.0
 * @see
 */
public class Postgre extends AbstractDbms {

	// Postgre Mappings From SQL/JDBC Data Types to Java Data Types
	// https://www.instaclustr.com/postgresql-data-types-mappings-to-sql-jdbc-and-java-data-types/
	
    @Override
    public void handleColumnDataType(final DbColumn column) {
        if (column == null) {
            return;
        }
        
        final String vendorsTypeName = column.getVendorsTypeName();
        
        if("NUMERIC".equals(vendorsTypeName)) {
        	final String typeJavaClassName = column.getTypeJavaClassName();
            if("java.math.BigDecimal".equals(typeJavaClassName)) {
                column.setDataType(PlatformDataType.BIG_DECIMAL);
            }
        } else if ("REAL".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.FLOAT);
        } else if ("SQLXML".equals(vendorsTypeName)) {
            column.setDataType(PlatformDataType.STRING);
        }
        // 그 외 Postgre 타입의 경우 자동 변환은 수행하지 않는다.
    }
}
