/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.rfc2251.RfcAddRequest;
import com.novell.ldap.rfc2251.RfcDelRequest;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcModifyDNRequest;
import com.novell.ldap.rfc2251.RfcModifyRequest;

public class LDAPLburpRequest {
    LDAPMessage request;
    public int opType;

    public LDAPLburpRequest(LDAPMessage arequest) {
        this.request = arequest;
        this.opType = this.request.getASN1Object().getType();
    }

    public ASN1Sequence getRequestASN1Sequence() {
        ASN1Sequence rSeq = null;
        RfcLDAPMessage mess = this.request.getASN1Object();
        switch (mess.getType()) {
            case 8: {
                RfcAddRequest areq;
                rSeq = areq = (RfcAddRequest)mess.getRequest();
                break;
            }
            case 6: {
                RfcModifyRequest mreq = (RfcModifyRequest)mess.getRequest();
                rSeq = mreq;
                break;
            }
            case 12: {
                RfcModifyDNRequest nreq = (RfcModifyDNRequest)mess.getRequest();
                rSeq = nreq;
                break;
            }
        }
        return rSeq;
    }

    public ASN1OctetString getRequestASN1OcString() {
        RfcDelRequest rStr = null;
        RfcLDAPMessage mess = this.request.getASN1Object();
        if (mess.getType() == 10) {
            RfcDelRequest dreq;
            rStr = dreq = (RfcDelRequest)mess.getRequest();
        }
        return rStr;
    }

    public ASN1SequenceOf getControlsASN1Object() {
        return this.request.getASN1Object().getControls();
    }
}

