/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.istack.tools.DefaultAuthenticator;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.api.TJavaGeneratorExtension;
import com.sun.tools.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.JwsImplGenerator;
import com.sun.tools.ws.processor.generator.SeiGenerator;
import com.sun.tools.ws.processor.generator.ServiceGenerator;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.util.WSDLFetcher;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.FilerCodeWriter;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.Plugin;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.EntityResolver;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WsimportTool {
    private static final String JAXWS_MODULE = "java.xml.ws";
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    protected WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream out) {
        this(out, null);
    }

    public WsimportTool(OutputStream logStream, Container container) {
        this.out = logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream);
        this.container = container;
    }

    public boolean run(String[] args) {
        Listener listener = new Listener();
        Receiver receiver = new Receiver(listener);
        return this.run(args, listener, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean run(String[] args, Listener listener, Receiver receiver) {
        int n;
        for (String arg : args) {
            if (arg.equals("-version")) {
                listener.message(WscompileMessages.WSIMPORT_VERSION(ToolVersion.VERSION.MAJOR_VERSION));
                return true;
            }
            if (!arg.equals("-fullversion")) continue;
            listener.message(WscompileMessages.WSIMPORT_FULLVERSION(ToolVersion.VERSION.toString()));
            return true;
        }
        try {
            Model wsdlModel;
            block25: {
                this.parseArguments(args, listener, receiver);
                try {
                    wsdlModel = this.buildWsdlModel(listener, receiver);
                    if (wsdlModel != null) break block25;
                    n = 0;
                    return n != 0;
                }
                catch (IOException e) {
                    receiver.error(e);
                    n = 0;
                    return n != 0;
                }
                catch (XMLStreamException e) {
                    receiver.error(e);
                    n = 0;
                    return n != 0;
                }
            }
            if (!this.generateCode(listener, receiver, wsdlModel, true)) {
                n = 0;
                return n != 0;
            }
            if (!this.options.nocompile && !this.compileGeneratedClasses(receiver, listener)) {
                listener.message(WscompileMessages.WSCOMPILE_COMPILATION_FAILED());
                boolean e = false;
                return e;
            }
            try {
                if (this.options.clientjar != null) {
                    this.addClassesToGeneratedFiles();
                    this.jarArtifacts(listener);
                }
            }
            catch (IOException e) {
                receiver.error(e);
                n = 0;
                this.deleteGeneratedFiles();
                if (!this.options.disableAuthenticator) {
                    DefaultAuthenticator.reset();
                }
                return n != 0;
            }
        }
        catch (Options.WeAreDone done) {
            this.usage(done.getOptions());
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            this.usage(this.options);
            n = 0;
            return n != 0;
        }
        finally {
            this.deleteGeneratedFiles();
            if (!this.options.disableAuthenticator) {
                DefaultAuthenticator.reset();
            }
        }
        return !receiver.hadError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGeneratedFiles() {
        HashSet<File> trackedRootPackages = new HashSet<File>();
        if (this.options.clientjar != null) {
            boolean deleted;
            Iterable<File> generatedFiles = this.options.getGeneratedFiles();
            Iterable<File> iterable = generatedFiles;
            synchronized (iterable) {
                for (File file : generatedFiles) {
                    if (file.getName().endsWith(".java")) continue;
                    deleted = file.delete();
                    if (this.options.verbose && !deleted) {
                        System.out.println(MessageFormat.format("{0} could not be deleted.", file));
                    }
                    trackedRootPackages.add(file.getParentFile());
                }
            }
            for (File pkg : trackedRootPackages) {
                while (pkg != null && pkg.list() != null && pkg.list().length == 0 && !pkg.equals(this.options.destDir)) {
                    File parentPkg = pkg.getParentFile();
                    deleted = pkg.delete();
                    if (this.options.verbose && !deleted) {
                        System.out.println(MessageFormat.format("{0} could not be deleted.", pkg));
                    }
                    pkg = parentPkg;
                }
            }
        }
        if (!this.options.keep) {
            this.options.removeGeneratedFiles();
        }
    }

    private void addClassesToGeneratedFiles() throws IOException {
        Iterable<File> generatedFiles = this.options.getGeneratedFiles();
        final ArrayList trackedClassFiles = new ArrayList();
        for (File f : generatedFiles) {
            if (!f.getName().endsWith(".java")) continue;
            String relativeDir = DirectoryUtil.getRelativePathfromCommonBase(f.getParentFile(), this.options.sourceDir);
            final String className = f.getName().substring(0, f.getName().indexOf(".java"));
            File classDir = new File(this.options.destDir, relativeDir);
            if (!classDir.exists()) continue;
            classDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.equals(className + ".class") || name.startsWith(className + "$") && name.endsWith(".class")) {
                        trackedClassFiles.add(new File(dir, name));
                        return true;
                    }
                    return false;
                }
            });
        }
        for (File f : trackedClassFiles) {
            this.options.addGeneratedFile(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jarArtifacts(WsimportListener listener) throws IOException {
        File zipFile = new File(this.options.clientjar);
        if (!zipFile.isAbsolute()) {
            zipFile = new File(this.options.destDir, this.options.clientjar);
        }
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_ARCHIVING_ARTIFACTS(zipFile));
        }
        BufferedInputStream bis = null;
        FileInputStream fi = null;
        FileOutputStream fos = new FileOutputStream(zipFile);
        JarOutputStream jos = new JarOutputStream(fos);
        try {
            String base = this.options.destDir.getCanonicalPath();
            for (File f : this.options.getGeneratedFiles()) {
                int bytesRead;
                if (f.getName().endsWith(".java")) continue;
                if (this.options.verbose) {
                    listener.message(WscompileMessages.WSIMPORT_ARCHIVE_ARTIFACT(f, this.options.clientjar));
                }
                String entry = f.getCanonicalPath().substring(base.length() + 1).replace(File.separatorChar, '/');
                fi = new FileInputStream(f);
                bis = new BufferedInputStream(fi);
                JarEntry jarEntry = new JarEntry(entry);
                jos.putNextEntry(jarEntry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = bis.read(buffer)) != -1) {
                    jos.write(buffer, 0, bytesRead);
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            finally {
                if (jos != null) {
                    jos.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
        }
    }

    protected void parseArguments(String[] args, Listener listener, Receiver receiver) throws BadCommandLineException {
        this.options.parseArguments(args);
        this.options.validate();
        if (this.options.debugMode) {
            listener.enableDebugging();
        }
        this.options.parseBindings(receiver);
    }

    protected Model buildWsdlModel(Listener listener, final Receiver receiver) throws BadCommandLineException, XMLStreamException, IOException {
        WSDLModeler wsdlModeler;
        Model wsdlModel;
        if (!this.options.disableAuthenticator) {
            class AuthListener
            implements DefaultAuthenticator.Receiver {
                private final boolean isFatal;

                AuthListener(boolean isFatal) {
                    this.isFatal = isFatal;
                }

                public void onParsingError(String text, Locator loc) {
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(text), loc));
                }

                public void onError(Exception e, Locator loc) {
                    if (e instanceof FileNotFoundException) {
                        this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(loc.getSystemId(), WsimportOptions.defaultAuthfile), null));
                    } else {
                        this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(loc.getSystemId(), e.getMessage()), loc));
                    }
                }

                private void error(SAXParseException e) {
                    if (this.isFatal) {
                        receiver.error(e);
                    } else {
                        receiver.debug(e);
                    }
                }
            }
            DefaultAuthenticator da = DefaultAuthenticator.getAuthenticator();
            if (this.options.proxyAuth != null) {
                da.setProxyAuth(this.options.proxyAuth);
            }
            if (this.options.authFile != null) {
                da.setAuth(this.options.authFile, (DefaultAuthenticator.Receiver)new AuthListener(true));
            } else {
                da.setAuth(new File(WsimportOptions.defaultAuthfile), (DefaultAuthenticator.Receiver)new AuthListener(false));
            }
        }
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_PARSING_WSDL());
        }
        MetadataFinder forest = new MetadataFinder(new WSDLInternalizationLogic(), this.options, receiver);
        forest.parseWSDL();
        if (forest.isMexMetadata) {
            receiver.reset();
        }
        if ((wsdlModel = (wsdlModeler = new WSDLModeler(this.options, receiver, forest)).buildModel()) == null) {
            listener.message(WsdlMessages.PARSING_PARSE_FAILED());
        }
        if (this.options.clientjar != null) {
            if (!this.options.quiet) {
                listener.message(WscompileMessages.WSIMPORT_FETCHING_METADATA());
            }
            this.options.wsdlLocation = new WSDLFetcher(this.options, listener).fetchWsdls(forest);
        }
        return wsdlModel;
    }

    protected boolean generateCode(Listener listener, Receiver receiver, Model wsdlModel, boolean generateService) throws IOException {
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_GENERATING_CODE());
        }
        TJavaGeneratorExtension[] genExtn = (TJavaGeneratorExtension[])ServiceFinder.find(TJavaGeneratorExtension.class, ServiceLoader.load(TJavaGeneratorExtension.class)).toArray();
        CustomExceptionGenerator.generate(wsdlModel, this.options, receiver);
        SeiGenerator.generate(wsdlModel, this.options, receiver, genExtn);
        if (receiver.hadError()) {
            throw new AbortException();
        }
        if (generateService) {
            ServiceGenerator.generate(wsdlModel, this.options, receiver);
        }
        for (Object g : ServiceFinder.find(GeneratorBase.class, ServiceLoader.load(GeneratorBase.class))) {
            ((GeneratorBase)g).init(wsdlModel, this.options, receiver);
            ((GeneratorBase)g).doGeneration();
        }
        List<String> implFiles = null;
        if (this.options.isGenerateJWS) {
            implFiles = JwsImplGenerator.generate(wsdlModel, this.options, receiver);
        }
        for (Plugin plugin : this.options.activePlugins) {
            try {
                plugin.run(wsdlModel, this.options, receiver);
            }
            catch (SAXException sex) {
                return false;
            }
        }
        if (this.options.getModuleName() != null) {
            this.options.getCodeModel()._prepareModuleInfo(this.options.getModuleName(), new String[]{JAXWS_MODULE});
        }
        Object cw = this.options.filer != null ? new FilerCodeWriter(this.options) : new WSCodeWriter(this.options.sourceDir, this.options);
        if (this.options.verbose) {
            cw = new ProgressCodeWriter((CodeWriter)cw, this.out);
        }
        this.options.getCodeModel().build((CodeWriter)cw);
        if (this.options.isGenerateJWS) {
            return JwsImplGenerator.moveToImplDestDir(implFiles, this.options, receiver);
        }
        return true;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.options.entityResolver = resolver;
    }

    protected boolean compileGeneratedClasses(ErrorReceiver receiver, WsimportListener listener) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File f : this.options.getGeneratedFiles()) {
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.options.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            ArrayList<String> args = new ArrayList<String>();
            args.add("-d");
            args.add(classDir);
            args.add("-classpath");
            args.add(classpathString);
            if (this.options.debug) {
                args.add("-g");
            }
            if (this.options.encoding != null) {
                args.add("-encoding");
                args.add(this.options.encoding);
            }
            if (this.options.javacOptions != null) {
                args.addAll(this.options.getJavacOptions(args, listener));
            }
            for (int i = 0; i < sourceFiles.size(); ++i) {
                args.add((String)sourceFiles.get(i));
            }
            if (!this.options.quiet) {
                listener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            }
            if (this.options.verbose) {
                StringBuilder argstr = new StringBuilder();
                for (String arg : args) {
                    argstr.append(arg).append(" ");
                }
                listener.message("javac " + argstr.toString());
            }
            return JavaCompilerHelper.compile(args.toArray(new String[args.size()]), this.out, receiver);
        }
        return true;
    }

    private String createClasspathString() {
        StringBuilder classpathStr = new StringBuilder(System.getProperty("java.class.path"));
        for (String s : this.options.cmdlineJars) {
            classpathStr.append(File.pathSeparator);
            classpathStr.append(new File(s).toString());
        }
        return classpathStr.toString();
    }

    protected void usage(Options options) {
        WsimportOptions opts;
        List<Plugin> plugins;
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXTENSIONS());
        if (options != null && !(plugins = (opts = (WsimportOptions)options).getAllPlugins()).isEmpty()) {
            System.out.println(WscompileMessages.WSIMPORT_USAGE_PLUGINS());
            for (Plugin p : plugins) {
                System.out.println(p.getUsage());
            }
        }
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }

    protected class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        protected Listener() {
            this.cer = new ConsoleErrorReporter(WsimportTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsimportTool.this.out);
        }

        @Override
        public void generatedFile(String fileName) {
            this.message(fileName);
        }

        @Override
        public void message(String msg) {
            WsimportTool.this.out.println(msg);
        }

        @Override
        public void error(SAXParseException exception) {
            this.cer.error(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.cer.fatalError(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            this.cer.warning(exception);
        }

        @Override
        public void debug(SAXParseException exception) {
            this.cer.debug(exception);
        }

        @Override
        public void info(SAXParseException exception) {
            this.cer.info(exception);
        }

        public void enableDebugging() {
            this.cer.enableDebugging();
        }
    }

    protected class Receiver
    extends ErrorReceiverFilter {
        private Listener listener;

        public Receiver(Listener listener) {
            super(listener);
            this.listener = listener;
        }

        @Override
        public void info(SAXParseException exception) {
            if (WsimportTool.this.options.verbose) {
                super.info(exception);
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            if (!WsimportTool.this.options.quiet) {
                super.warning(exception);
            }
        }

        @Override
        public void pollAbort() throws AbortException {
            if (this.listener.isCanceled()) {
                throw new AbortException();
            }
        }

        @Override
        public void debug(SAXParseException exception) {
            if (WsimportTool.this.options.debugMode) {
                this.listener.debug(exception);
            }
        }
    }
}

