/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.StringOutput;
import java.io.IOException;

final class Base64 {
    private static final String Base64URL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static final String Base64Classic = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private Base64() {
    }

    public static void WriteBase64(StringOutput writer, byte[] data, int offset, int count, boolean padding) throws IOException {
        Base64.WriteBase64(writer, data, offset, count, true, padding);
    }

    public static void WriteBase64URL(StringOutput writer, byte[] data, int offset, int count, boolean padding) throws IOException {
        Base64.WriteBase64(writer, data, offset, count, false, padding);
    }

    private static void WriteBase64(StringOutput writer, byte[] data, int offset, int count, boolean classic, boolean padding) throws IOException {
        int i;
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset(" + offset + ") is less than 0 ");
        }
        if (offset > data.length) {
            throw new IllegalArgumentException("offset(" + offset + ") is more than " + data.length);
        }
        if (count < 0) {
            throw new IllegalArgumentException("count(" + count + ") is less than 0 ");
        }
        if (count > data.length) {
            throw new IllegalArgumentException("count(" + count + ") is more than " + data.length);
        }
        if (data.length - offset < count) {
            throw new IllegalArgumentException("data's length minus " + offset + "(" + (data.length - offset) + ") is less than " + count);
        }
        String alphabet = classic ? Base64Classic : Base64URL;
        int length = offset + count;
        byte[] buffer = new byte[32];
        int bufferOffset = 0;
        for (i = offset; i < length - 2; i += 3) {
            if (bufferOffset >= buffer.length) {
                writer.WriteAscii(buffer, 0, bufferOffset);
                bufferOffset = 0;
            }
            buffer[bufferOffset++] = (byte)alphabet.charAt(data[i] >> 2 & 0x3F);
            buffer[bufferOffset++] = (byte)alphabet.charAt(((data[i] & 3) << 4) + (data[i + 1] >> 4 & 0xF));
            buffer[bufferOffset++] = (byte)alphabet.charAt(((data[i + 1] & 0xF) << 2) + (data[i + 2] >> 6 & 3));
            buffer[bufferOffset++] = (byte)alphabet.charAt(data[i + 2] & 0x3F);
        }
        int lenmod3 = count % 3;
        if (lenmod3 != 0) {
            if (bufferOffset >= buffer.length) {
                writer.WriteAscii(buffer, 0, bufferOffset);
                bufferOffset = 0;
            }
            i = length - lenmod3;
            buffer[bufferOffset++] = (byte)alphabet.charAt(data[i] >> 2 & 0x3F);
            if (lenmod3 == 2) {
                buffer[bufferOffset++] = (byte)alphabet.charAt(((data[i] & 3) << 4) + (data[i + 1] >> 4 & 0xF));
                buffer[bufferOffset++] = (byte)alphabet.charAt((data[i + 1] & 0xF) << 2);
                if (padding) {
                    buffer[bufferOffset++] = 61;
                }
            } else {
                buffer[bufferOffset++] = (byte)alphabet.charAt((data[i] & 3) << 4);
                if (padding) {
                    buffer[bufferOffset++] = 61;
                    buffer[bufferOffset++] = 61;
                }
            }
        }
        if (bufferOffset >= 0) {
            writer.WriteAscii(buffer, 0, bufferOffset);
        }
    }
}

