/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.bean;

import com.weicoder.core.params.CoreParams;

public final class Pagination {
    private int total;
    private int page;
    private int size = CoreParams.PAGE_SIZE;

    public int getTotalPage() {
        return this.total < this.size ? 0 : (this.total % this.size == 0 ? this.total / this.size : this.total / this.size + 1);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStartPage() {
        return this.page - 5 > 0 ? this.page - 5 : 0;
    }

    public int getEndPage() {
        int current = this.getPage();
        int total = this.getTotalPage();
        return current == 1 || current < 6 ? (total > 10 ? 10 : total) : (current + 5 <= total ? current + 5 : total);
    }

    public int getMaxResults() {
        return (this.getPage() + 1) * this.getSize();
    }

    public int getFirstResult() {
        return this.getPage() * this.getSize();
    }
}

