/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class Cache<K, V> {
    private LoadingCache<K, V> cache;

    public Cache(long max, int init, int level, long refresh, long expire, final CacheLoad<K, V> load) {
        this.cache = CacheBuilder.newBuilder().maximumSize(max).initialCapacity(init).concurrencyLevel(level).refreshAfterWrite(refresh, TimeUnit.SECONDS).expireAfterAccess(expire, TimeUnit.SECONDS).build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return load.load(key);
            }
        });
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public V get(K key) {
        try {
            return (V)this.cache.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long size() {
        return this.cache.size();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.cache.asMap();
    }

    public void clean() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public void remove(K key) {
        this.cache.invalidate(key);
    }

    public static interface CacheLoad<K, V> {
        public V load(K var1);
    }
}

