/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.http;

import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.interfaces.Callback;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public final class HttpAsyncClient {
    private static final Log LOG = LogFactory.getLog(HttpAsyncClient.class);
    static final CloseableHttpAsyncClient CLIENT;

    public static void get(String url, Callback<String> callback) {
        HttpAsyncClient.get(url, callback, CommonParams.ENCODING);
    }

    public static void get(String url, Callback<String> callback, String charset) {
        HttpAsyncClient.download(url, (Callback<byte[]>)((Callback)result -> {
            if (callback != null) {
                callback.callback((Object)StringUtil.toString((byte[])result, (String)charset));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, final Callback<byte[]> callback) {
        HttpGet get = null;
        try {
            get = new HttpGet(url);
            get.addHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
            CLIENT.execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                public void completed(HttpResponse result) {
                    if (callback != null) {
                        try (InputStream in = result.getEntity().getContent();){
                            callback.callback((Object)IOUtil.read((InputStream)in));
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }

                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
    }

    public static void post(String url, Map<String, String> data, Callback<String> callback) {
        HttpAsyncClient.post(url, data, callback, CommonParams.ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(String url, Map<String, String> data, final Callback<String> callback, String charset) {
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            post.addHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
            if (EmptyUtil.isNotEmpty(data)) {
                List list = Lists.newList((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair(k, v)));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(list, charset));
            }
            CLIENT.execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                public void completed(HttpResponse result) {
                    if (callback != null) {
                        try (InputStream in = result.getEntity().getContent();){
                            callback.callback((Object)IOUtil.readString((InputStream)in));
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }

                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
    }

    private HttpAsyncClient() {
    }

    static {
        PoolingNHttpClientConnectionManager pool = null;
        try {
            pool = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor());
        }
        catch (IOReactorException e) {
            LOG.error((Throwable)e);
        }
        pool.setDefaultMaxPerRoute(SystemConstants.CPU_NUM * 10);
        pool.setMaxTotal(SystemConstants.CPU_NUM * 10);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setSocketTimeout(2000);
        config.setConnectTimeout(2000);
        config.setCircularRedirectsAllowed(false);
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager((NHttpClientConnectionManager)pool);
        builder.setMaxConnPerRoute(SystemConstants.CPU_NUM * 10);
        List headers = Lists.newList();
        headers.add(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", "text/xml,text/javascript,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        headers.add(new BasicHeader("Accept-Language", "zh-cn,zh;q=0.5"));
        headers.add(new BasicHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"));
        builder.setDefaultHeaders((Collection)headers);
        builder.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Charset.forName(CommonParams.ENCODING)).build());
        CLIENT = builder.build();
        CLIENT.start();
    }
}

