/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.http;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.core.params.CoreParams;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public final class HttpClient {
    private static final Log LOG = LogFactory.getLog(HttpClient.class);
    static final CloseableHttpClient CLIENT = HttpClient.init();

    public static CloseableHttpClient getClient() {
        return CLIENT;
    }

    public static String get(String url) {
        return HttpClient.get(url, CommonParams.ENCODING);
    }

    public static String get(String url, String charset) {
        return StringUtil.toString((byte[])HttpClient.download(url), (String)charset);
    }

    public static byte[] download(String url) {
        HttpGet get = null;
        try {
            LOG.debug("HttpClient get url={}", new Object[]{url});
            get = new HttpGet(url);
            byte[] byArray = IOUtil.read((InputStream)CLIENT.execute((HttpUriRequest)get).getEntity().getContent());
            return byArray;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static String post(String url, Map<String, Object> data) {
        return HttpClient.post(url, data, CommonParams.ENCODING);
    }

    public static String post(String url, Map<String, Object> data, Map<String, Object> header) {
        return HttpClient.post(url, data, header, CommonParams.ENCODING);
    }

    public static String post(String url, Map<String, Object> data, String charset) {
        return HttpClient.post(url, data, Maps.emptyMap(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, Object> data, Map<String, Object> header, String charset) {
        HttpPost post = null;
        try {
            Object list;
            post = new HttpPost(url);
            if (EmptyUtil.isNotEmpty(data)) {
                list = Lists.newList((int)data.size());
                data.forEach((arg_0, arg_1) -> HttpClient.lambda$post$0((List)list, arg_0, arg_1));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity((List)list, charset));
            }
            for (Map.Entry entry : header.entrySet()) {
                post.addHeader((String)entry.getKey(), Conversion.toString(entry.getValue()));
            }
            LOG.debug("HttpClient post url={} data={} header={} charset={}", new Object[]{url, data, header, charset});
            list = IOUtil.readString((InputStream)CLIENT.execute((HttpUriRequest)post).getEntity().getContent());
            return list;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
        return "";
    }

    private static CloseableHttpClient init() {
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
        pool.setDefaultMaxPerRoute(SystemConstants.CPU_NUM);
        pool.setMaxTotal(CoreParams.HTTP_MAX);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setSocketTimeout(CoreParams.HTTP_TIMEOUT);
        config.setConnectTimeout(CoreParams.HTTP_TIMEOUT);
        config.setCircularRedirectsAllowed(false);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager((HttpClientConnectionManager)pool);
        builder.setMaxConnPerRoute(SystemConstants.CPU_NUM);
        List headers = Lists.newList();
        headers.add(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", "text/xml,text/javascript,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        builder.setDefaultHeaders((Collection)headers);
        return builder.build();
    }

    private HttpClient() {
    }

    private static /* synthetic */ void lambda$post$0(List list, String k, Object v) {
        list.add(new BasicNameValuePair(k, Conversion.toString((Object)v)));
    }
}

