/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.EmptyUtil;
import java.util.List;
import java.util.Map;

public final class JsonEngine {
    public static boolean isJson(String json) {
        if (EmptyUtil.isEmpty((String)json)) {
            return false;
        }
        if (JsonEngine.isObject(json)) {
            return true;
        }
        return JsonEngine.isArray(json);
    }

    public static boolean isObject(String json) {
        if (EmptyUtil.isEmpty((String)json)) {
            return false;
        }
        if (json.startsWith("{") && json.endsWith("}")) {
            return true;
        }
        return json.equals("{}");
    }

    public static boolean isArray(String json) {
        if (EmptyUtil.isEmpty((String)json)) {
            return false;
        }
        if (json.startsWith("[{") && json.endsWith("}]")) {
            return true;
        }
        return json.equals("[]");
    }

    public static String toJson(Object obj) {
        return obj == null ? "" : JSON.toJSONString((Object)obj);
    }

    public static JSONArray toJSONArray(String json) {
        return JSON.parseArray((String)json);
    }

    public static JSONObject toJSONObject(String json) {
        return JSON.parseObject((String)json);
    }

    public static <E> E toBean(String json, Class<E> clazz) {
        return (E)(EmptyUtil.isEmpty((String)json) ? null : JSON.parseObject((String)json, clazz));
    }

    public static <E> List<E> toList(String json, Class<E> clazz) {
        return EmptyUtil.isEmpty((String)json) ? Lists.emptyList() : JSON.parseArray((String)json, clazz);
    }

    public static Map<String, Object> toMap(String json) {
        return JsonEngine.toBean(json, Map.class);
    }

    public static <E> Map<String, E> toMap(String json, Class<E> value) {
        Map map = JsonEngine.toBean(json, Map.class);
        if (EmptyUtil.isEmpty((Map)map)) {
            return Maps.newMap();
        }
        Map data = Maps.newMap((int)map.size());
        map.forEach((k, v) -> {
            Object val = null;
            val = v.equals(value) ? v : BeanUtil.copy((Object)v, (Class)value);
            data.put(k, val);
        });
        return data;
    }

    public static List<Object> toList(String json) {
        return JsonEngine.toList(json, Object.class);
    }

    private JsonEngine() {
    }
}

